/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.blas;

import org.bytedeco.cuda.cublas.cublasContext;
import org.bytedeco.cuda.cudart.CUstream_st;
import org.bytedeco.cuda.global.cublas;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.common.base.Preconditions;
import org.nd4j.jita.allocator.Allocator;
import org.nd4j.jita.allocator.impl.AtomicAllocator;
import org.nd4j.jita.allocator.pointers.cuda.cublasHandle_t;
import org.nd4j.linalg.api.blas.impl.BaseLevel1;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.ReduceOp;
import org.nd4j.linalg.api.ops.executioner.OpExecutionerUtil;
import org.nd4j.linalg.api.ops.impl.reduce.same.ASum;
import org.nd4j.linalg.api.ops.impl.reduce3.Dot;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.Axpy;
import org.nd4j.linalg.factory.DataTypeValidation;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.jcublas.CublasPointer;
import org.nd4j.linalg.jcublas.context.CudaContext;
import org.nd4j.linalg.jcublas.ops.executioner.CudaExecutioner;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.nd4j.nativeblas.Nd4jBlas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcublasLevel1
extends BaseLevel1 {
    private Allocator allocator = AtomicAllocator.getInstance();
    private Nd4jBlas nd4jBlas = (Nd4jBlas)Nd4j.factory().blas();
    private NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();
    private static Logger logger = LoggerFactory.getLogger(JcublasLevel1.class);

    protected float sdsdot(long N, float alpha, INDArray X, int incX, INDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected double dsdot(long N, INDArray X, int incX, INDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected float hdot(long N, INDArray X, int incX, INDArray Y, int incY) {
        DataTypeValidation.assertSameDataType((INDArray[])new INDArray[]{X, Y});
        float ret = 1.0f;
        Dot dot = new Dot(X, Y, new int[0]);
        Nd4j.getExecutioner().exec((ReduceOp)dot);
        ret = dot.getFinalResult().floatValue();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float sdot(long N, INDArray X, int incX, INDArray Y, int incY) {
        Preconditions.checkArgument((X.dataType() == DataType.FLOAT ? 1 : 0) != 0, (String)"Float dtype expected");
        DataTypeValidation.assertSameDataType((INDArray[])new INDArray[]{X, Y});
        Nd4j.getExecutioner().push();
        CudaContext ctx = this.allocator.getFlowController().prepareAction(null, X, Y);
        float ret = 1.0f;
        CublasPointer xCPointer = new CublasPointer(X, ctx);
        CublasPointer yCPointer = new CublasPointer(Y, ctx);
        cublasHandle_t handle = ctx.getCublasHandle();
        cublasContext cctx = new cublasContext((Pointer)handle);
        cublasHandle_t cublasHandle_t2 = handle;
        synchronized (cublasHandle_t2) {
            long result = cublas.cublasSetStream_v2((cublasContext)cctx, (CUstream_st)new CUstream_st(ctx.getCublasStream()));
            if (result != 0L) {
                throw new IllegalStateException("cublasSetStream failed");
            }
            FloatPointer resultPointer = new FloatPointer(new float[]{0.0f});
            result = cublas.cublasSdot_v2((cublasContext)cctx, (int)((int)N), (FloatPointer)((FloatPointer)xCPointer.getDevicePointer()), (int)incX, (FloatPointer)((FloatPointer)yCPointer.getDevicePointer()), (int)incY, (FloatPointer)resultPointer);
            if (result != 0L) {
                throw new IllegalStateException("cublasSdot_v2 failed. Error code: " + result);
            }
            ret = resultPointer.get();
        }
        this.allocator.registerAction(ctx, null, X, Y);
        return ret;
    }

    protected float hdot(long N, DataBuffer X, int offsetX, int incX, DataBuffer Y, int offsetY, int incY) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    protected float sdot(long N, DataBuffer X, int offsetX, int incX, DataBuffer Y, int offsetY, int incY) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double ddot(long N, INDArray X, int incX, INDArray Y, int incY) {
        double ret;
        cublasHandle_t handle;
        Preconditions.checkArgument((X.dataType() == DataType.DOUBLE ? 1 : 0) != 0, (String)"Double dtype expected");
        Nd4j.getExecutioner().push();
        CudaContext ctx = this.allocator.getFlowController().prepareAction(null, X, Y);
        CublasPointer xCPointer = new CublasPointer(X, ctx);
        CublasPointer yCPointer = new CublasPointer(Y, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getCublasHandle();
        synchronized (cublasHandle_t2) {
            cublasContext cctx = new cublasContext((Pointer)handle);
            cublas.cublasSetStream_v2((cublasContext)cctx, (CUstream_st)new CUstream_st(ctx.getCublasStream()));
            DoublePointer resultPointer = new DoublePointer(new double[]{0.0});
            cublas.cublasDdot_v2((cublasContext)cctx, (int)((int)N), (DoublePointer)((DoublePointer)xCPointer.getDevicePointer()), (int)incX, (DoublePointer)((DoublePointer)yCPointer.getDevicePointer()), (int)incY, (DoublePointer)resultPointer);
            ret = resultPointer.get();
        }
        this.allocator.registerAction(ctx, null, X, Y);
        return ret;
    }

    protected double ddot(long N, DataBuffer X, int offsetX, int incX, DataBuffer Y, int offsetY, int incY) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float snrm2(long N, INDArray X, int incX) {
        float ret;
        cublasHandle_t handle;
        Preconditions.checkArgument((X.dataType() == DataType.FLOAT ? 1 : 0) != 0, (String)"Float dtype expected");
        Nd4j.getExecutioner().push();
        CudaContext ctx = this.allocator.getFlowController().prepareAction(null, X);
        CublasPointer cAPointer = new CublasPointer(X, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getCublasHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublasContext)new cublasContext((Pointer)handle), (CUstream_st)new CUstream_st(ctx.getCublasStream()));
            FloatPointer resultPointer = new FloatPointer(new float[]{0.0f});
            cublas.cublasSnrm2_v2((cublasContext)new cublasContext((Pointer)handle), (int)((int)N), (FloatPointer)((FloatPointer)cAPointer.getDevicePointer()), (int)incX, (FloatPointer)resultPointer);
            ret = resultPointer.get();
        }
        this.allocator.registerAction(ctx, null, X);
        return ret;
    }

    protected float hasum(long N, INDArray X, int incX) {
        ASum asum = new ASum(X, new int[0]);
        Nd4j.getExecutioner().exec((ReduceOp)asum);
        float ret = asum.getFinalResult().floatValue();
        return ret;
    }

    protected float sasum(long N, INDArray X, int incX) {
        ASum asum = new ASum(X, new int[0]);
        Nd4j.getExecutioner().exec((ReduceOp)asum);
        float ret = asum.getFinalResult().floatValue();
        return ret;
    }

    protected float hasum(long N, DataBuffer X, int offsetX, int incX) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    protected float sasum(long N, DataBuffer X, int offsetX, int incX) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double dnrm2(long N, INDArray X, int incX) {
        double ret;
        cublasHandle_t handle;
        Preconditions.checkArgument((X.dataType() == DataType.DOUBLE ? 1 : 0) != 0, (String)"Double dtype expected");
        Nd4j.getExecutioner().push();
        CudaContext ctx = this.allocator.getFlowController().prepareAction(null, X);
        CublasPointer cAPointer = new CublasPointer(X, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getCublasHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublasContext)new cublasContext((Pointer)handle), (CUstream_st)new CUstream_st(ctx.getCublasStream()));
            DoublePointer resultPointer = new DoublePointer(new double[]{0.0});
            cublas.cublasDnrm2_v2((cublasContext)new cublasContext((Pointer)handle), (int)((int)N), (DoublePointer)((DoublePointer)cAPointer.getDevicePointer()), (int)incX, (DoublePointer)resultPointer);
            ret = resultPointer.get();
        }
        this.allocator.registerAction(ctx, null, X);
        return ret;
    }

    protected double dasum(long N, INDArray X, int incX) {
        ASum asum = new ASum(X, new int[0]);
        Nd4j.getExecutioner().exec((ReduceOp)asum);
        double ret = asum.getFinalResult().doubleValue();
        return ret;
    }

    protected double dasum(long N, DataBuffer X, int offsetX, int incX) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int isamax(long N, INDArray X, int incX) {
        int ret2;
        cublasHandle_t handle;
        Preconditions.checkArgument((X.dataType() == DataType.FLOAT ? 1 : 0) != 0, (String)"Float dtype expected");
        Nd4j.getExecutioner().push();
        CudaContext ctx = this.allocator.getFlowController().prepareAction(null, X);
        CublasPointer xCPointer = new CublasPointer(X, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getCublasHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublasContext)new cublasContext((Pointer)handle), (CUstream_st)new CUstream_st(ctx.getCublasStream()));
            IntPointer resultPointer = new IntPointer(new int[]{0});
            cublas.cublasIsamax_v2((cublasContext)new cublasContext((Pointer)handle), (int)((int)N), (FloatPointer)((FloatPointer)xCPointer.getDevicePointer()), (int)incX, (IntPointer)resultPointer);
            ret2 = resultPointer.get();
        }
        this.allocator.registerAction(ctx, null, X);
        return ret2 - 1;
    }

    protected int isamax(long N, DataBuffer X, int offsetX, int incX) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int idamax(long N, INDArray X, int incX) {
        int ret2;
        cublasHandle_t handle;
        Preconditions.checkArgument((X.dataType() == DataType.DOUBLE ? 1 : 0) != 0, (String)"Double dtype expected");
        Nd4j.getExecutioner().push();
        CudaContext ctx = this.allocator.getFlowController().prepareAction(null, X);
        CublasPointer xCPointer = new CublasPointer(X, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getCublasHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublasContext)new cublasContext((Pointer)handle), (CUstream_st)new CUstream_st(ctx.getCublasStream()));
            IntPointer resultPointer = new IntPointer(new int[]{0});
            cublas.cublasIdamax_v2((cublasContext)new cublasContext((Pointer)handle), (int)((int)N), (DoublePointer)((DoublePointer)xCPointer.getDevicePointer()), (int)incX, (IntPointer)resultPointer);
            ret2 = resultPointer.get();
        }
        this.allocator.registerAction(ctx, null, X);
        return ret2 - 1;
    }

    protected int idamax(long N, DataBuffer X, int offsetX, int incX) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sswap(long N, INDArray X, int incX, INDArray Y, int incY) {
        cublasHandle_t handle;
        Preconditions.checkArgument((X.dataType() == DataType.FLOAT ? 1 : 0) != 0, (String)"Float dtype expected");
        Nd4j.getExecutioner().push();
        CudaContext ctx = this.allocator.getFlowController().prepareAction(Y, X);
        CublasPointer xCPointer = new CublasPointer(X, ctx);
        CublasPointer yCPointer = new CublasPointer(Y, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getCublasHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublasContext)new cublasContext((Pointer)handle), (CUstream_st)new CUstream_st(ctx.getCublasStream()));
            cublas.cublasSswap_v2((cublasContext)new cublasContext((Pointer)handle), (int)((int)N), (FloatPointer)((FloatPointer)xCPointer.getDevicePointer()), (int)incX, (FloatPointer)((FloatPointer)yCPointer.getDevicePointer()), (int)incY);
        }
        this.allocator.registerAction(ctx, Y, X);
        OpExecutionerUtil.checkForAny((INDArray)Y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scopy(long N, INDArray X, int incX, INDArray Y, int incY) {
        cublasHandle_t handle;
        Preconditions.checkArgument((X.dataType() == DataType.FLOAT ? 1 : 0) != 0, (String)"Float dtype expected");
        Nd4j.getExecutioner().push();
        CudaContext ctx = this.allocator.getFlowController().prepareAction(Y, X);
        CublasPointer xCPointer = new CublasPointer(X, ctx);
        CublasPointer yCPointer = new CublasPointer(Y, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getCublasHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublasContext)new cublasContext((Pointer)handle), (CUstream_st)new CUstream_st(ctx.getCublasStream()));
            cublas.cublasScopy_v2((cublasContext)new cublasContext((Pointer)handle), (int)((int)N), (FloatPointer)((FloatPointer)xCPointer.getDevicePointer()), (int)incX, (FloatPointer)((FloatPointer)yCPointer.getDevicePointer()), (int)incY);
        }
        this.allocator.registerAction(ctx, Y, X);
        OpExecutionerUtil.checkForAny((INDArray)Y);
    }

    protected void scopy(long N, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    protected void saxpy(long N, float alpha, INDArray X, int incX, INDArray Y, int incY) {
        Nd4j.getExecutioner().exec((Op)new Axpy(X, Y, Y, (double)alpha));
        OpExecutionerUtil.checkForAny((INDArray)Y);
    }

    protected void haxpy(long N, float alpha, INDArray X, int incX, INDArray Y, int incY) {
        ((CudaExecutioner)Nd4j.getExecutioner()).exec((Op)new Axpy(X, Y, Y, (double)alpha));
        OpExecutionerUtil.checkForAny((INDArray)Y);
    }

    protected void haxpy(long N, float alpha, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    protected void saxpy(long N, float alpha, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dswap(long N, INDArray X, int incX, INDArray Y, int incY) {
        cublasHandle_t handle;
        Nd4j.getExecutioner().push();
        CudaContext ctx = this.allocator.getFlowController().prepareAction(Y, X);
        CublasPointer xCPointer = new CublasPointer(X, ctx);
        CublasPointer yCPointer = new CublasPointer(Y, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getCublasHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublasContext)new cublasContext((Pointer)handle), (CUstream_st)new CUstream_st(ctx.getCublasStream()));
            cublas.cublasDswap_v2((cublasContext)new cublasContext((Pointer)handle), (int)((int)N), (DoublePointer)((DoublePointer)xCPointer.getDevicePointer()), (int)incX, (DoublePointer)((DoublePointer)yCPointer.getDevicePointer()), (int)incY);
        }
        this.allocator.registerAction(ctx, Y, X);
        OpExecutionerUtil.checkForAny((INDArray)Y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dcopy(long N, INDArray X, int incX, INDArray Y, int incY) {
        cublasHandle_t handle;
        Nd4j.getExecutioner().push();
        CudaContext ctx = this.allocator.getFlowController().prepareAction(Y, X);
        CublasPointer xCPointer = new CublasPointer(X, ctx);
        CublasPointer yCPointer = new CublasPointer(Y, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getCublasHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublasContext)new cublasContext((Pointer)handle), (CUstream_st)new CUstream_st(ctx.getCublasStream()));
            cublas.cublasDcopy_v2((cublasContext)new cublasContext((Pointer)handle), (int)((int)N), (DoublePointer)((DoublePointer)xCPointer.getDevicePointer()), (int)incX, (DoublePointer)((DoublePointer)yCPointer.getDevicePointer()), (int)incY);
        }
        this.allocator.registerAction(ctx, Y, X);
        OpExecutionerUtil.checkForAny((INDArray)Y);
    }

    protected void dcopy(long N, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    protected void daxpy(long N, double alpha, INDArray X, int incX, INDArray Y, int incY) {
        Nd4j.getExecutioner().exec((Op)new Axpy(X, Y, Y, alpha));
        OpExecutionerUtil.checkForAny((INDArray)Y);
    }

    protected void daxpy(long N, double alpha, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    protected void srotg(float a, float b, float c, float s) {
        throw new UnsupportedOperationException();
    }

    protected void srotmg(float d1, float d2, float b1, float b2, INDArray P) {
        throw new UnsupportedOperationException();
    }

    protected void srot(long N, INDArray X, int incX, INDArray Y, int incY, float c, float s) {
        throw new UnsupportedOperationException();
    }

    protected void srotm(long N, INDArray X, int incX, INDArray Y, int incY, INDArray P) {
        throw new UnsupportedOperationException();
    }

    protected void drotg(double a, double b, double c, double s) {
        throw new UnsupportedOperationException();
    }

    protected void drotmg(double d1, double d2, double b1, double b2, INDArray P) {
        throw new UnsupportedOperationException();
    }

    protected void drot(long N, INDArray X, int incX, INDArray Y, int incY, double c, double s) {
        throw new UnsupportedOperationException();
    }

    protected void drotm(long N, INDArray X, int incX, INDArray Y, int incY, INDArray P) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sscal(long N, float alpha, INDArray X, int incX) {
        cublasHandle_t handle;
        Preconditions.checkArgument((X.dataType() == DataType.FLOAT ? 1 : 0) != 0, (String)"Float dtype expected");
        Nd4j.getExecutioner().push();
        CudaContext ctx = this.allocator.getFlowController().prepareAction(X, new INDArray[0]);
        CublasPointer xCPointer = new CublasPointer(X, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getCublasHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublasContext)new cublasContext((Pointer)handle), (CUstream_st)new CUstream_st(ctx.getCublasStream()));
            cublas.cublasSscal_v2((cublasContext)new cublasContext((Pointer)handle), (int)((int)N), (FloatPointer)new FloatPointer(new float[]{alpha}), (FloatPointer)((FloatPointer)xCPointer.getDevicePointer()), (int)incX);
        }
        this.allocator.registerAction(ctx, X, new INDArray[0]);
        OpExecutionerUtil.checkForAny((INDArray)X);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dscal(long N, double alpha, INDArray X, int incX) {
        cublasHandle_t handle;
        Preconditions.checkArgument((X.dataType() == DataType.DOUBLE ? 1 : 0) != 0, (String)"Double dtype expected");
        Nd4j.getExecutioner().push();
        CudaContext ctx = this.allocator.getFlowController().prepareAction(X, new INDArray[0]);
        CublasPointer xCPointer = new CublasPointer(X, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getCublasHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublasContext)new cublasContext((Pointer)handle), (CUstream_st)new CUstream_st(ctx.getCublasStream()));
            cublas.cublasDscal_v2((cublasContext)new cublasContext((Pointer)handle), (int)((int)N), (DoublePointer)new DoublePointer(new double[]{alpha}), (DoublePointer)((DoublePointer)xCPointer.getDevicePointer()), (int)incX);
        }
        this.allocator.registerAction(ctx, X, new INDArray[0]);
        OpExecutionerUtil.checkForAny((INDArray)X);
    }

    public boolean supportsDataBufferL1Ops() {
        return false;
    }
}

