/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.config.ConfigurationException;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.context.MuleContextAware;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.exception.MessagingExceptionHandlerAcceptor;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.springframework.beans.factory.SmartFactoryBean;

public class MuleConfigurationConfigurator
implements MuleContextAware,
SmartFactoryBean {
    private MuleContext muleContext;
    private DefaultMuleConfiguration config = new DefaultMuleConfiguration();
    protected transient Log logger = LogFactory.getLog(MuleConfigurationConfigurator.class);

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public boolean isEagerInit() {
        return true;
    }

    public boolean isPrototype() {
        return false;
    }

    public Object getObject() throws Exception {
        MuleConfiguration configuration = this.muleContext.getConfiguration();
        if (configuration instanceof DefaultMuleConfiguration) {
            DefaultMuleConfiguration defaultConfig = (DefaultMuleConfiguration)configuration;
            defaultConfig.setDefaultResponseTimeout(this.config.getDefaultResponseTimeout());
            defaultConfig.setDefaultTransactionTimeout(this.config.getDefaultTransactionTimeout());
            defaultConfig.setShutdownTimeout(this.config.getShutdownTimeout());
            defaultConfig.setUseExtendedTransformations(this.config.useExtendedTransformations());
            defaultConfig.setFlowEndingWithOneWayEndpointReturnsNull(this.config.isFlowEndingWithOneWayEndpointReturnsNull());
            defaultConfig.setDefaultExceptionStrategyName(this.config.getDefaultExceptionStrategyName());
            defaultConfig.setEnricherPropagatesSessionVariableChanges(this.config.isEnricherPropagatesSessionVariableChanges());
            this.validateDefaultExceptionStrategy();
            return configuration;
        }
        throw new ConfigurationException(MessageFactory.createStaticMessage((String)("Unable to set properties on read-only MuleConfiguration: " + configuration.getClass())));
    }

    private void validateDefaultExceptionStrategy() {
        String defaultExceptionStrategyName = this.config.getDefaultExceptionStrategyName();
        if (defaultExceptionStrategyName != null) {
            MessagingExceptionHandlerAcceptor messagingExceptionHandlerAcceptor;
            MessagingExceptionHandler messagingExceptionHandler = (MessagingExceptionHandler)this.muleContext.getRegistry().lookupObject(defaultExceptionStrategyName);
            if (messagingExceptionHandler == null) {
                throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)String.format("No global exception strategy defined with name %s.", defaultExceptionStrategyName)));
            }
            if (messagingExceptionHandler instanceof MessagingExceptionHandlerAcceptor && !(messagingExceptionHandlerAcceptor = (MessagingExceptionHandlerAcceptor)messagingExceptionHandler).acceptsAll()) {
                throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)"Default exception strategy must not have expression attribute. It must accept any message."));
            }
        }
    }

    public Class<?> getObjectType() {
        return MuleConfiguration.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setDefaultSynchronousEndpoints(boolean synchronous) {
        this.config.setDefaultSynchronousEndpoints(synchronous);
    }

    public void setDefaultResponseTimeout(int responseTimeout) {
        this.config.setDefaultResponseTimeout(responseTimeout);
    }

    public void setDefaultTransactionTimeout(int defaultTransactionTimeout) {
        this.config.setDefaultTransactionTimeout(defaultTransactionTimeout);
    }

    public void setShutdownTimeout(int shutdownTimeout) {
        this.config.setShutdownTimeout(shutdownTimeout);
    }

    public void setDefaultExceptionStrategyName(String defaultExceptionStrategyName) {
        this.config.setDefaultExceptionStrategyName(defaultExceptionStrategyName);
    }

    public void setUseExtendedTransformations(boolean resolveNonDirectTransformations) {
        this.config.setUseExtendedTransformations(resolveNonDirectTransformations);
    }

    public void setFlowEndingWithOneWayEndpointReturnsNull(boolean flowEndingWithOneWayEndpointReturnsNull) {
        this.config.setFlowEndingWithOneWayEndpointReturnsNull(flowEndingWithOneWayEndpointReturnsNull);
    }

    public void setEnricherPropagatesSessionVariableChanges(boolean enricherPropagatesSessionVariableChanges) {
        this.config.setEnricherPropagatesSessionVariableChanges(enricherPropagatesSessionVariableChanges);
    }
}

