/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.runner;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.transaction.UserTransaction;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.plus.jndi.Resource;
import org.eclipse.jetty.plus.jndi.Transaction;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ShutdownMonitor;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.StatisticsServlet;
import org.eclipse.jetty.util.RolloverFileOutputStream;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.TagLibConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.mortbay.jetty.runner.Monitor;

public class Runner {
    private static final Logger LOG = Log.getLogger(Runner.class);
    public static final String[] __plusConfigurationClasses = new String[]{WebInfConfiguration.class.getCanonicalName(), WebXmlConfiguration.class.getCanonicalName(), MetaInfConfiguration.class.getCanonicalName(), FragmentConfiguration.class.getCanonicalName(), EnvConfiguration.class.getCanonicalName(), PlusConfiguration.class.getCanonicalName(), AnnotationConfiguration.class.getCanonicalName(), JettyWebXmlConfiguration.class.getCanonicalName(), TagLibConfiguration.class.getCanonicalName()};
    public static final String __containerIncludeJarPattern = ".*/.*jsp-api-[^/]*\\.jar$|.*/.*jsp-[^/]*\\.jar$|.*/.*taglibs[^/]*\\.jar$|.*/.*jstl[^/]*\\.jar$|.*/.*jsf-impl-[^/]*\\.jar$|.*/.*javax.faces-[^/]*\\.jar$|.*/.*myfaces-impl-[^/]*\\.jar$|.*/.*jetty-runner-[^/]*\\.jar$";
    protected Server _server;
    protected Monitor _monitor;
    protected URLClassLoader _classLoader;
    protected List<URL> _classpath = new ArrayList<URL>();
    protected ContextHandlerCollection _contexts;
    protected RequestLogHandler _logHandler;
    protected String _logFile;
    protected String _configFile;
    protected UserTransaction _ut;
    protected String _utId;
    protected String _txMgrPropertiesFile;
    protected Random _random = new Random();
    protected boolean _isTxServiceAvailable = false;
    protected boolean _enableStatsGathering = false;
    protected String _statsPropFile;
    protected boolean _clusteredSessions = true;

    public void usage(String error) {
        if (error != null) {
            System.err.println("ERROR: " + error);
        }
        System.err.println("Usage: java [-DDEBUG] [-Djetty.home=dir] -jar jetty-runner.jar [--help|--version] [ server opts] [[ context opts] context ...] ");
        System.err.println("Server Options:");
        System.err.println(" --version                          - display version and exit");
        System.err.println(" --log file                         - request log filename (with optional 'yyyy_mm_dd' wildcard");
        System.err.println(" --out file                         - info/warn/debug log filename (with optional 'yyyy_mm_dd' wildcard");
        System.err.println(" --port n                           - port to listen on (default 8080)");
        System.err.println(" --stop-port n                      - port to listen for stop command");
        System.err.println(" --stop-key n                       - security string for stop command (required if --stop-port is present)");
        System.err.println(" --jar file                         - a jar to be added to the classloader");
        System.err.println(" --jdbc classname properties jndiname - classname of XADataSource or driver; properties string; name to register in jndi");
        System.err.println(" --lib dir                          - a directory of jars to be added to the classloader");
        System.err.println(" --classes dir                      - a directory of classes to be added to the classloader");
        System.err.println(" --txFile                           - override properties file for Atomikos");
        System.err.println(" --stats [unsecure|realm.properties] - enable stats gathering servlet context");
        System.err.println(" --config file                      - a jetty xml config file to use instead of command line options");
        System.err.println("Context Options:");
        System.err.println(" --path /path       - context path (default /)");
        System.err.println(" context            - WAR file, web app dir or context.xml file");
        System.exit(1);
    }

    public void configure(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if ("--version".equals(args[i])) {
                // empty if block
            }
            if ("--lib".equals(args[i])) {
                org.eclipse.jetty.util.resource.Resource lib;
                if (!(lib = org.eclipse.jetty.util.resource.Resource.newResource(args[++i])).exists() || !lib.isDirectory()) {
                    this.usage("No such lib directory " + lib);
                }
                this.expandJars(lib);
                continue;
            }
            if ("--jar".equals(args[i])) {
                org.eclipse.jetty.util.resource.Resource jar;
                if (!(jar = org.eclipse.jetty.util.resource.Resource.newResource(args[++i])).exists() || jar.isDirectory()) {
                    this.usage("No such jar " + jar);
                }
                this._classpath.add(jar.getURL());
                continue;
            }
            if ("--classes".equals(args[i])) {
                org.eclipse.jetty.util.resource.Resource classes;
                if (!(classes = org.eclipse.jetty.util.resource.Resource.newResource(args[++i])).exists() || !classes.isDirectory()) {
                    this.usage("No such classes directory " + classes);
                }
                this._classpath.add(classes.getURL());
                continue;
            }
            if (!args[i].startsWith("--")) continue;
            ++i;
        }
        this.initClassLoader();
        try {
            if (Thread.currentThread().getContextClassLoader().loadClass("com.atomikos.icatch.jta.UserTransactionImp") != null) {
                this._isTxServiceAvailable = true;
            }
        }
        catch (ClassNotFoundException e) {
            this._isTxServiceAvailable = false;
        }
        if (System.getProperties().containsKey("DEBUG")) {
            Log.getLog().setDebugEnabled(true);
        }
        LOG.info("Runner", new Object[0]);
        LOG.debug("Runner classpath {}", this._classpath);
        String contextPath = "/";
        boolean contextPathSet = false;
        int port = 8080;
        int stopPort = 0;
        String stopKey = null;
        boolean transactionManagerProcessed = false;
        boolean runnerServerInitialized = false;
        for (int i = 0; i < args.length; ++i) {
            org.eclipse.jetty.util.resource.Resource ctx;
            if ("--port".equals(args[i])) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("--stop-port".equals(args[i])) {
                stopPort = Integer.parseInt(args[++i]);
                continue;
            }
            if ("--stop-key".equals(args[i])) {
                stopKey = args[++i];
                continue;
            }
            if ("--log".equals(args[i])) {
                this._logFile = args[++i];
                continue;
            }
            if ("--out".equals(args[i])) {
                String outFile = args[++i];
                PrintStream out = new PrintStream(new RolloverFileOutputStream(outFile, true, -1));
                LOG.info("Redirecting stderr/stdout to " + outFile, new Object[0]);
                System.setErr(out);
                System.setOut(out);
                continue;
            }
            if ("--path".equals(args[i])) {
                contextPath = args[++i];
                contextPathSet = true;
                continue;
            }
            if ("--config".equals(args[i])) {
                this._configFile = args[++i];
                continue;
            }
            if ("--lib".equals(args[i])) {
                ++i;
                continue;
            }
            if ("--jar".equals(args[i])) {
                ++i;
                continue;
            }
            if ("--classes".equals(args[i])) {
                ++i;
                continue;
            }
            if ("--stats".equals(args[i])) {
                this._enableStatsGathering = true;
                this._statsPropFile = args[++i];
                this._statsPropFile = "unsecure".equalsIgnoreCase(this._statsPropFile) ? null : this._statsPropFile;
                continue;
            }
            if ("--txFile".equals(args[i])) {
                this._txMgrPropertiesFile = args[++i];
                continue;
            }
            if ("--jdbc".equals(args[i])) {
                i = this.configJDBC(args, i);
                continue;
            }
            if (!transactionManagerProcessed) {
                this.processTransactionManagement();
                transactionManagerProcessed = true;
            }
            if (!runnerServerInitialized) {
                Connector[] connectors;
                HandlerCollection handlers;
                if (this._server == null) {
                    this._server = new Server();
                }
                this._server.setAttribute("org.eclipse.jetty.webapp.configuration", __plusConfigurationClasses);
                if (this._configFile != null) {
                    XmlConfiguration xmlConfiguration = new XmlConfiguration(org.eclipse.jetty.util.resource.Resource.newResource(this._configFile).getURL());
                    xmlConfiguration.configure(this._server);
                }
                if ((handlers = this._server.getChildHandlerByClass(HandlerCollection.class)) == null) {
                    handlers = new HandlerCollection();
                    this._server.setHandler(handlers);
                }
                this._contexts = handlers.getChildHandlerByClass(ContextHandlerCollection.class);
                if (this._contexts == null) {
                    this._contexts = new ContextHandlerCollection();
                    this.prependHandler(this._contexts, handlers);
                }
                if (this._enableStatsGathering && handlers.getChildHandlerByClass(StatisticsHandler.class) == null) {
                    StatisticsHandler statsHandler = new StatisticsHandler();
                    this.prependHandler(statsHandler, handlers);
                    ServletContextHandler statsContext = new ServletContextHandler(this._contexts, "/stats");
                    statsContext.addServlet(new ServletHolder(new StatisticsServlet()), "/");
                    statsContext.setSessionHandler(new SessionHandler());
                    if (this._statsPropFile != null) {
                        HashLoginService loginService = new HashLoginService("StatsRealm", this._statsPropFile);
                        Constraint constraint = new Constraint();
                        constraint.setName("Admin Only");
                        constraint.setRoles(new String[]{"admin"});
                        constraint.setAuthenticate(true);
                        ConstraintMapping cm = new ConstraintMapping();
                        cm.setConstraint(constraint);
                        cm.setPathSpec("/*");
                        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
                        securityHandler.setLoginService(loginService);
                        securityHandler.setConstraintMappings(Collections.singletonList(cm));
                        securityHandler.setAuthenticator(new BasicAuthenticator());
                        statsContext.setSecurityHandler(securityHandler);
                    }
                }
                if (handlers.getChildHandlerByClass(DefaultHandler.class) == null) {
                    handlers.addHandler(new DefaultHandler());
                }
                this._logHandler = handlers.getChildHandlerByClass(RequestLogHandler.class);
                if (this._logHandler == null) {
                    this._logHandler = new RequestLogHandler();
                    handlers.addHandler(this._logHandler);
                }
                if ((connectors = this._server.getConnectors()) == null || connectors.length == 0) {
                    SelectChannelConnector connector = new SelectChannelConnector();
                    connector.setPort(port);
                    this._server.addConnector(connector);
                    if (this._enableStatsGathering) {
                        connector.setStatsOn(true);
                    }
                } else if (this._enableStatsGathering) {
                    for (int j = 0; j < connectors.length; ++j) {
                        connectors[j].setStatsOn(true);
                    }
                }
                runnerServerInitialized = true;
            }
            if (!(ctx = org.eclipse.jetty.util.resource.Resource.newResource(args[i])).exists()) {
                this.usage("Context '" + ctx + "' does not exist");
            }
            if (!ctx.isDirectory() && ctx.toString().toLowerCase().endsWith(".xml")) {
                XmlConfiguration xmlConfiguration = new XmlConfiguration(ctx.getURL());
                xmlConfiguration.getIdMap().put("Server", this._server);
                ContextHandler handler = (ContextHandler)xmlConfiguration.configure();
                this._contexts.addHandler(handler);
                if (contextPathSet) {
                    handler.setContextPath(contextPath);
                }
                handler.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", __containerIncludeJarPattern);
                continue;
            }
            if (contextPathSet && !contextPath.startsWith("/")) {
                contextPath = "/" + contextPath;
            }
            LOG.info("Deploying " + ctx.toString() + " @ " + contextPath, new Object[0]);
            WebAppContext webapp = new WebAppContext((HandlerContainer)this._contexts, ctx.toString(), contextPath);
            webapp.setConfigurationClasses(__plusConfigurationClasses);
            webapp.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", __containerIncludeJarPattern);
        }
        if (this._server == null) {
            this.usage("No Contexts defined");
        }
        this._server.setStopAtShutdown(true);
        switch ((stopPort > 0 ? 1 : 0) + (stopKey != null ? 2 : 0)) {
            case 1: {
                this.usage("Must specify --stop-key when --stop-port is specified");
                break;
            }
            case 2: {
                this.usage("Must specify --stop-port when --stop-key is specified");
                break;
            }
            case 3: {
                ShutdownMonitor monitor = ShutdownMonitor.getInstance();
                monitor.setPort(stopPort);
                monitor.setKey(stopKey);
                monitor.setExitVm(true);
            }
        }
        if (this._logFile != null) {
            NCSARequestLog requestLog = new NCSARequestLog(this._logFile);
            requestLog.setExtended(false);
            this._logHandler.setRequestLog(requestLog);
        }
    }

    protected void prependHandler(Handler handler, HandlerCollection handlers) {
        if (handler == null || handlers == null) {
            return;
        }
        Handler[] existing = handlers.getChildHandlers();
        Handler[] children = new Handler[existing.length + 1];
        children[0] = handler;
        System.arraycopy(existing, 0, children, 1, existing.length);
        handlers.setHandlers(children);
    }

    protected int configJDBC(String[] args, int i) throws Exception {
        String jdbcClass = null;
        String jdbcProperties = null;
        String jdbcJndiName = null;
        if (!this._isTxServiceAvailable) {
            LOG.warn("JDBC TX support not found on classpath", new Object[0]);
            i += 3;
        } else {
            jdbcClass = args[++i];
            jdbcProperties = args[++i];
            jdbcJndiName = args[++i];
            if (jdbcClass != null) {
                if (this.isXADataSource(jdbcClass)) {
                    Class<?> simpleDataSourceBeanClass = Thread.currentThread().getContextClassLoader().loadClass("com.atomikos.jdbc.SimpleDataSourceBean");
                    Object o = simpleDataSourceBeanClass.newInstance();
                    simpleDataSourceBeanClass.getMethod("setXaDataSourceClassName", String.class).invoke(o, jdbcClass);
                    simpleDataSourceBeanClass.getMethod("setXaDataSourceProperties", String.class).invoke(o, jdbcProperties);
                    simpleDataSourceBeanClass.getMethod("setUniqueResourceName", String.class).invoke(o, jdbcJndiName);
                    Resource jdbcResource = new Resource(jdbcJndiName, o);
                } else {
                    String[] props = jdbcProperties.split(";");
                    String user = null;
                    String password = null;
                    String url = null;
                    for (int j = 0; props != null && j < props.length; ++j) {
                        String[] pair = props[j].split("=");
                        if (pair != null && pair[0].equalsIgnoreCase("user")) {
                            user = pair[1];
                            continue;
                        }
                        if (pair != null && pair[0].equalsIgnoreCase("password")) {
                            password = pair[1];
                            continue;
                        }
                        if (pair == null || !pair[0].equalsIgnoreCase("url")) continue;
                        url = pair[1];
                    }
                    Class<?> nonXADataSourceBeanClass = Thread.currentThread().getContextClassLoader().loadClass("com.atomikos.jdbc.nonxa.NonXADataSourceBean");
                    Object o = nonXADataSourceBeanClass.newInstance();
                    nonXADataSourceBeanClass.getMethod("setDriverClassName", String.class).invoke(o, jdbcClass);
                    nonXADataSourceBeanClass.getMethod("setUniqueResourceName", String.class).invoke(o, jdbcJndiName);
                    nonXADataSourceBeanClass.getMethod("setUrl", String.class).invoke(o, url);
                    nonXADataSourceBeanClass.getMethod("setUser", String.class).invoke(o, user);
                    nonXADataSourceBeanClass.getMethod("setPassword", String.class).invoke(o, password);
                    Resource jdbcResource = new Resource(jdbcJndiName, o);
                }
            }
        }
        return i;
    }

    public void run() throws Exception {
        if (this._monitor != null) {
            this._monitor.start();
        }
        this._server.start();
        this._server.join();
    }

    protected void expandJars(org.eclipse.jetty.util.resource.Resource lib) throws IOException {
        String[] list = lib.list();
        if (list == null) {
            return;
        }
        for (String path : list) {
            if (".".equals(path) || "..".equals(path)) continue;
            org.eclipse.jetty.util.resource.Resource item = lib.addPath(path);
            if (item.isDirectory()) {
                this.expandJars(item);
                continue;
            }
            if (!path.toLowerCase().endsWith(".jar") && !path.toLowerCase().endsWith(".zip")) continue;
            URL url = item.getURL();
            this._classpath.add(url);
        }
    }

    protected void initClassLoader() {
        if (this._classLoader == null && this._classpath != null && this._classpath.size() > 0) {
            ClassLoader context = Thread.currentThread().getContextClassLoader();
            this._classLoader = context == null ? new URLClassLoader(this._classpath.toArray(new URL[this._classpath.size()])) : new URLClassLoader(this._classpath.toArray(new URL[this._classpath.size()]), context);
            Thread.currentThread().setContextClassLoader(this._classLoader);
        }
    }

    protected boolean isXADataSource(String classname) throws Exception {
        boolean isXA = false;
        for (Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(classname); !isXA && clazz != null; clazz = clazz.getSuperclass()) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; interfaces != null && !isXA && i < interfaces.length; ++i) {
                if (!interfaces[i].getCanonicalName().equals("javax.sql.XADataSource")) continue;
                isXA = true;
            }
        }
        LOG.debug(isXA ? "XA" : "!XA", new Object[0]);
        return isXA;
    }

    private void processTransactionManagement() throws Exception {
        if (!this._isTxServiceAvailable) {
            LOG.warn("No tx manager found", new Object[0]);
        } else {
            this._utId = Integer.toHexString(this._random.nextInt());
            if (this._txMgrPropertiesFile == null) {
                System.setProperty("com.atomikos.icatch.no_file", "true");
                File tmpDir = new File(System.getProperty("java.io.tmpdir"));
                tmpDir = new File(tmpDir, this._utId);
                tmpDir.mkdir();
                LOG.debug("Made " + tmpDir.getAbsolutePath(), new Object[0]);
                System.setProperty("com.atomikos.icatch.log_base_dir ", tmpDir.getCanonicalPath());
                System.setProperty("com.atomikos.icatch.console_file_name", "tm-debug.log");
                System.setProperty("com.atomikos.icatch.output_dir", tmpDir.getCanonicalPath());
                System.setProperty("com.atomikos.icatch.tm_unique_name", this._utId);
            } else {
                System.setProperty("com.atomikos.icatch.file", this._txMgrPropertiesFile);
            }
            Class<?> utsClass = Thread.currentThread().getContextClassLoader().loadClass("com.atomikos.icatch.jta.UserTransactionImp");
            Transaction transaction = new Transaction((UserTransaction)utsClass.newInstance());
        }
    }

    public static void main(String[] args) {
        Runner runner = new Runner();
        try {
            if (args.length > 0 && args[0].equalsIgnoreCase("--help")) {
                runner.usage(null);
            } else if (args.length > 0 && args[0].equalsIgnoreCase("--version")) {
                System.err.println("org.mortbay.jetty.Runner: " + Server.getVersion());
                System.exit(1);
            }
            runner.configure(args);
            runner.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            runner.usage(null);
        }
    }
}

