/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.el.ELContext;
import javax.el.ELManager;
import javax.el.ExpressionFactory;
import javax.el.ImportHandler;
import javax.el.Util;
import javax.el.ValueExpression;

public class ELProcessor {
    private final ELManager manager = new ELManager();
    private final ELContext context = this.manager.getELContext();
    private final ExpressionFactory factory = ELManager.getExpressionFactory();

    public ELManager getELManager() {
        return this.manager;
    }

    public Object eval(String expression) {
        return this.getValue(expression, Object.class);
    }

    public Object getValue(String expression, Class<?> expectedType) {
        ValueExpression ve = this.factory.createValueExpression(this.context, ELProcessor.bracket(expression), expectedType);
        return ve.getValue(this.context);
    }

    public void setValue(String expression, Object value) {
        ValueExpression ve = this.factory.createValueExpression(this.context, ELProcessor.bracket(expression), Object.class);
        ve.setValue(this.context, value);
    }

    public void setVariable(String variable, String expression) {
        if (expression == null) {
            this.manager.setVariable(variable, null);
        } else {
            ValueExpression ve = this.factory.createValueExpression(this.context, ELProcessor.bracket(expression), Object.class);
            this.manager.setVariable(variable, ve);
        }
    }

    public void defineFunction(String prefix, String function, String className, String methodName) throws ClassNotFoundException, NoSuchMethodException {
        Method[] methods;
        if (prefix == null || function == null || className == null || methodName == null) {
            throw new NullPointerException(Util.message(this.context, "elProcessor.defineFunctionNullParams", new Object[0]));
        }
        Class<?> clazz = this.context.getImportHandler().resolveClass(className);
        if (clazz == null) {
            clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        if (!Modifier.isPublic(clazz.getModifiers())) {
            throw new ClassNotFoundException(Util.message(this.context, "elProcessor.defineFunctionInvalidClass", className));
        }
        MethodSignature sig = new MethodSignature(this.context, methodName, className);
        for (Method method : methods = clazz.getMethods()) {
            String[] typeNames;
            if (!Modifier.isStatic(method.getModifiers()) || !method.getName().equals(sig.getName())) continue;
            if (sig.getParamTypeNames() == null) {
                this.manager.mapFunction(prefix, function, method);
                return;
            }
            Class<?>[] types = method.getParameterTypes();
            if (types.length != (typeNames = sig.getParamTypeNames()).length) continue;
            boolean match = true;
            for (int i = 0; i < types.length; ++i) {
                if (types[i].getName().equals(typeNames[i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            this.manager.mapFunction(prefix, function, method);
            return;
        }
        throw new NoSuchMethodException(Util.message(this.context, "elProcessor.defineFunctionNoMethod", methodName, className));
    }

    public void defineFunction(String prefix, String function, Method method) throws NoSuchMethodException {
        if (prefix == null || function == null || method == null) {
            throw new NullPointerException(Util.message(this.context, "elProcessor.defineFunctionNullParams", new Object[0]));
        }
        int modifiers = method.getModifiers();
        if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
            throw new NoSuchMethodException(Util.message(this.context, "elProcessor.defineFunctionInvalidMethod", method.getName(), method.getDeclaringClass().getName()));
        }
        this.manager.mapFunction(prefix, function, method);
    }

    public void defineBean(String name, Object bean) {
        this.manager.defineBean(name, bean);
    }

    private static String bracket(String expression) {
        return "${" + expression + "}";
    }

    private static class MethodSignature {
        private final String name;
        private final String[] parameterTypeNames;

        public MethodSignature(ELContext context, String methodName, String className) throws NoSuchMethodException {
            int paramIndex = methodName.indexOf(40);
            if (paramIndex == -1) {
                this.name = methodName.trim();
                this.parameterTypeNames = null;
            } else {
                this.name = methodName.substring(0, paramIndex - 1).trim();
                String paramString = methodName.substring(paramIndex).trim();
                if (!paramString.endsWith(")")) {
                    throw new NoSuchMethodException(Util.message(context, "elProcessor.defineFunctionInvalidParameterList", paramString, methodName, className));
                }
                paramString = paramString.substring(1, paramString.length() - 1);
                this.parameterTypeNames = paramString.split(",");
                ImportHandler importHandler = context.getImportHandler();
                for (int i = 0; i < this.parameterTypeNames.length; ++i) {
                    this.parameterTypeNames[i] = this.parameterTypeNames[i].trim();
                    if (this.parameterTypeNames[i].contains(".")) continue;
                    Class<?> clazz = importHandler.resolveClass(this.parameterTypeNames[i]);
                    if (clazz == null) {
                        throw new NoSuchMethodException(Util.message(context, "elProcessor.defineFunctionInvalidParameterTypeName", this.parameterTypeNames[i], methodName, className));
                    }
                    this.parameterTypeNames[i] = clazz.getName();
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public String[] getParamTypeNames() {
            return this.parameterTypeNames;
        }
    }
}

