/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBEncoder;
import com.mongodb.DBObject;
import com.mongodb.assertions.Assertions;
import java.nio.ByteBuffer;
import org.bson.BSONObject;
import org.bson.BsonBinaryReader;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.ByteBuf;
import org.bson.ByteBufNIO;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonInput;
import org.bson.io.ByteBufferBsonInput;
import org.bson.io.OutputBuffer;

class DBEncoderAdapter
implements Encoder<DBObject> {
    private final DBEncoder encoder;

    DBEncoderAdapter(DBEncoder encoder) {
        this.encoder = (DBEncoder)Assertions.notNull((String)"encoder", (Object)encoder);
    }

    public void encode(BsonWriter writer, DBObject document, EncoderContext encoderContext) {
        try (BasicOutputBuffer buffer = new BasicOutputBuffer();){
            this.encoder.writeObject((OutputBuffer)buffer, (BSONObject)document);
            try (BsonBinaryReader reader = new BsonBinaryReader((BsonInput)new ByteBufferBsonInput((ByteBuf)new ByteBufNIO(ByteBuffer.wrap(buffer.toByteArray()))));){
                writer.pipe((BsonReader)reader);
            }
        }
    }

    public Class<DBObject> getEncoderClass() {
        return DBObject.class;
    }
}

