/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.mapstruct.ap.internal.util.Collections;

public class Strings {
    private static final Set<String> KEYWORDS = Collections.asSet("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while");

    private Strings() {
    }

    public static String capitalize(String string) {
        return string == null ? null : string.substring(0, 1).toUpperCase(Locale.ROOT) + string.substring(1);
    }

    public static String decapitalize(String string) {
        return string == null ? null : string.substring(0, 1).toLowerCase(Locale.ROOT) + string.substring(1);
    }

    public static String join(Iterable<?> iterable, String separator) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Object object : iterable) {
            if (!isFirst) {
                sb.append(separator);
            } else {
                isFirst = false;
            }
            sb.append(object);
        }
        return sb.toString();
    }

    public static String joinAndCamelize(Iterable<?> iterable) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Object object : iterable) {
            if (!isFirst) {
                sb.append(Strings.capitalize(object.toString()));
                continue;
            }
            sb.append(object);
            isFirst = false;
        }
        return sb.toString();
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static String getSaveVariableName(String name, String ... existingVariableNames) {
        return Strings.getSaveVariableName(name, Arrays.asList(existingVariableNames));
    }

    public static String getSaveVariableName(String name, Collection<String> existingVariableNames) {
        String seperator;
        name = Strings.decapitalize(Strings.sanitizeIdentifierName(name));
        name = Strings.joinAndCamelize(Strings.extractParts(name));
        HashSet<String> conflictingNames = new HashSet<String>(KEYWORDS);
        conflictingNames.addAll(existingVariableNames);
        if (!conflictingNames.contains(name)) {
            return name;
        }
        int c = 1;
        String string = seperator = Character.isDigit(name.charAt(name.length() - 1)) ? "_" : "";
        while (conflictingNames.contains(name + seperator + c)) {
            ++c;
        }
        return name + seperator + c;
    }

    public static String sanitizeIdentifierName(String identifier) {
        return identifier.replace("[]", "Array");
    }

    public static String stubPropertyName(String fullyQualifiedName) {
        return Strings.decapitalize(fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(46) + 1));
    }

    static Iterable<String> extractParts(String name) {
        return Arrays.asList(name.split("\\."));
    }

    public static String getMostSimilarWord(String word, Collection<String> similarWords) {
        int minLevenstein = Integer.MAX_VALUE;
        String mostSimilarWord = null;
        for (String similarWord : similarWords) {
            int levensteinDistance = Strings.levenshteinDistance(similarWord, word);
            if (levensteinDistance >= minLevenstein) continue;
            minLevenstein = levensteinDistance;
            mostSimilarWord = similarWord;
        }
        return mostSimilarWord;
    }

    private static int levenshteinDistance(String s, String t) {
        int i;
        int sLength = s.length() + 1;
        int tLength = t.length() + 1;
        int[][] distances = new int[tLength][];
        for (i = 0; i < tLength; ++i) {
            distances[i] = new int[sLength];
        }
        for (i = 0; i < tLength; ++i) {
            distances[i][0] = i;
        }
        for (i = 0; i < sLength; ++i) {
            distances[0][i] = i;
        }
        for (i = 1; i < tLength; ++i) {
            for (int j = 1; j < sLength; ++j) {
                int cost = s.charAt(j - 1) == t.charAt(i - 1) ? 0 : 1;
                distances[i][j] = Math.min(Math.min(distances[i - 1][j] + 1, distances[i][j - 1] + 1), distances[i - 1][j - 1] + cost);
            }
        }
        return distances[tLength - 1][sLength - 1];
    }
}

