/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.mapstruct.ap.internal.model.common.FormattingParameters;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.model.source.SourceReference;
import org.mapstruct.ap.internal.model.source.TargetReference;
import org.mapstruct.ap.internal.prism.CollectionMappingStrategyPrism;
import org.mapstruct.ap.internal.prism.MappingPrism;
import org.mapstruct.ap.internal.prism.MappingsPrism;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.Strings;

public class Mapping {
    private static final Pattern JAVA_EXPRESSION = Pattern.compile("^java\\((.*)\\)$");
    private final String sourceName;
    private final String constant;
    private final String javaExpression;
    private final String targetName;
    private final String defaultValue;
    private final FormattingParameters formattingParameters;
    private final SelectionParameters selectionParameters;
    private final boolean isIgnored;
    private final List<String> dependsOn;
    private final AnnotationMirror mirror;
    private final AnnotationValue sourceAnnotationValue;
    private final AnnotationValue targetAnnotationValue;
    private final AnnotationValue dependsOnAnnotationValue;
    private SourceReference sourceReference;
    private TargetReference targetReference;

    public static Map<String, List<Mapping>> fromMappingsPrism(MappingsPrism mappingsAnnotation, ExecutableElement method, FormattingMessager messager, Types typeUtils) {
        HashMap<String, List<Mapping>> mappings = new HashMap<String, List<Mapping>>();
        for (MappingPrism mappingPrism : mappingsAnnotation.value()) {
            Mapping mapping = Mapping.fromMappingPrism(mappingPrism, method, messager, typeUtils);
            if (mapping == null) continue;
            ArrayList<Mapping> mappingsOfProperty = (ArrayList<Mapping>)mappings.get(mappingPrism.target());
            if (mappingsOfProperty == null) {
                mappingsOfProperty = new ArrayList<Mapping>();
                mappings.put(mappingPrism.target(), mappingsOfProperty);
            }
            mappingsOfProperty.add(mapping);
            if (mappingsOfProperty.size() <= 1 || Mapping.isEnumType(method.getReturnType())) continue;
            messager.printMessage((Element)method, Message.PROPERTYMAPPING_DUPLICATE_TARGETS, mappingPrism.target());
        }
        return mappings;
    }

    public static Mapping fromMappingPrism(MappingPrism mappingPrism, ExecutableElement element, FormattingMessager messager, Types typeUtils) {
        if (mappingPrism.target().isEmpty()) {
            messager.printMessage((Element)element, mappingPrism.mirror, mappingPrism.values.target(), Message.PROPERTYMAPPING_EMPTY_TARGET, new Object[0]);
            return null;
        }
        if (!mappingPrism.source().isEmpty() && mappingPrism.values.constant() != null) {
            messager.printMessage((Element)element, Message.PROPERTYMAPPING_SOURCE_AND_CONSTANT_BOTH_DEFINED, new Object[0]);
            return null;
        }
        if (!mappingPrism.source().isEmpty() && mappingPrism.values.expression() != null) {
            messager.printMessage((Element)element, Message.PROPERTYMAPPING_SOURCE_AND_EXPRESSION_BOTH_DEFINED, new Object[0]);
            return null;
        }
        if (mappingPrism.values.expression() != null && mappingPrism.values.constant() != null) {
            messager.printMessage((Element)element, Message.PROPERTYMAPPING_EXPRESSION_AND_CONSTANT_BOTH_DEFINED, new Object[0]);
            return null;
        }
        if (mappingPrism.values.expression() != null && mappingPrism.values.defaultValue() != null) {
            messager.printMessage((Element)element, Message.PROPERTYMAPPING_EXPRESSION_AND_DEFAULT_VALUE_BOTH_DEFINED, new Object[0]);
            return null;
        }
        if (mappingPrism.values.constant() != null && mappingPrism.values.defaultValue() != null) {
            messager.printMessage((Element)element, Message.PROPERTYMAPPING_CONSTANT_AND_DEFAULT_VALUE_BOTH_DEFINED, new Object[0]);
            return null;
        }
        String source = mappingPrism.source().isEmpty() ? null : mappingPrism.source();
        String constant = mappingPrism.values.constant() == null ? null : mappingPrism.constant();
        String expression = Mapping.getExpression(mappingPrism, element, messager);
        String dateFormat = mappingPrism.values.dateFormat() == null ? null : mappingPrism.dateFormat();
        String numberFormat = mappingPrism.values.numberFormat() == null ? null : mappingPrism.numberFormat();
        String defaultValue = mappingPrism.values.defaultValue() == null ? null : mappingPrism.defaultValue();
        boolean resultTypeIsDefined = mappingPrism.values.resultType() != null;
        List<String> dependsOn = mappingPrism.dependsOn() != null ? mappingPrism.dependsOn() : Collections.emptyList();
        FormattingParameters formattingParam = new FormattingParameters(dateFormat, numberFormat, mappingPrism.mirror, mappingPrism.values.dateFormat(), element);
        SelectionParameters selectionParams = new SelectionParameters(mappingPrism.qualifiedBy(), mappingPrism.qualifiedByName(), resultTypeIsDefined ? mappingPrism.resultType() : null, typeUtils);
        return new Mapping(source, constant, expression, mappingPrism.target(), defaultValue, mappingPrism.ignore(), mappingPrism.mirror, mappingPrism.values.source(), mappingPrism.values.target(), formattingParam, selectionParams, mappingPrism.values.dependsOn(), dependsOn);
    }

    private Mapping(String sourceName, String constant, String javaExpression, String targetName, String defaultValue, boolean isIgnored, AnnotationMirror mirror, AnnotationValue sourceAnnotationValue, AnnotationValue targetAnnotationValue, FormattingParameters formattingParameters, SelectionParameters selectionParameters, AnnotationValue dependsOnAnnotationValue, List<String> dependsOn) {
        this.sourceName = sourceName;
        this.constant = constant;
        this.javaExpression = javaExpression;
        this.targetName = targetName;
        this.defaultValue = defaultValue;
        this.isIgnored = isIgnored;
        this.mirror = mirror;
        this.sourceAnnotationValue = sourceAnnotationValue;
        this.targetAnnotationValue = targetAnnotationValue;
        this.formattingParameters = formattingParameters;
        this.selectionParameters = selectionParameters;
        this.dependsOnAnnotationValue = dependsOnAnnotationValue;
        this.dependsOn = dependsOn;
    }

    private Mapping(Mapping mapping, TargetReference targetReference) {
        this.sourceName = mapping.sourceName;
        this.constant = mapping.constant;
        this.javaExpression = mapping.javaExpression;
        this.targetName = Strings.join(targetReference.getElementNames(), ".");
        this.defaultValue = mapping.defaultValue;
        this.isIgnored = mapping.isIgnored;
        this.mirror = mapping.mirror;
        this.sourceAnnotationValue = mapping.sourceAnnotationValue;
        this.targetAnnotationValue = mapping.targetAnnotationValue;
        this.formattingParameters = mapping.formattingParameters;
        this.selectionParameters = mapping.selectionParameters;
        this.dependsOnAnnotationValue = mapping.dependsOnAnnotationValue;
        this.dependsOn = mapping.dependsOn;
        this.sourceReference = mapping.sourceReference;
        this.targetReference = targetReference;
    }

    private Mapping(Mapping mapping, SourceReference sourceReference) {
        this.sourceName = Strings.join(sourceReference.getElementNames(), ".");
        this.constant = mapping.constant;
        this.javaExpression = mapping.javaExpression;
        this.targetName = mapping.targetName;
        this.defaultValue = mapping.defaultValue;
        this.isIgnored = mapping.isIgnored;
        this.mirror = mapping.mirror;
        this.sourceAnnotationValue = mapping.sourceAnnotationValue;
        this.targetAnnotationValue = mapping.targetAnnotationValue;
        this.formattingParameters = mapping.formattingParameters;
        this.selectionParameters = mapping.selectionParameters;
        this.dependsOnAnnotationValue = mapping.dependsOnAnnotationValue;
        this.dependsOn = mapping.dependsOn;
        this.sourceReference = sourceReference;
        this.targetReference = mapping.targetReference;
    }

    private static String getExpression(MappingPrism mappingPrism, ExecutableElement element, FormattingMessager messager) {
        if (mappingPrism.expression().isEmpty()) {
            return null;
        }
        Matcher javaExpressionMatcher = JAVA_EXPRESSION.matcher(mappingPrism.expression());
        if (!javaExpressionMatcher.matches()) {
            messager.printMessage((Element)element, mappingPrism.mirror, mappingPrism.values.expression(), Message.PROPERTYMAPPING_INVALID_EXPRESSION, new Object[0]);
            return null;
        }
        return javaExpressionMatcher.group(1).trim();
    }

    private static boolean isEnumType(TypeMirror mirror) {
        return mirror.getKind() == TypeKind.DECLARED && ((DeclaredType)mirror).asElement().getKind() == ElementKind.ENUM;
    }

    public void init(SourceMethod method, FormattingMessager messager, TypeFactory typeFactory) {
        this.init(method, messager, typeFactory, false, null);
    }

    private void init(SourceMethod method, FormattingMessager messager, TypeFactory typeFactory, boolean isReverse, Parameter reverseSourceParameter) {
        if (!method.isEnumMapping()) {
            this.sourceReference = new SourceReference.BuilderFromMapping().mapping(this).method(method).messager(messager).typeFactory(typeFactory).build();
            this.targetReference = new TargetReference.BuilderFromTargetMapping().mapping(this).isReverse(isReverse).method(method).messager(messager).typeFactory(typeFactory).reverseSourceParameter(reverseSourceParameter).build();
        }
    }

    public void init(Parameter sourceParameter) {
        if (this.sourceReference != null) {
            SourceReference oldSourceReference = this.sourceReference;
            this.sourceReference = new SourceReference.BuilderFromSourceReference().sourceParameter(sourceParameter).sourceReference(oldSourceReference).build();
        }
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getConstant() {
        return this.constant;
    }

    public String getJavaExpression() {
        return this.javaExpression;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public FormattingParameters getFormattingParameters() {
        return this.formattingParameters;
    }

    public SelectionParameters getSelectionParameters() {
        return this.selectionParameters;
    }

    public boolean isIgnored() {
        return this.isIgnored;
    }

    public AnnotationMirror getMirror() {
        return this.mirror;
    }

    public AnnotationValue getSourceAnnotationValue() {
        return this.sourceAnnotationValue;
    }

    public AnnotationValue getTargetAnnotationValue() {
        return this.targetAnnotationValue;
    }

    public AnnotationValue getDependsOnAnnotationValue() {
        return this.dependsOnAnnotationValue;
    }

    public SourceReference getSourceReference() {
        return this.sourceReference;
    }

    public TargetReference getTargetReference() {
        return this.targetReference;
    }

    public Mapping popTargetReference() {
        TargetReference newTargetReference;
        if (this.targetReference != null && (newTargetReference = this.targetReference.pop()) != null) {
            return new Mapping(this, newTargetReference);
        }
        return null;
    }

    public Mapping popSourceReference() {
        SourceReference newSourceReference;
        if (this.sourceReference != null && (newSourceReference = this.sourceReference.pop()) != null) {
            return new Mapping(this, newSourceReference);
        }
        return null;
    }

    public List<String> getDependsOn() {
        return this.dependsOn;
    }

    private boolean hasPropertyInReverseMethod(String name, SourceMethod method) {
        CollectionMappingStrategyPrism cms = method.getMapperConfiguration().getCollectionMappingStrategy();
        return method.getResultType().getPropertyWriteAccessors(cms).containsKey(name);
    }

    public Mapping reverse(SourceMethod method, FormattingMessager messager, TypeFactory typeFactory) {
        if (this.constant != null || this.javaExpression != null || this.isIgnored && this.sourceName == null) {
            return null;
        }
        Mapping reverse = new Mapping(this.sourceName != null ? this.targetName : null, null, null, this.sourceName != null ? this.sourceName : this.targetName, null, this.isIgnored, this.mirror, this.sourceAnnotationValue, this.targetAnnotationValue, this.formattingParameters, this.selectionParameters, this.dependsOnAnnotationValue, Collections.<String>emptyList());
        reverse.init(method, messager, typeFactory, true, this.sourceReference != null ? this.sourceReference.getParameter() : null);
        return reverse;
    }

    public Mapping copyForInheritanceTo(SourceMethod method) {
        Mapping mapping = new Mapping(this.sourceName, this.constant, this.javaExpression, this.targetName, this.defaultValue, this.isIgnored, this.mirror, this.sourceAnnotationValue, this.targetAnnotationValue, this.formattingParameters, this.selectionParameters, this.dependsOnAnnotationValue, this.dependsOn);
        if (this.sourceReference != null) {
            mapping.sourceReference = this.sourceReference.copyForInheritanceTo(method);
        }
        mapping.targetReference = this.targetReference;
        return mapping;
    }

    public String toString() {
        return "Mapping {\n    sourceName='" + this.sourceName + "',\n    targetName='" + this.targetName + "',\n}";
    }
}

