/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.xml;

import com.fasterxml.aalto.stax.InputFactoryImpl;
import com.fasterxml.aalto.stax.OutputFactoryImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.jetbrains.annotations.NotNull;
import org.linguafranca.xml.XmlEventTransformer;

public class XmlInputStreamFilter
extends InputStream {
    private final XMLEventReader xmlEventReader;
    private XMLEventWriter xmlEventWriter;
    private byte[] buffer = new byte[0];
    private volatile ByteArrayInputStream xmlInStream = new ByteArrayInputStream(this.buffer);
    private volatile ByteArrayOutputStream xmlWriteStream = new ByteArrayOutputStream();
    private boolean done = false;
    private InputStream inputStream;
    private XmlEventTransformer eventTransformer;

    public XmlInputStreamFilter(InputStream is, XmlEventTransformer transformer) throws XMLStreamException {
        this.inputStream = is;
        this.eventTransformer = transformer;
        InputFactoryImpl inputFactory = new InputFactoryImpl();
        this.xmlEventReader = inputFactory.createXMLEventReader(is);
        OutputFactoryImpl outputFactory = new OutputFactoryImpl();
        this.xmlEventWriter = outputFactory.createXMLEventWriter(this.xmlWriteStream);
    }

    private int get(byte[] b, int offset, int length) throws IOException {
        int bytesRead;
        if (this.done) {
            return -1;
        }
        int totalBytesRead = 0;
        while ((bytesRead = this.xmlInStream.read(b, offset, length)) < length && !this.done) {
            if (bytesRead == -1) {
                try {
                    this.loadEvents();
                    continue;
                }
                catch (XMLStreamException e) {
                    throw new IOException(e);
                }
            }
            offset += bytesRead;
            length -= bytesRead;
            totalBytesRead += bytesRead;
        }
        return bytesRead > 0 ? totalBytesRead + bytesRead : totalBytesRead;
    }

    private void loadEvents() throws XMLStreamException {
        if (!this.xmlEventReader.hasNext()) {
            this.done = true;
            return;
        }
        XMLEvent event = this.xmlEventReader.nextEvent();
        event = this.eventTransformer.transform(event);
        this.xmlWriteStream.reset();
        this.xmlEventWriter.add(event);
        this.xmlEventWriter.flush();
        this.xmlInStream = new ByteArrayInputStream(this.xmlWriteStream.toByteArray());
    }

    @Override
    public int read() throws IOException {
        byte[] buffer = new byte[1];
        if (this.get(buffer, 0, 1) != 1) {
            return -1;
        }
        return buffer[0] & 0xFF;
    }

    @Override
    public int read(@NotNull byte[] b, int offset, int length) throws IOException {
        return this.get(b, offset, length);
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

