/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdb;

import com.google.common.io.LittleEndianDataInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.UUID;
import org.linguafranca.pwdb.Credentials;
import org.linguafranca.pwdb.Entry;
import org.linguafranca.pwdb.kdb.KdbDatabase;
import org.linguafranca.pwdb.kdb.KdbEntry;
import org.linguafranca.pwdb.kdb.KdbGroup;
import org.linguafranca.pwdb.kdb.KdbHeader;
import org.linguafranca.pwdb.kdb.KdbIcon;
import org.linguafranca.pwdb.security.Encryption;

public class KdbSerializer {
    private static final int SIGNATURE1 = -1700603645;
    private static final int SIGNATURE2 = -1253311643;

    private KdbSerializer() {
    }

    public static KdbDatabase createKdbDatabase(Credentials credentials, KdbHeader kdbHeader, InputStream inputStream) throws IOException {
        LittleEndianDataInputStream dataInput = new LittleEndianDataInputStream(inputStream);
        KdbSerializer.checkSignature((DataInput)dataInput);
        KdbSerializer.deserializeHeader(kdbHeader, (DataInput)dataInput);
        InputStream decryptedInputStream = kdbHeader.createDecryptedInputStream(credentials.getKey(), inputStream);
        MessageDigest digest = Encryption.getMessageDigestInstance();
        DigestInputStream digestInputStream = new DigestInputStream(decryptedInputStream, digest);
        dataInput = new LittleEndianDataInputStream((InputStream)digestInputStream);
        KdbDatabase kdbDatabase = new KdbDatabase();
        KdbGroup lastGroup = kdbDatabase.getRootGroup();
        for (long group = 0L; group < kdbHeader.getGroupCount(); ++group) {
            lastGroup = KdbSerializer.deserializeGroup(lastGroup, (DataInput)dataInput);
        }
        for (long entry = 0L; entry < kdbHeader.getEntryCount(); ++entry) {
            KdbSerializer.deserializeEntry(kdbDatabase, (DataInput)dataInput);
        }
        if (!Arrays.equals(digest.digest(), kdbHeader.getContentHash())) {
            throw new IllegalStateException("Hash values did not match");
        }
        digestInputStream.close();
        return kdbDatabase;
    }

    private static void setDatabase(KdbDatabase kdbDatabase, KdbGroup group) {
        for (KdbGroup child : group.getGroups()) {
            child.database = kdbDatabase;
            KdbSerializer.setDatabase(kdbDatabase, child);
        }
    }

    public static void checkSignature(DataInput dataInput) throws IOException {
        if (dataInput.readInt() != -1700603645 || dataInput.readInt() != -1253311643) {
            throw new IllegalStateException("Signature bytes do not match");
        }
    }

    private static void deserializeHeader(KdbHeader kdbHeader, DataInput dataInput) throws IOException {
        kdbHeader.setFlags(dataInput.readInt());
        kdbHeader.setVersion(dataInput.readInt());
        byte[] buffer = new byte[16];
        dataInput.readFully(buffer);
        kdbHeader.setMasterSeed(buffer);
        buffer = new byte[16];
        dataInput.readFully(buffer);
        kdbHeader.setEncryptionIv(buffer);
        kdbHeader.setGroupCount(dataInput.readInt());
        kdbHeader.setEntryCount(dataInput.readInt());
        byte[] buffer32 = new byte[32];
        dataInput.readFully(buffer32);
        kdbHeader.setContentHash(buffer32);
        buffer32 = new byte[32];
        dataInput.readFully(buffer32);
        kdbHeader.setTransformSeed(buffer32);
        kdbHeader.setTransformRounds(dataInput.readInt());
    }

    private static KdbGroup deserializeGroup(KdbGroup lastGroup, DataInput dataInput) throws IOException {
        int fieldType;
        KdbGroup group = new KdbGroup();
        block12: while ((fieldType = dataInput.readUnsignedShort()) != 65535) {
            switch (fieldType) {
                case 0: {
                    KdbSerializer.readExtData(dataInput);
                    continue block12;
                }
                case 1: {
                    UUID uuid = new UUID(0L, KdbSerializer.readInt(dataInput));
                    group.setUuid(uuid);
                    continue block12;
                }
                case 2: {
                    group.setName(KdbSerializer.readString(dataInput));
                    continue block12;
                }
                case 3: {
                    group.setCreationTime(KdbSerializer.readDate(dataInput));
                    continue block12;
                }
                case 4: {
                    group.setLastModificationTime(KdbSerializer.readDate(dataInput));
                    continue block12;
                }
                case 5: {
                    group.setLastAccessTime(KdbSerializer.readDate(dataInput));
                    continue block12;
                }
                case 6: {
                    group.setExpiryTime(KdbSerializer.readDate(dataInput));
                    continue block12;
                }
                case 7: {
                    group.setIcon(new KdbIcon(KdbSerializer.readInt(dataInput)));
                    continue block12;
                }
                case 8: {
                    short level = KdbSerializer.readShort(dataInput);
                    group.setParent(KdbSerializer.computeParentGroup(lastGroup, level));
                    continue block12;
                }
                case 9: {
                    group.setFlags(KdbSerializer.readInt(dataInput));
                    continue block12;
                }
            }
            throw new IllegalStateException("Unknown field type " + String.valueOf(fieldType));
        }
        dataInput.readInt();
        return group;
    }

    private static void deserializeEntry(KdbDatabase database, DataInput dataInput) throws IOException {
        int fieldType;
        KdbEntry entry = new KdbEntry();
        block17: while ((fieldType = dataInput.readUnsignedShort()) != 65535) {
            switch (fieldType) {
                case 0: {
                    KdbSerializer.readExtData(dataInput);
                    continue block17;
                }
                case 1: {
                    entry.setUuid(KdbSerializer.readUuid(dataInput));
                    continue block17;
                }
                case 2: {
                    int groupId = KdbSerializer.readInt(dataInput);
                    KdbGroup group = database.findGroup(new UUID(0L, groupId));
                    if (group == null) {
                        throw new IllegalStateException("Entry belongs to group that does not exist");
                    }
                    group.addEntry((Entry)entry);
                    continue block17;
                }
                case 3: {
                    entry.setIcon(new KdbIcon(KdbSerializer.readInt(dataInput)));
                    continue block17;
                }
                case 4: {
                    entry.setTitle(KdbSerializer.readString(dataInput));
                    continue block17;
                }
                case 5: {
                    entry.setUrl(KdbSerializer.readString(dataInput));
                    continue block17;
                }
                case 6: {
                    entry.setUsername(KdbSerializer.readString(dataInput));
                    continue block17;
                }
                case 7: {
                    entry.setPassword(KdbSerializer.readString(dataInput));
                    continue block17;
                }
                case 8: {
                    entry.setNotes(KdbSerializer.readString(dataInput));
                    continue block17;
                }
                case 9: {
                    entry.setCreationTime(KdbSerializer.readDate(dataInput));
                    continue block17;
                }
                case 10: {
                    entry.setLastModificationTime(KdbSerializer.readDate(dataInput));
                    continue block17;
                }
                case 11: {
                    entry.setLastAccessTime(KdbSerializer.readDate(dataInput));
                    continue block17;
                }
                case 12: {
                    entry.setExpiryTime(KdbSerializer.readDate(dataInput));
                    continue block17;
                }
                case 13: {
                    entry.setBinaryDescription(KdbSerializer.readString(dataInput));
                    continue block17;
                }
                case 14: {
                    entry.setBinaryData(KdbSerializer.readBuffer(dataInput));
                    continue block17;
                }
            }
            throw new IllegalStateException("Unknown field type");
        }
        dataInput.readInt();
    }

    private static KdbGroup computeParentGroup(KdbGroup lastGroup, int level) {
        int lastLevel = lastGroup.computedLevel();
        if (level == lastLevel + 1) {
            return lastGroup;
        }
        if (level > lastLevel) {
            throw new IllegalStateException("Could not determine parent group from level supplied");
        }
        KdbGroup candidateParent = lastGroup.getParent();
        while (level <= candidateParent.computedLevel()) {
            candidateParent = candidateParent.getParent();
        }
        return candidateParent;
    }

    public static Date unpackDate(byte[] buffer) {
        byte[] buffer8 = new byte[8];
        System.arraycopy(buffer, 0, buffer8, 3, 5);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer8);
        long longValue = byteBuffer.getLong();
        int second = (int)longValue & 0x3F;
        int minute = (int)(longValue >>= 6) & 0x3F;
        int hour = (int)(longValue >>= 6) & 0x1F;
        int day = (int)(longValue >>= 5) & 0x1F;
        int month = (int)(longValue >>= 5) & 0xF;
        int year = (int)(longValue >>= 4) & 0xFFF;
        return new GregorianCalendar(year, month - 1, day, hour, minute, second).getTime();
    }

    private static Date readDate(DataInput dataInput) throws IOException {
        if (dataInput.readInt() != 5) {
            throw new IllegalStateException("Date must be 5 bytes");
        }
        byte[] buffer = new byte[5];
        dataInput.readFully(buffer);
        return KdbSerializer.unpackDate(buffer);
    }

    private static int readInt(DataInput dataInput) throws IOException {
        if (dataInput.readInt() != 4) {
            throw new IllegalStateException("Integer must be 4 bytes");
        }
        return dataInput.readInt();
    }

    private static short readShort(DataInput dataInput) throws IOException {
        if (dataInput.readInt() != 2) {
            throw new IllegalStateException("Short must be 2 bytes");
        }
        return dataInput.readShort();
    }

    private static String readString(DataInput dataInput) throws IOException {
        int length = dataInput.readInt();
        byte[] buffer = new byte[length];
        dataInput.readFully(buffer);
        return new String(buffer, 0, length - 1);
    }

    private static UUID readUuid(DataInput dataInput) throws IOException {
        if (dataInput.readInt() != 16) {
            throw new IllegalStateException("Uuid must be 16 bytes");
        }
        long lesserBits = dataInput.readLong();
        long greaterBits = dataInput.readLong();
        return new UUID(greaterBits, lesserBits);
    }

    private static byte[] readBuffer(DataInput dataInput) throws IOException {
        int size = dataInput.readInt();
        byte[] buffer = new byte[size];
        dataInput.readFully(buffer);
        return buffer;
    }

    private static byte[] readExtData(DataInput dataInput) throws IOException {
        int size = dataInput.readInt();
        byte[] buffer = new byte[size];
        dataInput.readFully(buffer);
        return buffer;
    }
}

