/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2.maven2.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.util.DirectoryScanner;
import org.jvnet.jaxb2.maven2.util.CollectionUtils;
import org.jvnet.jaxb2.maven2.util.StringUtils;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOUtils {
    public static final CollectionUtils.Function<File, URL> GET_URL = new CollectionUtils.Function<File, URL>(){

        @Override
        public URL eval(File file) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException muex) {
                throw new RuntimeException(muex);
            }
        }
    };
    public static final CollectionUtils.Function<File, Long> LAST_MODIFIED = new CollectionUtils.Function<File, Long>(){

        @Override
        public Long eval(File file) {
            return IOUtils.lastModified(file);
        }
    };

    public static InputSource getInputSource(File file) {
        try {
            return new InputSource(StringUtils.escapeSpace(file.toURI().toURL().toExternalForm()));
        }
        catch (MalformedURLException e) {
            return new InputSource(file.getPath());
        }
    }

    public static long lastModified(File file) {
        if (file == null || !file.exists()) {
            return 0L;
        }
        return file.lastModified();
    }

    public static List<File> scanDirectoryForFiles(File directory, String[] includes, String[] excludes, boolean defaultExcludes) throws IOException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory.getAbsoluteFile());
        scanner.setIncludes(includes);
        scanner.setExcludes(excludes);
        if (defaultExcludes) {
            scanner.addDefaultExcludes();
        }
        scanner.scan();
        ArrayList<File> files = new ArrayList<File>();
        for (String name : scanner.getIncludedFiles()) {
            files.add(new File(directory, name).getCanonicalFile());
        }
        return files;
    }
}

