/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.tools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

public class PropertyFileEncodingCheckerMojo
extends AbstractMojo {
    protected MavenProject project;
    private boolean hadError = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.hadError = false;
            Project p = new Project();
            for (Resource res : this.project.getResources()) {
                FileSet fs = new FileSet();
                fs.setProject(p);
                File baseDir = new File(res.getDirectory());
                if (!baseDir.exists()) continue;
                fs.setDir(baseDir);
                fs.setIncludes("**/*.properties");
                for (String f : fs.getDirectoryScanner(p).getIncludedFiles()) {
                    this.check(new File(baseDir, f));
                }
            }
            if (this.hadError) {
                throw new MojoExecutionException("Problems detected");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to check encoding of resource files", (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(File f) throws IOException, MojoExecutionException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
        try {
            Properties props = new Properties();
            props.load(is);
        }
        finally {
            ((InputStream)is).close();
        }
        is = new BufferedInputStream(new FileInputStream(f));
        byte[] bytes = IOUtils.toByteArray((InputStream)is);
        try {
            byte[] arr$ = bytes;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int b;
                int ch = b = arr$[i$];
                if (128 > (ch &= 0xFF) || ch > 159) continue;
                this.error(f);
            }
            for (int i = 0; i < bytes.length - 3; ++i) {
                if (this.toInt(bytes[i]) != 239 || this.toInt(bytes[i + 1]) != 191 || this.toInt(bytes[i + 2]) != 189) continue;
                this.error(f);
            }
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private void error(File f) {
        System.out.println(f + " contains illegal iso-8859-1 character");
        this.hadError = true;
    }

    private int toInt(byte b) {
        return b & 0xFF;
    }
}

