/*
 * Copyright 2010-2019 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package kotlin.reflect.jvm.internal.impl.load.kotlin

import kotlin.reflect.jvm.internal.impl.types.TypeSystemCommonBackendContext
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker
import kotlin.reflect.jvm.internal.impl.types.model.SimpleTypeMarker

internal fun TypeSystemCommonBackendContext.computeUnderlyingType(inlineClassType: KotlinTypeMarker): KotlinTypeMarker? {
    if (!shouldUseUnderlyingType(inlineClassType)) return null

    val underlyingType = inlineClassType.getUnsubstitutedUnderlyingType() ?: return null
    return underlyingType.typeConstructor().getTypeParameterClassifier()?.getRepresentativeUpperBound()
        ?: inlineClassType.getSubstitutedUnderlyingType()
}

internal fun TypeSystemCommonBackendContext.shouldUseUnderlyingType(inlineClassType: KotlinTypeMarker): Boolean {
    val underlyingType = inlineClassType.getUnsubstitutedUnderlyingType() ?: return false

    return !inlineClassType.isMarkedNullable() ||
            !underlyingType.isNullableType() && !(underlyingType is SimpleTypeMarker && underlyingType.isPrimitiveType())
}
