/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.jvm;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.CompanionObjectMapping;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionClassKind;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.FqNamesUtilKt;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaToKotlinClassMap {
    @NotNull
    public static final JavaToKotlinClassMap INSTANCE;
    @NotNull
    private static final String NUMBERED_FUNCTION_PREFIX;
    @NotNull
    private static final String NUMBERED_K_FUNCTION_PREFIX;
    @NotNull
    private static final String NUMBERED_SUSPEND_FUNCTION_PREFIX;
    @NotNull
    private static final String NUMBERED_K_SUSPEND_FUNCTION_PREFIX;
    @NotNull
    private static final ClassId FUNCTION_N_CLASS_ID;
    @NotNull
    private static final FqName FUNCTION_N_FQ_NAME;
    @NotNull
    private static final ClassId K_FUNCTION_CLASS_ID;
    @NotNull
    private static final ClassId K_CLASS_CLASS_ID;
    @NotNull
    private static final ClassId CLASS_CLASS_ID;
    @NotNull
    private static final HashMap<FqNameUnsafe, ClassId> javaToKotlin;
    @NotNull
    private static final HashMap<FqNameUnsafe, ClassId> kotlinToJava;
    @NotNull
    private static final HashMap<FqNameUnsafe, FqName> mutableToReadOnly;
    @NotNull
    private static final HashMap<FqNameUnsafe, FqName> readOnlyToMutable;
    @NotNull
    private static final List<PlatformMutabilityMapping> mutabilityMappings;

    private JavaToKotlinClassMap() {
    }

    @NotNull
    public final FqName getFUNCTION_N_FQ_NAME() {
        return FUNCTION_N_FQ_NAME;
    }

    @NotNull
    public final List<PlatformMutabilityMapping> getMutabilityMappings() {
        return mutabilityMappings;
    }

    @Nullable
    public final ClassId mapJavaToKotlin(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return javaToKotlin.get(fqName2.toUnsafe());
    }

    @Nullable
    public final ClassId mapKotlinToJava(@NotNull FqNameUnsafe kotlinFqName) {
        Intrinsics.checkNotNullParameter((Object)kotlinFqName, (String)"kotlinFqName");
        return this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_FUNCTION_PREFIX) ? FUNCTION_N_CLASS_ID : (this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_SUSPEND_FUNCTION_PREFIX) ? FUNCTION_N_CLASS_ID : (this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_K_FUNCTION_PREFIX) ? K_FUNCTION_CLASS_ID : (this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_K_SUSPEND_FUNCTION_PREFIX) ? K_FUNCTION_CLASS_ID : kotlinToJava.get(kotlinFqName))));
    }

    private final boolean isKotlinFunctionWithBigArity(FqNameUnsafe kotlinFqName, String prefix) {
        CharSequence charSequence = kotlinFqName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"kotlinFqName.asString()");
        String arityString = StringsKt.substringAfter((String)charSequence, (String)prefix, (String)"");
        charSequence = arityString;
        boolean bl = false;
        if (charSequence.length() > 0 && !StringsKt.startsWith$default((CharSequence)arityString, (char)'0', (boolean)false, (int)2, null)) {
            Integer arity = StringsKt.toIntOrNull((String)arityString);
            return arity != null && arity >= 23;
        }
        return false;
    }

    private final void addMapping(PlatformMutabilityMapping platformMutabilityMapping) {
        PlatformMutabilityMapping platformMutabilityMapping2 = platformMutabilityMapping;
        ClassId javaClassId = platformMutabilityMapping2.component1();
        ClassId readOnlyClassId = platformMutabilityMapping2.component2();
        ClassId mutableClassId = platformMutabilityMapping2.component3();
        this.add(javaClassId, readOnlyClassId);
        FqName fqName2 = mutableClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"mutableClassId.asSingleFqName()");
        this.addKotlinToJava(fqName2, javaClassId);
        FqName fqName3 = readOnlyClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"readOnlyClassId.asSingleFqName()");
        FqName readOnlyFqName = fqName3;
        Object object = mutableClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mutableClassId.asSingleFqName()");
        FqName mutableFqName = object;
        object = mutableToReadOnly;
        FqNameUnsafe fqNameUnsafe = mutableClassId.asSingleFqName().toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"mutableClassId.asSingleFqName().toUnsafe()");
        boolean bl = false;
        object.put(fqNameUnsafe, readOnlyFqName);
        object = readOnlyToMutable;
        fqNameUnsafe = readOnlyFqName.toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"readOnlyFqName.toUnsafe()");
        bl = false;
        object.put(fqNameUnsafe, mutableFqName);
    }

    private final void add(ClassId javaClassId, ClassId kotlinClassId) {
        this.addJavaToKotlin(javaClassId, kotlinClassId);
        FqName fqName2 = kotlinClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"kotlinClassId.asSingleFqName()");
        this.addKotlinToJava(fqName2, javaClassId);
    }

    private final void addTopLevel(Class<?> javaClass, FqNameUnsafe kotlinFqName) {
        FqName fqName2 = kotlinFqName.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"kotlinFqName.toSafe()");
        this.addTopLevel(javaClass, fqName2);
    }

    private final void addTopLevel(Class<?> javaClass, FqName kotlinFqName) {
        ClassId classId = this.classId(javaClass);
        ClassId classId2 = ClassId.topLevel(kotlinFqName);
        Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"topLevel(kotlinFqName)");
        this.add(classId, classId2);
    }

    private final void addJavaToKotlin(ClassId javaClassId, ClassId kotlinClassId) {
        Map map = javaToKotlin;
        FqNameUnsafe fqNameUnsafe = javaClassId.asSingleFqName().toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"javaClassId.asSingleFqName().toUnsafe()");
        boolean bl = false;
        map.put(fqNameUnsafe, kotlinClassId);
    }

    private final void addKotlinToJava(FqName kotlinFqNameUnsafe, ClassId javaClassId) {
        Map map = kotlinToJava;
        FqNameUnsafe fqNameUnsafe = kotlinFqNameUnsafe.toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"kotlinFqNameUnsafe.toUnsafe()");
        boolean bl = false;
        map.put(fqNameUnsafe, javaClassId);
    }

    @Nullable
    public final FqName mutableToReadOnly(@Nullable FqNameUnsafe fqNameUnsafe) {
        Map map = mutableToReadOnly;
        boolean bl = false;
        return (FqName)map.get(fqNameUnsafe);
    }

    @Nullable
    public final FqName readOnlyToMutable(@Nullable FqNameUnsafe fqNameUnsafe) {
        Map map = readOnlyToMutable;
        boolean bl = false;
        return (FqName)map.get(fqNameUnsafe);
    }

    public final boolean isMutable(@Nullable FqNameUnsafe fqNameUnsafe) {
        Map map = mutableToReadOnly;
        boolean bl = false;
        Map map2 = map;
        if (map2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        return map2.containsKey(fqNameUnsafe);
    }

    public final boolean isReadOnly(@Nullable FqNameUnsafe fqNameUnsafe) {
        Map map = readOnlyToMutable;
        boolean bl = false;
        Map map2 = map;
        if (map2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        return map2.containsKey(fqNameUnsafe);
    }

    private final ClassId classId(Class<?> clazz) {
        ClassId classId;
        boolean bl = !clazz.isPrimitive() && !clazz.isArray();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = Intrinsics.stringPlus((String)"Invalid class: ", clazz);
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Class<?> outer = clazz.getDeclaringClass();
        if (outer == null) {
            ClassId classId2 = ClassId.topLevel(new FqName(clazz.getCanonicalName()));
            Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"topLevel(FqName(clazz.canonicalName))");
            classId = classId2;
        } else {
            ClassId classId3 = this.classId(outer).createNestedClassId(Name.identifier(clazz.getSimpleName()));
            Intrinsics.checkNotNullExpressionValue((Object)classId3, (String)"classId(outer).createNes\u2026tifier(clazz.simpleName))");
            classId = classId3;
        }
        return classId;
    }

    static {
        int i;
        JavaToKotlinClassMap this_$iv;
        ClassId kotlinReadOnly$iv;
        Object object;
        INSTANCE = new JavaToKotlinClassMap();
        NUMBERED_FUNCTION_PREFIX = FunctionClassKind.Function.getPackageFqName().toString() + '.' + FunctionClassKind.Function.getClassNamePrefix();
        NUMBERED_K_FUNCTION_PREFIX = FunctionClassKind.KFunction.getPackageFqName().toString() + '.' + FunctionClassKind.KFunction.getClassNamePrefix();
        NUMBERED_SUSPEND_FUNCTION_PREFIX = FunctionClassKind.SuspendFunction.getPackageFqName().toString() + '.' + FunctionClassKind.SuspendFunction.getClassNamePrefix();
        NUMBERED_K_SUSPEND_FUNCTION_PREFIX = FunctionClassKind.KSuspendFunction.getPackageFqName().toString() + '.' + FunctionClassKind.KSuspendFunction.getClassNamePrefix();
        Object object2 = ClassId.topLevel(new FqName("kotlin.jvm.functions.FunctionN"));
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"topLevel(FqName(\"kotlin.jvm.functions.FunctionN\"))");
        FUNCTION_N_CLASS_ID = object2;
        object2 = FUNCTION_N_CLASS_ID.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"FUNCTION_N_CLASS_ID.asSingleFqName()");
        FUNCTION_N_FQ_NAME = object2;
        object2 = ClassId.topLevel(new FqName("kotlin.reflect.KFunction"));
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"topLevel(FqName(\"kotlin.reflect.KFunction\"))");
        K_FUNCTION_CLASS_ID = object2;
        object2 = ClassId.topLevel(new FqName("kotlin.reflect.KClass"));
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"topLevel(FqName(\"kotlin.reflect.KClass\"))");
        K_CLASS_CLASS_ID = object2;
        CLASS_CLASS_ID = INSTANCE.classId(Class.class);
        javaToKotlin = new HashMap();
        kotlinToJava = new HashMap();
        mutableToReadOnly = new HashMap();
        readOnlyToMutable = new HashMap();
        object2 = new PlatformMutabilityMapping[8];
        JavaToKotlinClassMap javaToKotlinClassMap = INSTANCE;
        ClassId classId = ClassId.topLevel(StandardNames.FqNames.iterable);
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(FqNames.iterable)");
        FqName kotlinMutable$iv = StandardNames.FqNames.mutableIterable;
        boolean $i$f$mutabilityMapping = false;
        FqName fqName2 = object = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"kotlinReadOnly.packageFqName");
        ClassId mutableClassId$iv = new ClassId(fqName2, FqNamesUtilKt.tail(kotlinMutable$iv, object), false);
        object2[0] = new PlatformMutabilityMapping(this_$iv.classId(Iterable.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        kotlinReadOnly$iv = ClassId.topLevel(StandardNames.FqNames.iterator);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinReadOnly$iv, (String)"topLevel(FqNames.iterator)");
        kotlinMutable$iv = StandardNames.FqNames.mutableIterator;
        $i$f$mutabilityMapping = false;
        FqName fqName3 = object = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName3, FqNamesUtilKt.tail(kotlinMutable$iv, object), false);
        object2[1] = new PlatformMutabilityMapping(this_$iv.classId(Iterator.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        kotlinReadOnly$iv = ClassId.topLevel(StandardNames.FqNames.collection);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinReadOnly$iv, (String)"topLevel(FqNames.collection)");
        kotlinMutable$iv = StandardNames.FqNames.mutableCollection;
        $i$f$mutabilityMapping = false;
        FqName fqName4 = object = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName4, FqNamesUtilKt.tail(kotlinMutable$iv, object), false);
        object2[2] = new PlatformMutabilityMapping(this_$iv.classId(Collection.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        kotlinReadOnly$iv = ClassId.topLevel(StandardNames.FqNames.list);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinReadOnly$iv, (String)"topLevel(FqNames.list)");
        kotlinMutable$iv = StandardNames.FqNames.mutableList;
        $i$f$mutabilityMapping = false;
        FqName fqName5 = object = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName5, FqNamesUtilKt.tail(kotlinMutable$iv, object), false);
        object2[3] = new PlatformMutabilityMapping(this_$iv.classId(List.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        kotlinReadOnly$iv = ClassId.topLevel(StandardNames.FqNames.set);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinReadOnly$iv, (String)"topLevel(FqNames.set)");
        kotlinMutable$iv = StandardNames.FqNames.mutableSet;
        $i$f$mutabilityMapping = false;
        FqName fqName6 = object = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName6, FqNamesUtilKt.tail(kotlinMutable$iv, object), false);
        object2[4] = new PlatformMutabilityMapping(this_$iv.classId(Set.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        kotlinReadOnly$iv = ClassId.topLevel(StandardNames.FqNames.listIterator);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinReadOnly$iv, (String)"topLevel(FqNames.listIterator)");
        kotlinMutable$iv = StandardNames.FqNames.mutableListIterator;
        $i$f$mutabilityMapping = false;
        FqName fqName7 = object = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName7, FqNamesUtilKt.tail(kotlinMutable$iv, object), false);
        object2[5] = new PlatformMutabilityMapping(this_$iv.classId(ListIterator.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        kotlinReadOnly$iv = ClassId.topLevel(StandardNames.FqNames.map);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinReadOnly$iv, (String)"topLevel(FqNames.map)");
        kotlinMutable$iv = StandardNames.FqNames.mutableMap;
        $i$f$mutabilityMapping = false;
        FqName fqName8 = object = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName8, FqNamesUtilKt.tail(kotlinMutable$iv, object), false);
        object2[6] = new PlatformMutabilityMapping(this_$iv.classId(Map.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        kotlinReadOnly$iv = ClassId.topLevel(StandardNames.FqNames.map).createNestedClassId(StandardNames.FqNames.mapEntry.shortName());
        Intrinsics.checkNotNullExpressionValue((Object)kotlinReadOnly$iv, (String)"topLevel(FqNames.map).cr\u2026mes.mapEntry.shortName())");
        kotlinMutable$iv = StandardNames.FqNames.mutableMapEntry;
        $i$f$mutabilityMapping = false;
        FqName fqName9 = object = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName9, FqNamesUtilKt.tail(kotlinMutable$iv, object), false);
        object2[7] = new PlatformMutabilityMapping(this_$iv.classId(Map.Entry.class), kotlinReadOnly$iv, mutableClassId$iv);
        mutabilityMappings = CollectionsKt.listOf((Object[])object2);
        INSTANCE.addTopLevel(Object.class, StandardNames.FqNames.any);
        INSTANCE.addTopLevel(String.class, StandardNames.FqNames.string);
        INSTANCE.addTopLevel(CharSequence.class, StandardNames.FqNames.charSequence);
        INSTANCE.addTopLevel(Throwable.class, StandardNames.FqNames.throwable);
        INSTANCE.addTopLevel(Cloneable.class, StandardNames.FqNames.cloneable);
        INSTANCE.addTopLevel(Number.class, StandardNames.FqNames.number);
        INSTANCE.addTopLevel(Comparable.class, StandardNames.FqNames.comparable);
        INSTANCE.addTopLevel(Enum.class, StandardNames.FqNames._enum);
        INSTANCE.addTopLevel(Annotation.class, StandardNames.FqNames.annotation);
        for (PlatformMutabilityMapping platformCollection : mutabilityMappings) {
            INSTANCE.addMapping(platformCollection);
        }
        for (JvmPrimitiveType jvmType : JvmPrimitiveType.values()) {
            ClassId classId2 = ClassId.topLevel(jvmType.getWrapperFqName());
            Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"topLevel(jvmType.wrapperFqName)");
            ClassId classId3 = classId2;
            object = jvmType.getPrimitiveType();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jvmType.primitiveType");
            classId2 = ClassId.topLevel(StandardNames.getPrimitiveFqName((PrimitiveType)((Object)object)));
            Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"topLevel(StandardNames.g\u2026e(jvmType.primitiveType))");
            INSTANCE.add(classId3, classId2);
        }
        for (ClassId classId4 : CompanionObjectMapping.INSTANCE.allClassesWithIntrinsicCompanions()) {
            kotlinReadOnly$iv = ClassId.topLevel(new FqName("kotlin.jvm.internal." + classId4.getShortClassName().asString() + "CompanionObject"));
            Intrinsics.checkNotNullExpressionValue((Object)kotlinReadOnly$iv, (String)"topLevel(FqName(\"kotlin.\u2026g() + \"CompanionObject\"))");
            ClassId classId5 = kotlinReadOnly$iv;
            kotlinReadOnly$iv = classId4.createNestedClassId(SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT);
            Intrinsics.checkNotNullExpressionValue((Object)kotlinReadOnly$iv, (String)"classId.createNestedClas\u2026AME_FOR_COMPANION_OBJECT)");
            INSTANCE.add(classId5, kotlinReadOnly$iv);
        }
        int n = 0;
        do {
            i = n++;
            kotlinReadOnly$iv = ClassId.topLevel(new FqName(Intrinsics.stringPlus((String)"kotlin.jvm.functions.Function", (Object)i)));
            Intrinsics.checkNotNullExpressionValue((Object)kotlinReadOnly$iv, (String)"topLevel(FqName(\"kotlin.\u2026m.functions.Function$i\"))");
            INSTANCE.add(kotlinReadOnly$iv, StandardNames.getFunctionClassId(i));
            INSTANCE.addKotlinToJava(new FqName(Intrinsics.stringPlus((String)NUMBERED_K_FUNCTION_PREFIX, (Object)i)), K_FUNCTION_CLASS_ID);
        } while (n < 23);
        n = 0;
        do {
            i = n++;
            FunctionClassKind kSuspendFunction = FunctionClassKind.KSuspendFunction;
            String kSuspendFun = kSuspendFunction.getPackageFqName().toString() + '.' + kSuspendFunction.getClassNamePrefix();
            INSTANCE.addKotlinToJava(new FqName(Intrinsics.stringPlus((String)kSuspendFun, (Object)i)), K_FUNCTION_CLASS_ID);
        } while (n < 22);
        FqName fqName10 = StandardNames.FqNames.nothing.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName10, (String)"nothing.toSafe()");
        INSTANCE.addKotlinToJava(fqName10, INSTANCE.classId(Void.class));
    }

    public static final class PlatformMutabilityMapping {
        @NotNull
        private final ClassId javaClass;
        @NotNull
        private final ClassId kotlinReadOnly;
        @NotNull
        private final ClassId kotlinMutable;

        public PlatformMutabilityMapping(@NotNull ClassId javaClass, @NotNull ClassId kotlinReadOnly, @NotNull ClassId kotlinMutable) {
            Intrinsics.checkNotNullParameter((Object)javaClass, (String)"javaClass");
            Intrinsics.checkNotNullParameter((Object)kotlinReadOnly, (String)"kotlinReadOnly");
            Intrinsics.checkNotNullParameter((Object)kotlinMutable, (String)"kotlinMutable");
            this.javaClass = javaClass;
            this.kotlinReadOnly = kotlinReadOnly;
            this.kotlinMutable = kotlinMutable;
        }

        @NotNull
        public final ClassId getJavaClass() {
            return this.javaClass;
        }

        @NotNull
        public final ClassId component1() {
            return this.javaClass;
        }

        @NotNull
        public final ClassId component2() {
            return this.kotlinReadOnly;
        }

        @NotNull
        public final ClassId component3() {
            return this.kotlinMutable;
        }

        @NotNull
        public String toString() {
            return "PlatformMutabilityMapping(javaClass=" + this.javaClass + ", kotlinReadOnly=" + this.kotlinReadOnly + ", kotlinMutable=" + this.kotlinMutable + ')';
        }

        public int hashCode() {
            int result2 = this.javaClass.hashCode();
            result2 = result2 * 31 + this.kotlinReadOnly.hashCode();
            result2 = result2 * 31 + this.kotlinMutable.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PlatformMutabilityMapping)) {
                return false;
            }
            PlatformMutabilityMapping platformMutabilityMapping = (PlatformMutabilityMapping)other;
            if (!Intrinsics.areEqual((Object)this.javaClass, (Object)platformMutabilityMapping.javaClass)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.kotlinReadOnly, (Object)platformMutabilityMapping.kotlinReadOnly)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.kotlinMutable, (Object)platformMutabilityMapping.kotlinMutable);
        }
    }
}

