/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.plugins;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.ide.plugins.DescriptorListLoadingContext;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PathBasedJdomXIncluder;

final class DescriptorLoadingContext
implements AutoCloseable {
    private final Map<Path, FileSystem> openedFiles;
    final DescriptorListLoadingContext parentContext;
    final boolean isBundled;
    final boolean isEssential;
    final PathBasedJdomXIncluder.PathResolver<?> pathResolver;

    DescriptorLoadingContext(@NotNull DescriptorListLoadingContext parentContext, boolean isBundled, boolean isEssential, @NotNull PathBasedJdomXIncluder.PathResolver<?> pathResolver) {
        if (parentContext == null) {
            DescriptorLoadingContext.$$$reportNull$$$0(0);
        }
        if (pathResolver == null) {
            DescriptorLoadingContext.$$$reportNull$$$0(1);
        }
        this.openedFiles = new HashMap<Path, FileSystem>();
        this.parentContext = parentContext;
        this.isBundled = isBundled;
        this.isEssential = isEssential;
        this.pathResolver = pathResolver;
    }

    @NotNull
    FileSystem open(@NotNull Path file2) throws IOException {
        FileSystem result2;
        if (file2 == null) {
            DescriptorLoadingContext.$$$reportNull$$$0(2);
        }
        if ((result2 = this.openedFiles.get(file2)) == null) {
            result2 = FileSystems.newFileSystem(file2, (ClassLoader)null);
            this.openedFiles.put(file2, result2);
        }
        FileSystem fileSystem2 = result2;
        if (fileSystem2 == null) {
            DescriptorLoadingContext.$$$reportNull$$$0(3);
        }
        return fileSystem2;
    }

    @Override
    public void close() {
        for (FileSystem file2 : this.openedFiles.values()) {
            try {
                file2.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/ide/plugins/DescriptorLoadingContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/ide/plugins/DescriptorLoadingContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "open";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "open";
                break;
            }
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

