/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db.hibernate;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.context.exe.Converter;
import org.jbpm.util.ClassLoaderUtil;

public class Converters {
    private static final Map convertersByResource = new HashMap();
    private static final Log log = LogFactory.getLog(Converters.class);

    private Converters() {
    }

    public static Converter getConverterByClassName(String className) {
        for (Converter converter : Converters.getConverters().values()) {
            if (!className.equals(converter.getClass().getName())) continue;
            return converter;
        }
        throw new JbpmException(className + " is not registered as a converter");
    }

    public static Converter getConverterByDatabaseId(String converterId) {
        return (Converter)Converters.getConverters().get(converterId);
    }

    public static String getConverterId(Converter converter) {
        for (Map.Entry entry : Converters.getConverters().entrySet()) {
            if (converter != entry.getValue()) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getConverters() {
        String resource = JbpmConfiguration.Configs.getString("resource.converter");
        Map map = convertersByResource;
        synchronized (map) {
            Map converters = (Map)convertersByResource.get(resource);
            if (converters == null) {
                Properties properties = ClassLoaderUtil.getProperties(resource);
                converters = Converters.createConverters(properties);
                convertersByResource.put(resource, converters);
            }
            return converters;
        }
    }

    private static Map createConverters(Properties properties) {
        HashMap<String, Converter> converters = new HashMap<String, Converter>();
        boolean debug = log.isDebugEnabled();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String converterId = (String)entry.getKey();
            if (converterId.length() != 1) {
                throw new JbpmException("converter-id must be a single char");
            }
            String converterClassName = (String)entry.getValue();
            try {
                Class converterClass = ClassLoaderUtil.classForName(converterClassName);
                try {
                    Converter converter = (Converter)converterClass.newInstance();
                    converters.put(converterId, converter);
                    if (!debug) continue;
                    log.debug((Object)("registered " + converterClassName));
                }
                catch (InstantiationException e) {
                    if (!debug) continue;
                    log.debug((Object)("failed to instantiate " + converterClass), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    if (!debug) continue;
                    log.debug((Object)(Converters.class + " has no access to " + converterClass), (Throwable)e);
                }
            }
            catch (ClassNotFoundException e) {
                if (!debug) continue;
                log.debug((Object)("converter class not found: " + converterClassName), (Throwable)e);
            }
        }
        return converters;
    }
}

