/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.jbpm.AbstractJbpmTestCase;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.db.ContextSession;
import org.jbpm.db.GraphSession;
import org.jbpm.db.JbpmSchema;
import org.jbpm.db.JobSession;
import org.jbpm.db.LoggingSession;
import org.jbpm.db.TaskMgmtSession;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.job.Job;
import org.jbpm.job.Timer;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.logging.log.ProcessLog;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;
import org.jbpm.taskmgmt.exe.TaskInstance;

public abstract class AbstractDbTestCase
extends AbstractJbpmTestCase {
    protected JbpmConfiguration jbpmConfiguration;
    protected JbpmContext jbpmContext;
    protected Session session;
    protected GraphSession graphSession;
    protected TaskMgmtSession taskMgmtSession;
    protected ContextSession contextSession;
    protected JobSession jobSession;
    protected LoggingSession loggingSession;
    protected JobExecutor jobExecutor;
    private List processDefinitionIds;
    private static final long JOB_TIMEOUT = 90000L;

    protected void setUp() throws Exception {
        super.setUp();
        this.createJbpmContext();
    }

    protected void runTest() throws Throwable {
        try {
            super.runTest();
        }
        catch (Exception e) {
            if (!this.jbpmContext.isClosed()) {
                this.jbpmContext.setRollbackOnly();
            }
            throw e;
        }
    }

    protected void tearDown() throws Exception {
        if (this.processDefinitionIds != null) {
            this.deleteProcessDefinitions();
        }
        this.closeJbpmContext();
        this.ensureCleanDatabase();
        super.tearDown();
    }

    private void deleteProcessDefinitions() {
        Iterator i = this.processDefinitionIds.iterator();
        while (i.hasNext()) {
            this.newTransaction();
            try {
                Long processDefinitionId = (Long)i.next();
                this.graphSession.deleteProcessDefinition(processDefinitionId);
            }
            catch (RuntimeException e) {
                this.jbpmContext.setRollbackOnly();
            }
        }
    }

    private void ensureCleanDatabase() {
        DbPersistenceServiceFactory persistenceServiceFactory = (DbPersistenceServiceFactory)this.getJbpmConfiguration().getServiceFactory("persistence");
        if (persistenceServiceFactory == null) {
            return;
        }
        boolean hasLeftOvers = false;
        Configuration configuration = persistenceServiceFactory.getConfiguration();
        JbpmSchema jbpmSchema = new JbpmSchema(configuration);
        for (Map.Entry entry : jbpmSchema.getRowsPerTable().entrySet()) {
            Long count = (Long)entry.getValue();
            if (count.intValue() == 0) continue;
            hasLeftOvers = true;
            this.log.error((Object)(this.getName() + " left " + count + " records in " + entry.getKey()));
        }
        if (hasLeftOvers) {
            jbpmSchema.cleanSchema();
        }
    }

    protected String getHibernateDialect() {
        DbPersistenceServiceFactory persistenceServiceFactory = (DbPersistenceServiceFactory)this.jbpmContext.getServiceFactory("persistence");
        return persistenceServiceFactory.getConfiguration().getProperty("hibernate.dialect");
    }

    protected void beginSessionTransaction() {
        this.createJbpmContext();
    }

    protected void commitAndCloseSession() {
        this.closeJbpmContext();
    }

    protected void newTransaction() {
        this.closeJbpmContext();
        this.createJbpmContext();
    }

    protected ProcessInstance saveAndReload(ProcessInstance pi) {
        this.jbpmContext.save(pi);
        this.newTransaction();
        return this.graphSession.loadProcessInstance(pi.getId());
    }

    protected TaskInstance saveAndReload(TaskInstance taskInstance) {
        this.jbpmContext.save(taskInstance);
        this.newTransaction();
        return (TaskInstance)this.session.load(TaskInstance.class, (Serializable)new Long(taskInstance.getId()));
    }

    protected ProcessDefinition saveAndReload(ProcessDefinition pd) {
        this.graphSession.saveProcessDefinition(pd);
        this.registerForDeletion(pd);
        return this.graphSession.loadProcessDefinition(pd.getId());
    }

    protected ProcessLog saveAndReload(ProcessLog processLog) {
        this.loggingSession.saveProcessLog(processLog);
        this.newTransaction();
        return this.loggingSession.loadProcessLog(processLog.getId());
    }

    protected void createSchema() {
        this.getJbpmConfiguration().createSchema();
    }

    protected void cleanSchema() {
        this.getJbpmConfiguration().cleanSchema();
    }

    protected void dropSchema() {
        this.getJbpmConfiguration().dropSchema();
    }

    protected String getJbpmTestConfig() {
        return null;
    }

    protected JbpmConfiguration getJbpmConfiguration() {
        if (this.jbpmConfiguration == null) {
            String configurationResource = this.getJbpmTestConfig();
            this.jbpmConfiguration = JbpmConfiguration.getInstance(configurationResource);
        }
        return this.jbpmConfiguration;
    }

    protected void createJbpmContext() {
        this.jbpmContext = this.getJbpmConfiguration().createJbpmContext();
        this.initializeMembers();
    }

    protected void closeJbpmContext() {
        if (this.jbpmContext != null) {
            this.resetMembers();
            this.jbpmContext.close();
            this.jbpmContext = null;
        }
    }

    protected void startJobExecutor() {
        this.jobExecutor = this.getJbpmConfiguration().getJobExecutor();
        this.jobExecutor.start();
    }

    protected void waitForJobs(long timeout) {
        int currentCount;
        long startTime = System.currentTimeMillis();
        long previousTime = 0L;
        long waitPeriod = 500L;
        int previousCount = 0;
        while ((currentCount = this.getNbrOfJobsAvailable()) > 0) {
            long currentTime = System.currentTimeMillis();
            long elapsedTime = currentTime - startTime;
            if (elapsedTime > timeout) {
                AbstractDbTestCase.fail((String)("test execution exceeded threshold of " + timeout + " ms"));
            }
            if (currentCount < previousCount) {
                waitPeriod = (long)currentCount * (currentTime - previousTime) / (long)(previousCount - currentCount);
                if (waitPeriod < 500L) {
                    waitPeriod = 500L;
                }
            } else {
                waitPeriod <<= 1;
            }
            if (waitPeriod > 5000L) {
                waitPeriod = 5000L;
            } else {
                long remainingTime = timeout - elapsedTime;
                if (waitPeriod > remainingTime) {
                    waitPeriod = remainingTime;
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("waiting " + waitPeriod + " ms for " + currentCount + " jobs"));
            }
            try {
                Thread.sleep(waitPeriod);
            }
            catch (InterruptedException e) {
                AbstractDbTestCase.fail((String)"wait for jobs got interrupted");
            }
            previousCount = currentCount;
            previousTime = currentTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNbrOfJobsAvailable() {
        if (this.session != null) {
            return this.getJobCount(this.session);
        }
        this.createJbpmContext();
        try {
            int n = this.getJobCount(this.session);
            return n;
        }
        finally {
            this.closeJbpmContext();
        }
    }

    private int getJobCount(Session session) {
        Number jobCount = (Number)session.createCriteria(Job.class).add((Criterion)Restrictions.gt((String)"retries", (Object)new Integer(0))).setProjection(Projections.rowCount()).uniqueResult();
        return jobCount.intValue();
    }

    protected int getTimerCount() {
        Number timerCount = (Number)this.session.createCriteria(Timer.class).add((Criterion)Restrictions.gt((String)"retries", (Object)new Integer(0))).setProjection(Projections.rowCount()).uniqueResult();
        return timerCount.intValue();
    }

    protected void processJobs() {
        this.processJobs(90000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processJobs(long timeout) {
        this.closeJbpmContext();
        try {
            this.startJobExecutor();
            this.waitForJobs(timeout);
        }
        finally {
            this.stopJobExecutor();
            this.createJbpmContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopJobExecutor() {
        if (this.jobExecutor != null) {
            try {
                this.jobExecutor.stopAndJoin();
            }
            catch (InterruptedException e) {
                AbstractDbTestCase.fail((String)"wait for job executor to stop got interrupted");
            }
            finally {
                this.jobExecutor = null;
            }
        }
    }

    protected void deployProcessDefinition(ProcessDefinition processDefinition) {
        this.jbpmContext.deployProcessDefinition(processDefinition);
        this.registerForDeletion(processDefinition);
    }

    private void registerForDeletion(ProcessDefinition processDefinition) {
        this.newTransaction();
        if (this.processDefinitionIds == null) {
            this.processDefinitionIds = new ArrayList();
        }
        this.processDefinitionIds.add(new Long(processDefinition.getId()));
    }

    protected void initializeMembers() {
        this.session = this.jbpmContext.getSession();
        this.graphSession = this.jbpmContext.getGraphSession();
        this.taskMgmtSession = this.jbpmContext.getTaskMgmtSession();
        this.loggingSession = this.jbpmContext.getLoggingSession();
        this.jobSession = this.jbpmContext.getJobSession();
        this.contextSession = this.jbpmContext.getContextSession();
    }

    protected void resetMembers() {
        this.session = null;
        this.graphSession = null;
        this.taskMgmtSession = null;
        this.loggingSession = null;
        this.jobSession = null;
        this.contextSession = null;
    }
}

