/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.db.hibernate;

import org.hibernate.dialect.MySQL5InnoDBDialect;
import org.hibernate.internal.util.StringHelper;

/**
 * Small variation of the default MySQL InnoDB dialect meant for a smoother
 * experience with that database. Foreign key addition statements generated by
 * this dialect do not add an index at the same time, thus preventing duplicate
 * index creation.
 * 
 * @see <a href="https://jira.jboss.org/jira/browse/JBPM-2143">JBPM-2143</a>
 * @author Alejandro Guizar
 */
public class MySQLDialect extends MySQL5InnoDBDialect {

  public String getAddForeignKeyConstraintString(String constraintName,
      String[] foreignKey, String referencedTable, String[] primaryKey,
      boolean referencesPrimaryKey) {
    return new StringBuffer(30).append(" add constraint ")
        .append(constraintName)
        .append(" foreign key (")
        .append(StringHelper.join(", ", foreignKey))
        .append(") references ")
        .append(referencedTable)
        .append(" (")
        .append(StringHelper.join(", ", primaryKey))
        .append(')')
        .toString();
  }

}
