/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.reflect.Field;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedField;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.injection.producer.ProducerFieldProducer;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.reflection.Formats;

public class ProducerField<X, T>
extends AbstractProducerBean<X, T, Field> {
    private final AnnotatedField<? super X> annotatedField;
    private volatile EnhancedAnnotatedField<T, ? super X> enhancedAnnotatedField;
    private final boolean proxiable;

    public static <X, T> ProducerField<X, T> of(BeanAttributes<T> attributes, EnhancedAnnotatedField<T, ? super X> field, AbstractClassBean<X> declaringBean, DisposalMethod<X, ?> disposalMethod, BeanManagerImpl beanManager, ServiceRegistry services) {
        return new ProducerField<X, T>(attributes, field, declaringBean, disposalMethod, beanManager, services);
    }

    protected ProducerField(BeanAttributes<T> attributes, EnhancedAnnotatedField<T, ? super X> field, AbstractClassBean<X> declaringBean, DisposalMethod<X, ?> disposalMethod, BeanManagerImpl manager, ServiceRegistry services) {
        super(attributes, ProducerField.createId(field, declaringBean), declaringBean, manager, services);
        this.enhancedAnnotatedField = field;
        this.annotatedField = field.slim();
        this.initType();
        this.proxiable = Proxies.isTypesProxyable(field.getTypeClosure());
        this.setProducer(new ProducerFieldProducer<X, T>(field, disposalMethod){

            @Override
            public AnnotatedField<? super X> getAnnotated() {
                return ProducerField.this.annotatedField;
            }

            @Override
            public BeanManagerImpl getBeanManager() {
                return ProducerField.this.beanManager;
            }

            @Override
            public Bean<X> getDeclaringBean() {
                return ProducerField.this.getDeclaringBean();
            }

            @Override
            public Bean<T> getBean() {
                return ProducerField.this;
            }
        });
    }

    protected static String createId(EnhancedAnnotatedField<?, ?> field, AbstractClassBean<?> declaringBean) {
        StringBuilder sb = new StringBuilder();
        sb.append(ProducerField.class.getSimpleName());
        sb.append("-");
        sb.append(((AnnotatedTypeIdentifier)declaringBean.getAnnotated().getIdentifier()).asString());
        sb.append(".");
        if (declaringBean.getEnhancedAnnotated().isDiscovered()) {
            sb.append(field.getName());
        } else {
            sb.append(AnnotatedTypes.createFieldId(field));
        }
        return sb.toString();
    }

    @Override
    public AnnotatedField<? super X> getAnnotated() {
        return this.annotatedField;
    }

    @Override
    public EnhancedAnnotatedField<T, ? super X> getEnhancedAnnotated() {
        return Beans.checkEnhancedAnnotatedAvailable(this.enhancedAnnotatedField);
    }

    @Override
    public void cleanupAfterBoot() {
        this.enhancedAnnotatedField = null;
    }

    @Override
    public boolean isSpecializing() {
        return false;
    }

    @Override
    public String toString() {
        return "Producer Field [" + Formats.formatType(this.getAnnotated().getBaseType()) + "] with qualifiers [" + Formats.formatAnnotations(this.getQualifiers()) + "] declared as [" + this.getAnnotated() + "]";
    }

    @Override
    public boolean isProxyable() {
        return this.proxiable;
    }

    @Override
    public Set<AbstractBean<?, ?>> getSpecializedBeans() {
        throw new UnsupportedOperationException("Producer field may not specialize other beans " + this);
    }
}

