/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.io.File;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.jboss.shrinkwrap.resolver.api.maven.ConfiguredMavenDependencyResolver;
import org.jboss.shrinkwrap.resolver.api.maven.EffectivePomMavenDependencyResolver;
import org.jboss.shrinkwrap.resolver.api.maven.MavenConfigurationType;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependencyBuilder;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependencyResolver;
import org.jboss.shrinkwrap.resolver.impl.maven.EffectivePomMavenDependencyResolverImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenDependencyBuilderForArtifact;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenDependencyBuilderForArtifacts;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenEnvironment;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenEnvironmentImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenEnvironmentRetrieval;
import org.jboss.shrinkwrap.resolver.impl.maven.util.ResourceUtil;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenDependencyResolverImpl
implements MavenDependencyResolver,
MavenEnvironmentRetrieval {
    private MavenEnvironment maven;

    public MavenDependencyResolverImpl() {
        this.maven = new MavenEnvironmentImpl();
    }

    public MavenDependencyResolverImpl(MavenEnvironment maven) {
        this.maven = maven;
    }

    public <T extends ConfiguredMavenDependencyResolver> T configureFrom(MavenConfigurationType<T> configurationType) {
        Validate.notNull(configurationType, "ConfigurationType instance must not be null");
        return (T)configurationType.configure((MavenDependencyResolver)this);
    }

    public MavenDependencyResolver loadSettings(String userSettings) {
        String resolvedPath = ResourceUtil.resolvePathByQualifier(userSettings);
        Validate.isReadable(resolvedPath, "Path to the settings.xml ('" + userSettings + "') must be defined and accessible");
        this.maven = this.maven.execute((SettingsBuildingRequest)new DefaultSettingsBuildingRequest().setUserSettingsFile(new File(resolvedPath)));
        this.maven.regenerateSession();
        return this;
    }

    public EffectivePomMavenDependencyResolver loadEffectivePom(String path) throws ResolutionException {
        Validate.notNullOrEmpty(path, "Path to a POM file must be specified");
        String resolvedPath = ResourceUtil.resolvePathByQualifier(path);
        Validate.isReadable(resolvedPath, "Path to the pom.xml ('" + path + "')file must be defined and accessible");
        File pom = new File(resolvedPath);
        this.maven = this.maven.execute((ModelBuildingRequest)new DefaultModelBuildingRequest().setPomFile(pom));
        return new EffectivePomMavenDependencyResolverImpl(this.maven);
    }

    public MavenDependencyResolver disableMavenCentral() {
        this.maven = this.maven.useCentralRepository(false);
        return this;
    }

    public MavenDependencyResolver goOffline() {
        this.maven = this.maven.goOffline(true);
        this.maven.regenerateSession();
        return this;
    }

    public MavenDependencyBuilder artifact(String coordinates) throws ResolutionException {
        Validate.notNullOrEmpty(coordinates, "Artifact coordinates must not be null or empty");
        return new MavenDependencyBuilderForArtifact(this.maven, coordinates);
    }

    public MavenDependencyBuilder artifacts(String ... coordinates) throws ResolutionException {
        Validate.notNullAndNoNullValues(coordinates, "Artifacts coordinates must not be null or empty");
        return new MavenDependencyBuilderForArtifacts(this.maven, coordinates);
    }

    @Override
    public MavenEnvironment getMavenEnvironment() {
        return this.maven;
    }
}

