/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.util.ArrayList;
import java.util.Collection;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependencyBuilder;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependencyResolver;
import org.jboss.shrinkwrap.resolver.impl.maven.AbstractMavenDependencyResolverBase;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenConverter;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenDependencyBuilderForArtifact;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenDependencyResolverImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenEnvironment;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MavenDependencyBuilderForArtifacts
extends AbstractMavenDependencyResolverBase
implements MavenDependencyBuilder {
    private int size;

    MavenDependencyBuilderForArtifacts(MavenEnvironment maven, String ... coordinates) {
        super(maven);
        this.size = coordinates.length;
        for (String coords : coordinates) {
            MavenDependency dependency = MavenConverter.asDepedencyWithVersionManagement(maven.getVersionManagement(), coords);
            maven.getDependencies().push(dependency);
        }
    }

    public MavenDependencyResolver up() {
        return new MavenDependencyResolverImpl(this.maven);
    }

    public MavenDependencyBuilder artifact(String coordinates) throws ResolutionException {
        Validate.notNullOrEmpty(coordinates, "Artifact coordinates must not be null or empty");
        MavenDependencyBuilderForArtifact builder = new MavenDependencyBuilderForArtifact(this.maven, coordinates);
        return builder;
    }

    public MavenDependencyBuilder artifacts(String ... coordinates) throws ResolutionException {
        Validate.notNullAndNoNullValues(coordinates, "Artifacts coordinates must not be null or empty");
        MavenDependencyBuilderForArtifacts builder = new MavenDependencyBuilderForArtifacts(this.maven, coordinates);
        return builder;
    }

    public MavenDependencyBuilder scope(String scope) {
        int i;
        ArrayList<MavenDependency> workplace = new ArrayList<MavenDependency>();
        for (i = 0; i < this.size; ++i) {
            MavenDependency dependency = this.maven.getDependencies().pop();
            workplace.add(dependency.scope(scope));
        }
        while (i > 0) {
            this.maven.getDependencies().push((MavenDependency)workplace.get(i - 1));
            --i;
        }
        return this;
    }

    public MavenDependencyBuilder optional(boolean optional) {
        int i;
        ArrayList<MavenDependency> workplace = new ArrayList<MavenDependency>();
        for (i = 0; i < this.size; ++i) {
            MavenDependency dependency = this.maven.getDependencies().pop();
            workplace.add(dependency.optional(optional));
        }
        while (i > 0) {
            this.maven.getDependencies().push((MavenDependency)workplace.get(i - 1));
            --i;
        }
        return this;
    }

    public MavenDependencyBuilder exclusion(String exclusion) {
        int i;
        ArrayList<MavenDependency> workplace = new ArrayList<MavenDependency>();
        for (i = 0; i < this.size; ++i) {
            MavenDependency dependency = this.maven.getDependencies().pop();
            workplace.add(dependency.exclusions(new String[]{exclusion}));
        }
        while (i > 0) {
            this.maven.getDependencies().push((MavenDependency)workplace.get(i - 1));
            --i;
        }
        return this;
    }

    public MavenDependencyBuilder exclusions(String ... exclusions) {
        int i;
        ArrayList<MavenDependency> workplace = new ArrayList<MavenDependency>();
        for (i = 0; i < this.size; ++i) {
            MavenDependency dependency = this.maven.getDependencies().pop();
            workplace.add(dependency.exclusions(exclusions));
        }
        while (i > 0) {
            this.maven.getDependencies().push((MavenDependency)workplace.get(i - 1));
            --i;
        }
        return this;
    }

    public MavenDependencyBuilder exclusions(Collection<String> exclusions) {
        int i;
        ArrayList<MavenDependency> workplace = new ArrayList<MavenDependency>();
        for (i = 0; i < this.size; ++i) {
            MavenDependency dependency = this.maven.getDependencies().pop();
            workplace.add(dependency.exclusions(exclusions.toArray(new String[0])));
        }
        while (i > 0) {
            this.maven.getDependencies().push((MavenDependency)workplace.get(i - 1));
            --i;
        }
        return this;
    }
}

