/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.api.maven;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PackagingType {
    POM("pom"),
    JAR("jar"),
    MAVEN_PLUGIN("maven-plugin"),
    EJB("ejb"),
    WAR("war"),
    EAR("ear"),
    RAR("rar"),
    PAR("par");

    private final String value;
    private static final Map<String, PackagingType> PACKAGING_NAME_CACHE;

    private PackagingType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static PackagingType fromPackagingType(String typeName) throws IllegalArgumentException {
        if (typeName == null || typeName.length() == 0) {
            throw new IllegalArgumentException("Packaging type must not be null nor empty.");
        }
        PackagingType pt = PACKAGING_NAME_CACHE.get(typeName);
        if (pt == null) {
            throw new IllegalArgumentException("Packaging type " + typeName + " is not supported.");
        }
        return pt;
    }

    static {
        PACKAGING_NAME_CACHE = new HashMap<String, PackagingType>(){
            private static final long serialVersionUID = 1L;
            {
                for (PackagingType packaging : PackagingType.values()) {
                    this.put(packaging.value, packaging);
                }
            }
        };
    }
}

