/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.io.File;
import java.util.Set;
import org.jboss.seam.deployment.DeploymentStrategy;
import org.jboss.seam.deployment.DotPageDotXmlDeploymentHandler;
import org.jboss.seam.deployment.FileDescriptor;
import org.jboss.seam.deployment.PagesDotXmlDeploymentHandler;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarRootDeploymentStrategy
extends DeploymentStrategy {
    private static LogProvider log = Logging.getLogProvider(WarRootDeploymentStrategy.class);
    private ClassLoader classLoader;
    private File[] warRoot;
    private File[] excludedDirectories;
    public static final String HANDLERS_KEY = "org.jboss.seam.deployment.deploymentHandlers";
    public static final String NAME = "warRootDeploymentStrategy";
    private DotPageDotXmlDeploymentHandler dotPageDotXmlDeploymentHandler;
    private PagesDotXmlDeploymentHandler pagesDotXmlDeploymentHandler;

    public WarRootDeploymentStrategy(ClassLoader classLoader, File warRoot) {
        this(classLoader, warRoot, new File[0]);
    }

    public WarRootDeploymentStrategy(ClassLoader classLoader, File warRoot, File[] excludedDirectories) {
        this.classLoader = classLoader;
        this.warRoot = new File[1];
        this.excludedDirectories = excludedDirectories;
        if (warRoot != null) {
            this.warRoot[0] = warRoot;
            this.getFiles().add(warRoot);
        } else {
            log.warn("Unable to discover war root, .page.xml files won't be found");
            this.warRoot = new File[0];
        }
        this.dotPageDotXmlDeploymentHandler = new DotPageDotXmlDeploymentHandler();
        this.pagesDotXmlDeploymentHandler = new PagesDotXmlDeploymentHandler();
        this.getDeploymentHandlers().put("org.jboss.seam.deployment.DotPageDotXmlDeploymentHandler", this.dotPageDotXmlDeploymentHandler);
        this.getDeploymentHandlers().put("org.jboss.seam.deployment.PagesDotXmlDeploymentHandler", this.pagesDotXmlDeploymentHandler);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    protected String getDeploymentHandlersKey() {
        return HANDLERS_KEY;
    }

    @Override
    public void scan() {
        this.getScanner().scanDirectories(this.warRoot, this.excludedDirectories);
        this.postScan();
    }

    public File[] getExcludedDirectories() {
        return this.excludedDirectories;
    }

    public Set<FileDescriptor> getDotPageDotXmlFileNames() {
        return this.dotPageDotXmlDeploymentHandler.getResources();
    }
}

