/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.text.MessageFormat;
import java.util.StringTokenizer;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.Locale;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

@BypassInterceptors
@Scope(value=ScopeType.STATELESS)
@Name(value="org.jboss.seam.core.interpolator")
@Install(precedence=0)
public class Interpolator {
    private static final LogProvider log = Logging.getLogProvider(Interpolator.class);

    public static Interpolator instance() {
        if (Contexts.isApplicationContextActive()) {
            return (Interpolator)Component.getInstance(Interpolator.class, ScopeType.APPLICATION);
        }
        return new Interpolator();
    }

    public String interpolate(String string, Object ... params) {
        if (params == null) {
            params = new Object[]{};
        }
        if (params.length > 10) {
            throw new IllegalArgumentException("more than 10 parameters");
        }
        if (string.indexOf(35) >= 0 || string.indexOf(123) >= 0) {
            string = this.interpolateExpressions(string, params);
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String interpolateExpressions(String string, Object ... params) {
        StringTokenizer tokens = new StringTokenizer(string, "#{}", true);
        StringBuilder builder = new StringBuilder(string.length());
        try {
            while (tokens.hasMoreTokens()) {
                int level;
                StringBuilder expr;
                String tok = tokens.nextToken();
                if ("#".equals(tok) && tokens.hasMoreTokens()) {
                    String nextTok = tokens.nextToken();
                    while (nextTok.equals("#") && tokens.hasMoreTokens()) {
                        builder.append(tok);
                        nextTok = tokens.nextToken();
                    }
                    if ("{".equals(nextTok)) {
                        String expression = "#{" + tokens.nextToken() + "}";
                        try {
                            Object value = Expressions.instance().createValueExpression(expression).getValue();
                            if (value != null) {
                                builder.append(value);
                            }
                        }
                        catch (Exception e) {
                            log.debug("exception interpolating string: " + string, e);
                        }
                        tokens.nextToken();
                        continue;
                    }
                    if (nextTok.equals("#")) {
                        builder.append("#");
                        continue;
                    }
                    try {
                        int index = Integer.parseInt(nextTok.substring(0, 1));
                        if (index >= params.length) {
                            builder.append("#").append(nextTok);
                            continue;
                        }
                        builder.append(params[index]).append(nextTok.substring(1));
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        builder.append("#").append(nextTok);
                        continue;
                    }
                }
                if ("{".equals(tok)) {
                    expr = new StringBuilder();
                    expr.append(tok);
                    level = 1;
                } else {
                    builder.append(tok);
                    continue;
                }
                while (tokens.hasMoreTokens()) {
                    String nextTok = tokens.nextToken();
                    expr.append(nextTok);
                    if (nextTok.equals("{")) {
                        ++level;
                        continue;
                    }
                    if (!nextTok.equals("}") || --level != 0) continue;
                    try {
                        if (params.length == 0) {
                            builder.append(expr.toString());
                        } else {
                            String value = new MessageFormat(expr.toString(), Locale.instance()).format(params);
                            builder.append(value);
                        }
                    }
                    catch (Exception e) {
                        builder.append((CharSequence)expr);
                    }
                    expr = null;
                    break;
                }
                if (expr == null) continue;
                builder.append((CharSequence)expr);
            }
            return builder.toString();
        }
        catch (Exception e) {
            log.debug("exception interpolating string: " + string, e);
        }
        return builder.toString();
    }
}

