/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.resteasy;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.plugins.server.servlet.HttpServletInputMessage;
import org.jboss.resteasy.plugins.server.servlet.HttpServletResponseWrapper;
import org.jboss.resteasy.plugins.server.servlet.ServletSecurityContext;
import org.jboss.resteasy.plugins.server.servlet.ServletUtil;
import org.jboss.resteasy.specimpl.PathSegmentImpl;
import org.jboss.resteasy.specimpl.UriBuilderImpl;
import org.jboss.resteasy.specimpl.UriInfoImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.PathHelper;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.log.Log;
import org.jboss.seam.resteasy.Application;
import org.jboss.seam.resteasy.SeamResteasyProviderFactory;
import org.jboss.seam.servlet.ContextualHttpServletRequest;
import org.jboss.seam.web.AbstractResource;
import org.jboss.seam.web.Session;

@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.resteasy.resourceAdapter")
@BypassInterceptors
public class ResteasyResourceAdapter
extends AbstractResource {
    @Logger
    Log log;
    protected Dispatcher dispatcher;
    protected Application application;

    @Create
    public void init() {
        this.dispatcher = (Dispatcher)Component.getInstance((String)"org.jboss.seam.resteasy.dispatcher");
        this.application = (Application)((Object)Component.getInstance(Application.class));
        if (this.dispatcher == null) {
            throw new IllegalStateException("ReasteasyDispatcher not available, make sure RESTEasy and all required JARs are on your classpath");
        }
    }

    public String getResourcePath() {
        return this.application.getResourcePathPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getResource(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        try {
            this.log.debug((Object)"processing REST request", new Object[0]);
            ThreadLocalResteasyProviderFactory.push((ResteasyProviderFactory)this.dispatcher.getProviderFactory());
            SeamResteasyProviderFactory.pushContext(HttpServletRequest.class, (Object)request);
            SeamResteasyProviderFactory.pushContext(HttpServletResponse.class, (Object)response);
            SeamResteasyProviderFactory.pushContext(SecurityContext.class, (Object)new ServletSecurityContext(request));
            new ContextualHttpServletRequest(request){

                public void process() throws ServletException, IOException {
                    HttpHeaders headers = ServletUtil.extractHttpHeaders((HttpServletRequest)request);
                    UriInfoImpl uriInfo = ResteasyResourceAdapter.this.extractUriInfo(request);
                    HttpServletResponseWrapper theResponse = new HttpServletResponseWrapper(response, ResteasyResourceAdapter.this.dispatcher.getProviderFactory());
                    HttpServletInputMessage in = new HttpServletInputMessage(request, (HttpResponse)theResponse, headers, (UriInfo)uriInfo, request.getMethod().toUpperCase(), (SynchronousDispatcher)ResteasyResourceAdapter.this.dispatcher);
                    ResteasyResourceAdapter.this.dispatcher.invoke((HttpRequest)in, (HttpResponse)theResponse);
                    if (request.getSession().isNew() && ResteasyResourceAdapter.this.application.isDestroySessionAfterRequest() && !Session.instance().isInvalid()) {
                        ResteasyResourceAdapter.this.log.debug((Object)"Destroying HttpSession after REST request", new Object[0]);
                        Session.instance().invalidate();
                    }
                }
            }.run();
        }
        finally {
            SeamResteasyProviderFactory.clearContextData();
            ThreadLocalResteasyProviderFactory.pop();
            this.log.debug((Object)"completed processing of REST request", new Object[0]);
        }
    }

    protected UriInfoImpl extractUriInfo(HttpServletRequest request) {
        URI absolutePath;
        String contextPath = request.getContextPath();
        try {
            URL absolute = new URL(request.getRequestURL().toString());
            UriBuilderImpl builder = new UriBuilderImpl();
            builder.scheme(absolute.getProtocol());
            builder.host(absolute.getHost());
            builder.port(absolute.getPort());
            builder.path(absolute.getPath());
            builder.replaceQuery(absolute.getQuery());
            absolutePath = builder.build(new Object[0]);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        String path = PathHelper.getEncodedPathInfo((String)absolutePath.getRawPath(), (String)contextPath);
        if (this.application.isStripSeamResourcePath()) {
            this.log.debug((Object)"removing SeamResourceServlet url-pattern and dispatcher prefix from request path", new Object[0]);
            path = path.substring(path.indexOf(this.getResourcePath()) + this.getResourcePath().length());
        }
        List pathSegments = PathSegmentImpl.parseSegments((String)path);
        URI baseURI = absolutePath;
        if (!path.trim().equals("")) {
            String tmpContextPath = contextPath;
            if (!tmpContextPath.endsWith("/")) {
                tmpContextPath = tmpContextPath + "/";
            }
            baseURI = UriBuilder.fromUri((URI)absolutePath).replacePath(tmpContextPath).build(new Object[0]);
        }
        this.log.debug((Object)("UriInfo, absolute URI       : " + absolutePath), new Object[0]);
        this.log.debug((Object)("UriInfo, base URI           : " + baseURI), new Object[0]);
        this.log.debug((Object)("UriInfo, relative path/@Path: " + path), new Object[0]);
        this.log.debug((Object)("UriInfo, query string       : " + request.getQueryString()), new Object[0]);
        return new UriInfoImpl(absolutePath, baseURI, path, request.getQueryString(), pathSegments);
    }
}

