/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.scannotation.AnnotationDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigurationBootstrap {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationBootstrap.class);
    private ResteasyDeployment deployment = new ResteasyDeployment();

    public abstract String getParameter(String var1);

    public abstract URL[] getScanningUrls();

    public ResteasyDeployment createDeployment() {
        String append;
        String after;
        String before;
        String languageExtensions;
        String mimeExtentions;
        String paramMapping;
        String resources;
        String jndiResources;
        String sResources;
        String scanAll;
        String builtin;
        String resourceMethodInterceptors;
        String applicationConfig;
        String deploymentSensitive = this.getParameter("resteasy.use.deployment.sensitive.factory");
        if (deploymentSensitive != null) {
            this.deployment.setDeploymentSensitiveFactoryEnabled(Boolean.valueOf(deploymentSensitive.trim()));
        } else {
            this.deployment.setDeploymentSensitiveFactoryEnabled(true);
        }
        String async = this.getParameter("resteasy.async.job.service.enabled");
        if (async != null) {
            this.deployment.setAsyncJobServiceEnabled(Boolean.valueOf(async.trim()));
        }
        if (this.deployment.isAsyncJobServiceEnabled()) {
            String basePath;
            String threadPool;
            String maxWaitStr;
            String maxJobResults = this.getParameter("resteasy.async.job.service.max.job.results");
            if (maxJobResults != null) {
                int maxJobs = Integer.valueOf(maxJobResults);
                this.deployment.setAsyncJobServiceMaxJobResults(maxJobs);
            }
            if ((maxWaitStr = this.getParameter("resteasy.async.job.service.max.wait")) != null) {
                long maxWait = Long.valueOf(maxWaitStr);
                this.deployment.setAsyncJobServiceMaxWait(maxWait);
            }
            if ((threadPool = this.getParameter("resteasy.async.job.service.thread.pool.size")) != null) {
                int threadPoolSize = Integer.valueOf(threadPool);
                this.deployment.setAsyncJobServiceThreadPoolSize(threadPoolSize);
            }
            if ((basePath = this.getParameter("resteasy.async.job.service.base.path")) != null) {
                this.deployment.setAsyncJobServiceBasePath(basePath);
            }
        }
        if ((applicationConfig = this.getParameter(Application.class.getName())) == null) {
            applicationConfig = this.getParameter("javax.ws.rs.Application");
        } else {
            logger.warn("The use of " + Application.class.getName() + " is deprecated, please use javax.ws.rs.Application as a context-param instead");
        }
        String providers = this.getParameter("resteasy.providers");
        if (providers != null) {
            String[] p;
            for (String pr : p = providers.split(",")) {
                this.deployment.getProviderClasses().add(pr.trim());
            }
        }
        if ((resourceMethodInterceptors = this.getParameter("resteasy.resource.method.interceptors")) != null) {
            throw new RuntimeException("resteasy.resource.method.interceptors is no longer a supported context param.  See documentation for more details");
        }
        String resteasySecurity = this.getParameter("resteasy.role.based.security");
        if (resteasySecurity != null) {
            this.deployment.setSecurityEnabled(Boolean.valueOf(resteasySecurity.trim()));
        }
        if ((builtin = this.getParameter("resteasy.use.builtin.providers")) != null) {
            this.deployment.setRegisterBuiltin(Boolean.valueOf(builtin.trim()));
        }
        boolean scanProviders = false;
        boolean scanResources = false;
        String sProviders = this.getParameter("resteasy.scan.providers");
        if (sProviders != null) {
            scanProviders = Boolean.valueOf(sProviders.trim());
        }
        if ((scanAll = this.getParameter("resteasy.scan")) != null) {
            boolean tmp = Boolean.valueOf(scanAll.trim());
            scanProviders = tmp || scanProviders;
            boolean bl = scanResources = tmp || scanResources;
        }
        if ((sResources = this.getParameter("resteasy.scan.resources")) != null) {
            scanResources = Boolean.valueOf(sResources.trim());
        }
        if (scanProviders || scanResources) {
            URL[] urls;
            logger.debug("Scanning...");
            if (applicationConfig != null) {
                throw new RuntimeException("You cannot deploy a javax.ws.rs.core.Application and have scanning on as this may create errors");
            }
            for (URL u : urls = this.getScanningUrls()) {
                logger.debug("Scanning archive: " + u);
            }
            AnnotationDB db = new AnnotationDB();
            String[] ignoredPackages = new String[]{"org.jboss.resteasy.plugins", "org.jboss.resteasy.annotations", "org.jboss.resteasy.client", "org.jboss.resteasy.specimpl", "org.jboss.resteasy.core", "org.jboss.resteasy.spi", "org.jboss.resteasy.util", "org.jboss.resteasy.mock", "javax.ws.rs"};
            db.setIgnoredPackages(ignoredPackages);
            db.setScanClassAnnotations(true);
            db.setScanFieldAnnotations(false);
            db.setScanMethodAnnotations(false);
            db.setScanParameterAnnotations(false);
            try {
                db.scanArchives(urls);
                try {
                    db.crossReferenceImplementedInterfaces();
                    db.crossReferenceMetaAnnotations();
                }
                catch (AnnotationDB.CrossReferenceException ignored) {}
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to scan WEB-INF for JAX-RS annotations, you must manually register your classes/resources", e);
            }
            if (scanProviders) {
                this.processProviders(db);
            }
            if (scanResources) {
                this.processResources(db);
            }
        }
        if ((jndiResources = this.getParameter("resteasy.jndi.resources")) != null) {
            this.processJndiResources(jndiResources);
        }
        if ((resources = this.getParameter("resteasy.resources")) != null) {
            this.processResources(resources);
        }
        if ((paramMapping = this.getParameter("resteasy.media.type.param.mapping")) != null) {
            if ((paramMapping = paramMapping.trim()).length() > 0) {
                this.deployment.setMediaTypeParamMapping(paramMapping);
            } else {
                this.deployment.setMediaTypeParamMapping("Accept".toLowerCase());
            }
        }
        if ((mimeExtentions = this.getParameter("resteasy.media.type.mappings")) != null) {
            Map<String, String> map = this.parseMap(mimeExtentions);
            this.deployment.setMediaTypeMappings(map);
        }
        if ((languageExtensions = this.getParameter("resteasy.language.mappings")) != null) {
            Map<String, String> map = this.parseMap(languageExtensions);
            this.deployment.setLanguageExtensions(map);
        }
        if ((before = this.getParameter("resteasy.interceptor.before.precedence")) != null) {
            Map<String, String> map = this.parseMap(before);
            this.deployment.setInterceptorBeforePrecedences(map);
        }
        if ((after = this.getParameter("resteasy.interceptor.after.precedence")) != null) {
            Map<String, String> map = this.parseMap(after);
            this.deployment.setInterceptorAfterPrecedences(map);
        }
        if ((append = this.getParameter("resteasy.append.interceptor.precedence")) != null) {
            String[] precedences;
            for (String precedence : precedences = append.split(",")) {
                this.deployment.getInterceptorPrecedences().add(precedence.trim());
            }
        }
        if (applicationConfig != null) {
            this.deployment.setApplicationClass(applicationConfig);
        }
        return this.deployment;
    }

    protected Map<String, String> parseMap(String map) {
        String[] entries;
        HashMap<String, String> parsed = new HashMap<String, String>();
        for (String entry : entries = map.trim().split(",")) {
            String[] split = entry.trim().split(":");
            parsed.put(split[0].trim(), split[1].trim());
        }
        return parsed;
    }

    protected void processJndiResources(String jndiResources) {
        String[] resources;
        for (String resource : resources = jndiResources.trim().split(",")) {
            this.deployment.getJndiResources().add(resource);
        }
    }

    protected void processResources(String list) {
        String[] resources;
        for (String resource : resources = list.trim().split(",")) {
            this.deployment.getResourceClasses().add(resource);
        }
    }

    protected void processProviders(AnnotationDB db) {
        Set classes = (Set)db.getAnnotationIndex().get(Provider.class.getName());
        if (classes == null) {
            return;
        }
        for (String clazz : classes) {
            logger.info("Adding scanned @Provider: " + clazz);
            this.deployment.getProviderClasses().add(clazz);
        }
    }

    protected void processResources(AnnotationDB db) {
        HashSet classes = new HashSet();
        Set paths = (Set)db.getAnnotationIndex().get(Path.class.getName());
        if (paths != null) {
            classes.addAll(paths);
        }
        for (String clazz : classes) {
            Class<?> cls = null;
            try {
                cls = Thread.currentThread().getContextClassLoader().loadClass(clazz.trim());
                if (cls.isInterface()) {
                    continue;
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            logger.info("Adding scanned resource: " + clazz);
            this.deployment.getResourceClasses().add(clazz);
        }
    }
}

