/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal.proxy;

import java.lang.reflect.Method;
import javax.ws.rs.Path;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.client.jaxrs.ProxyConfig;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocationBuilder;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.client.jaxrs.internal.proxy.MethodInvoker;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.ClientContext;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.DefaultEntityExtractorFactory;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.EntityExtractor;
import org.jboss.resteasy.client.jaxrs.internal.proxy.processors.InvocationProcessor;
import org.jboss.resteasy.client.jaxrs.internal.proxy.processors.ProcessorFactory;
import org.jboss.resteasy.client.jaxrs.internal.proxy.processors.WebTargetProcessor;
import org.jboss.resteasy.util.MediaTypeHelper;

public class ClientInvoker
implements MethodInvoker {
    protected String httpMethod;
    protected Method method;
    protected Class declaring;
    protected MediaType accepts;
    protected Object[] processors;
    protected ResteasyWebTarget webTarget;
    protected boolean followRedirects;
    protected EntityExtractor extractor;
    protected DefaultEntityExtractorFactory entityExtractorFactory;
    protected ClientConfiguration invokerConfig;

    public ClientInvoker(ResteasyWebTarget parent, Class declaring, Method method, ProxyConfig config) {
        this.webTarget = method.isAnnotationPresent(Path.class) ? parent.path(method) : parent.clone();
        this.declaring = declaring;
        this.method = method;
        this.invokerConfig = (ClientConfiguration)this.webTarget.configuration();
        ResourceInfo info = new ResourceInfo(){

            public Method getResourceMethod() {
                return ClientInvoker.this.method;
            }

            public Class<?> getResourceClass() {
                return ClientInvoker.this.declaring;
            }
        };
        for (DynamicFeature feature : this.invokerConfig.getDynamicFeatures()) {
            feature.configure(info, (Configurable)this.invokerConfig);
        }
        this.processors = ProcessorFactory.createProcessors(declaring, method, this.invokerConfig, config.getDefaultConsumes());
        this.accepts = MediaTypeHelper.getProduces((Class)declaring, (Method)method, (MediaType)config.getDefaultProduces());
        this.entityExtractorFactory = new DefaultEntityExtractorFactory();
        this.extractor = this.entityExtractorFactory.createExtractor(method);
    }

    public MediaType getAccepts() {
        return this.accepts;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class getDeclaring() {
        return this.declaring;
    }

    @Override
    public Object invoke(Object[] args) {
        ClientInvocation request = this.createRequest(args);
        ClientResponse response = (ClientResponse)request.invoke();
        ClientContext context = new ClientContext(request, response, this.entityExtractorFactory);
        return this.extractor.extractEntity(context, null);
    }

    protected ClientInvocation createRequest(Object[] args) {
        ResteasyWebTarget target = this.webTarget;
        for (int i = 0; i < this.processors.length; ++i) {
            if (this.processors == null || !(this.processors[i] instanceof WebTargetProcessor)) continue;
            WebTargetProcessor processor = (WebTargetProcessor)this.processors[i];
            target = processor.build(target, args[i]);
        }
        ClientInvocationBuilder builder = null;
        builder = this.accepts != null ? (ClientInvocationBuilder)target.request(new MediaType[]{this.accepts}) : (ClientInvocationBuilder)target.request();
        for (int i = 0; i < this.processors.length; ++i) {
            if (this.processors == null || !(this.processors[i] instanceof InvocationProcessor)) continue;
            InvocationProcessor processor = (InvocationProcessor)this.processors[i];
            processor.process(builder, args[i]);
        }
        return (ClientInvocation)builder.build(this.httpMethod);
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void followRedirects() {
        this.setFollowRedirects(true);
    }
}

