/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.tools.osb.mbean.jta;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.tools.osb.mbean.ActionBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.HeuristicStatus;
import com.arjuna.ats.arjuna.tools.osb.mbean.LogRecordWrapper;
import com.arjuna.ats.arjuna.tools.osb.mbean.ParticipantStatus;
import com.arjuna.ats.arjuna.tools.osb.mbean.UidWrapper;
import com.arjuna.ats.internal.jta.resources.arjunacore.XAResourceRecord;
import com.arjuna.ats.internal.jta.tools.osb.mbean.jta.XAResourceRecordBeanMBean;
import com.arjuna.ats.internal.jta.xa.XID;
import com.arjuna.ats.jta.xa.XATxConverter;
import com.arjuna.ats.jta.xa.XidImple;
import java.io.IOException;
import javax.management.MBeanException;
import javax.transaction.xa.XAResource;

@Deprecated
public class XAResourceRecordBean
extends LogRecordWrapper
implements XAResourceRecordBeanMBean {
    String className = "unavailable";
    String eisProductName = "unavailable";
    String eisProductVersion = "unavailable";
    String jndiName = "unavailable";
    int timeout = 0;
    JTAXAResourceRecordWrapper xares;
    XidImple xidImple;
    int heuristic;

    public XAResourceRecordBean(UidWrapper w) {
        super(w.getUid());
        this.init();
        this.xares = new JTAXAResourceRecordWrapper(w.getUid());
        this.xidImple = new XidImple(new XID());
        this.heuristic = -1;
    }

    public XAResourceRecordBean(ActionBean parent, AbstractRecord rec, ParticipantStatus listType) {
        super(parent, rec, listType);
        this.init();
        this.xares = new JTAXAResourceRecordWrapper(rec);
        this.xidImple = this.xares.xidImple;
        this.heuristic = this.xares.heuristic;
    }

    private void init() {
        this.jndiName = this.getUid().stringForm();
        this.className = "unavailable";
        this.eisProductName = "unavailable";
        this.eisProductVersion = "unavailable";
        this.timeout = 0;
    }

    @Override
    public boolean activate() {
        boolean ok = super.activate();
        this.className = this.rec.getClass().getName();
        if (this.rec instanceof XAResourceRecord) {
            XAResourceRecord xarec = (XAResourceRecord)this.rec;
            this.eisProductName = xarec.getProductName();
            this.eisProductVersion = xarec.getProductVersion();
            this.jndiName = xarec.getJndiName();
        }
        if (this.rec.value() != null) {
            XAResource xar = (XAResource)this.rec.value();
            this.className = xar.getClass().getName();
            try {
                this.timeout = xar.getTransactionTimeout();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ok;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getEisProductName() {
        return this.eisProductName;
    }

    @Override
    public String getEisProductVersion() {
        return this.eisProductVersion;
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public String getHeuristicStatus() {
        return HeuristicStatus.intToStatus(this.xares.heuristic).name();
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.xidImple.getGlobalTransactionId();
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.xidImple.getBranchQualifier();
    }

    @Override
    public int getFormatId() {
        return this.xidImple.getFormatId();
    }

    @Override
    public String getNodeName() {
        return XATxConverter.getNodeName(this.xidImple.getXID());
    }

    @Override
    public int getHeuristicValue() {
        return this.heuristic;
    }

    @Override
    public boolean forget() {
        return this.xares.forgetHeuristic();
    }

    @Override
    public String remove() throws MBeanException {
        return super.remove();
    }

    class JTAXAResourceRecordWrapper
    extends XAResourceRecord {
        XidImple xidImple;
        int heuristic;
        AbstractRecord rec;
        XAResourceRecord xarec;

        public JTAXAResourceRecordWrapper(Uid uid) {
            super(uid);
            this.xidImple = null;
            this.heuristic = -1;
            this.xidImple = new XidImple(this.getXid());
        }

        public JTAXAResourceRecordWrapper(AbstractRecord rec) {
            this(rec.order());
            this.rec = rec;
            this.xarec = (XAResourceRecord)rec;
            this.heuristic = ((XAResourceRecord)rec).getHeuristic();
        }

        @Override
        public boolean activate() {
            return super.activate();
        }

        @Override
        public boolean restore_state(InputObjectState os, int t) {
            InputObjectState copy = new InputObjectState(os);
            try {
                this.heuristic = copy.unpackInt();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return super.restore_state(os, t);
        }

        @Override
        public boolean forgetHeuristic() {
            if (this.xarec != null) {
                this.xarec.forgetHeuristic();
                return this.xarec.isForgotten();
            }
            return super.forgetHeuristic();
        }
    }
}

