/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.recovery.arjunacore;

import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.internal.jta.recovery.arjunacore.SubordinateAtomicActionRecoveryModule;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateTransaction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinationManager;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.recovery.XAResourceOrphanFilter;
import com.arjuna.ats.jta.xa.XATxConverter;
import com.arjuna.ats.jta.xa.XidImple;
import java.util.List;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class SubordinationManagerXAResourceOrphanFilter
implements XAResourceOrphanFilter {
    private SubordinateAtomicActionRecoveryModule subordinateAtomicActionRecoveryModule;

    @Override
    public XAResourceOrphanFilter.Vote checkXid(Xid xid) {
        if (xid.getFormatId() != 131077) {
            return XAResourceOrphanFilter.Vote.ABSTAIN;
        }
        List<String> _xaRecoveryNodes = jtaPropertyManager.getJTAEnvironmentBean().getXaRecoveryNodes();
        if (_xaRecoveryNodes == null || _xaRecoveryNodes.isEmpty()) {
            jtaLogger.i18NLogger.info_recovery_noxanodes();
            return XAResourceOrphanFilter.Vote.ABSTAIN;
        }
        String nodeName = XATxConverter.getSubordinateNodeName(new XidImple(xid).getXID());
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug((Object)("subordinate node name of " + String.valueOf(xid) + " is " + nodeName));
        }
        if (!_xaRecoveryNodes.contains(nodeName)) {
            return XAResourceOrphanFilter.Vote.ABSTAIN;
        }
        if (!this.getSubordinateAtomicActionRecoveryModule().isRecoveryScanCompletedWithoutError()) {
            return XAResourceOrphanFilter.Vote.LEAVE_ALONE;
        }
        XidImple theXid = new XidImple(xid);
        SubordinateTransaction importedTransaction = null;
        try {
            importedTransaction = SubordinationManager.getTransactionImporter().getImportedTransaction(theXid);
        }
        catch (XAException e) {
            return XAResourceOrphanFilter.Vote.LEAVE_ALONE;
        }
        if (importedTransaction != null) {
            return XAResourceOrphanFilter.Vote.LEAVE_ALONE;
        }
        return XAResourceOrphanFilter.Vote.ROLLBACK;
    }

    private SubordinateAtomicActionRecoveryModule getSubordinateAtomicActionRecoveryModule() {
        if (this.subordinateAtomicActionRecoveryModule == null) {
            Vector<RecoveryModule> modules = RecoveryManager.manager().getModules();
            for (RecoveryModule module : modules) {
                if (!module.getClass().equals(SubordinateAtomicActionRecoveryModule.class)) continue;
                this.subordinateAtomicActionRecoveryModule = (SubordinateAtomicActionRecoveryModule)module;
            }
        }
        return this.subordinateAtomicActionRecoveryModule;
    }
}

