/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.jboss.maven.plugins.qstools.QSChecker;
import org.jboss.maven.plugins.qstools.Violation;
import org.jboss.maven.plugins.qstools.checkers.AbstractBaseCheckerAdapter;
import org.jboss.maven.plugins.qstools.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Component(role=QSChecker.class, hint="repositoryDeclarationChecker")
public class RepositoryDeclarationChecker
extends AbstractBaseCheckerAdapter {
    @Override
    public String getCheckerDescription() {
        return "Checks if a repository was declared on pom.xml";
    }

    @Override
    public void checkProject(MavenProject project, Document doc, Map<String, List<Violation>> results) throws Exception {
        Node repositoriesNode = (Node)this.getxPath().evaluate("//project/repositories", doc, XPathConstants.NODE);
        if (repositoriesNode != null) {
            int lineNumber = XMLUtil.getLineNumberFromNode(repositoriesNode);
            this.addViolation(project.getFile(), results, lineNumber, "You should NOT declare <repositories/> on your pom.xml");
        }
    }
}

