/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.formatters;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.IntFunction;

abstract class FlagSet<E extends Enum<E>>
extends AbstractSet<E> {
    final int value;

    FlagSet(int value) {
        this.value = value;
    }

    abstract E[] values();

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int bits;
            {
                this.bits = FlagSet.this.value;
            }

            @Override
            public boolean hasNext() {
                return this.bits != 0;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int lob = Integer.lowestOneBit(this.bits);
                this.bits &= ~lob;
                return FlagSet.this.values()[Integer.numberOfTrailingZeros(lob)];
            }
        };
    }

    @Override
    public int size() {
        return Integer.bitCount(this.value);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        int lob;
        for (int bits = this.value; bits != 0; bits &= ~lob) {
            lob = Integer.lowestOneBit(bits);
            action.accept(this.values()[Integer.numberOfTrailingZeros(lob)]);
        }
    }

    @Override
    public <T> T[] toArray(IntFunction<T[]> generator) {
        int lob;
        T[] array = generator.apply(this.size());
        int idx = 0;
        for (int bits = this.value; bits != 0; bits &= ~lob) {
            lob = Integer.lowestOneBit(bits);
            array[idx++] = this.values()[Integer.numberOfTrailingZeros(lob)];
        }
        return array;
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof Enum && this.contains((Enum)o);
    }

    public boolean contains(Enum<?> e) {
        return e != null && (this.value & 1 << e.ordinal()) != 0;
    }

    @Override
    public int hashCode() {
        int hc = 0;
        int bits = this.value;
        while (bits != 0) {
            int lob = Integer.lowestOneBit(bits);
            bits &= ~lob;
            hc += this.values()[Integer.numberOfTrailingZeros(lob)].hashCode();
        }
        return hc;
    }

    @Override
    public boolean equals(Object o) {
        return o.getClass() == this.getClass() && ((FlagSet)o).value == this.value || super.equals(o);
    }

    public void forbid(E flag) {
        if (this.contains((Enum<?>)flag)) {
            throw FlagSet.notAllowed(flag);
        }
    }

    public void forbidAll() {
        if (!this.isEmpty()) {
            throw FlagSet.notAllowed(this);
        }
    }

    public void forbidAllBut(E flag) {
        this.without(flag).forbidAll();
    }

    abstract FlagSet<E> without(E var1);

    private static IllegalArgumentException notAllowed(FlagSet<?> set) {
        return new IllegalArgumentException("Flags " + set + " are not allowed here");
    }

    private static IllegalArgumentException notAllowed(Enum<?> flag) {
        return new IllegalArgumentException("Flag " + flag + " is not allowed here");
    }
}

