/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.validation;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logging.processor.validation.AbstractFormatValidator;
import org.jboss.logging.processor.validation.FormatPart;
import org.jboss.logging.processor.validation.MessageFormatPart;
import org.jboss.logging.processor.validation.StringPart;

class MessageFormatValidator
extends AbstractFormatValidator {
    public final String PATTERN = "\\{}|\\{.+?}";
    private final Set<FormatPart> formatParts = new TreeSet<FormatPart>();
    private final Set<MessageFormatPart> formats = new TreeSet<MessageFormatPart>();
    private int argumentCount;
    private boolean valid;
    private final String format;

    private MessageFormatValidator(String format) {
        this.format = format;
        this.valid = true;
    }

    public static MessageFormatValidator of(String format) {
        MessageFormatValidator result = new MessageFormatValidator(format);
        result.init();
        result.validate();
        return result;
    }

    public static MessageFormatValidator of(String format, Object ... parameters) {
        MessageFormatValidator result = new MessageFormatValidator(format);
        result.init();
        result.validate();
        result.parameterCheck(parameters);
        return result;
    }

    public static MessageFormatValidator of(String format, int parameterCount) {
        MessageFormatValidator result = new MessageFormatValidator(format);
        result.init();
        result.validate();
        result.parameterCheck(parameterCount);
        return result;
    }

    @Override
    public int argumentCount() {
        return this.argumentCount;
    }

    @Override
    public String format() {
        return this.format;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    private void validate() {
        int start = this.format.indexOf("{");
        int end = this.format.indexOf("}");
        while (start != -1 && this.valid) {
            if (end < start) {
                this.valid = false;
                this.setSummaryMessage("Format %s appears to be missing an ending bracket.", this.format);
            }
            if ((start = this.format.indexOf("{", end)) <= 0) continue;
            end = this.format.indexOf("}", start);
        }
    }

    private void parameterCheck(Object ... parameters) {
        if (this.argumentCount > 0 && parameters == null) {
            this.valid = false;
            this.setSummaryMessage("Invalid parameter count. Required %d provided null for format '%s'.", this.argumentCount, this.format);
            this.setDetailMessage("Required %d parameters, but none were provided for format %s.", this.argumentCount, this.format);
        } else {
            this.parameterCheck(parameters.length);
        }
    }

    private void parameterCheck(int parameterCount) {
        if (this.argumentCount != parameterCount) {
            this.valid = false;
            this.setSummaryMessage("Invalid parameter count. Required: %d provided %d for format '%s'.", this.argumentCount, parameterCount, this.format);
            this.setDetailMessage("Required %d parameters, but %d were provided for format %s.", this.argumentCount, parameterCount, this.format);
        }
    }

    private void init() {
        Pattern pattern = Pattern.compile("\\{}|\\{.+?}");
        Matcher matcher = pattern.matcher(this.format);
        int position = 0;
        int i = 0;
        while (i < this.format.length()) {
            if (matcher.find(i)) {
                if (matcher.start() != i) {
                    this.formatParts.add(StringPart.of(position++, this.format.substring(i, matcher.start())));
                }
                MessageFormatPart messageFormatPart = MessageFormatPart.of(position++, matcher.group());
                this.formatParts.add(messageFormatPart);
                this.formats.add(messageFormatPart);
                i = matcher.end();
                continue;
            }
            this.formatParts.add(StringPart.of(position, this.format.substring(i)));
            break;
        }
        HashSet<Integer> counted = new HashSet<Integer>();
        for (MessageFormatPart messageFormatPart : this.formats) {
            if (messageFormatPart.index() < 0 || !counted.add(messageFormatPart.index())) continue;
            ++this.argumentCount;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "formatParts=" + this.formatParts + ", argumentCount=" + this.argumentCount + "]";
    }
}

