/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.logging.log4j;

import org.jboss.logging.LoggerPlugin;
import org.jboss.logging.LoggerPluginInstance;
import org.jboss.logging.MDCProvider;
import org.jboss.logging.NDCProvider;
import org.jboss.logging.NDCSupport;
import org.jboss.logging.MDCSupport;

/**
 *
 */
public class Log4jLoggerPlugin implements LoggerPlugin, NDCSupport, MDCSupport {
   private final MDCProvider mdcProvider;
   private final NDCProvider ndcProvider;

   public Log4jLoggerPlugin() {
      mdcProvider = new Log4jMDCProvider();
      ndcProvider = new Log4jNDCProvider();
   }

   public LoggerPluginInstance getInstance(String name, String resourceBundleName) {
      Log4jLoggerPluginInstance instance = new Log4jLoggerPluginInstance(name, resourceBundleName, this);
      return instance;
   }

   public MDCProvider getMDCProvider() {
      return mdcProvider;
   }

   public NDCProvider getNDCProvider() {
      return ndcProvider;
   }
}
