/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.validation.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.jboss.logging.Annotations;
import org.jboss.logging.generator.ReturnType;
import org.jboss.logging.util.ElementHelper;
import org.jboss.logging.validation.ElementValidator;
import org.jboss.logging.validation.ValidationErrorMessage;
import org.jboss.logging.validation.ValidationMessage;
import org.jboss.logging.validation.ValidationWarningMessage;

abstract class AbstractValidator
implements ElementValidator {
    protected final Annotations annotations;
    private final Types typeUtil;

    protected AbstractValidator(Annotations annotations, Types typeUtil) {
        this.typeUtil = typeUtil;
        this.annotations = annotations;
    }

    public final Collection<ValidationMessage> checkMessageBundleMethod(TypeElement root, ExecutableElement method) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (!this.hasOrInheritsMessage(root, method)) {
            messages.add(ValidationErrorMessage.of(method, "Message bundle methods must be annotated with %s.", this.annotations.message()));
        }
        if (!ElementHelper.isAssignableFrom(method.getReturnType(), String.class) && !ElementHelper.isAssignableFrom(Throwable.class, method.getReturnType())) {
            messages.add(ValidationErrorMessage.of(method, "Message bundle %s has a method with invalid return type, method %s has a return type of %s", root, method, method.getReturnType()));
        } else if (ElementHelper.isAssignableFrom(Throwable.class, method.getReturnType())) {
            messages.addAll(this.checkExceptionConstructor(method));
        }
        return messages;
    }

    public final Collection<ValidationMessage> checkExceptionConstructor(ExecutableElement method) {
        boolean hasValidNonDefault;
        ArrayList<ValidationMessage> result = new ArrayList<ValidationMessage>();
        TypeMirror type = method.getReturnType();
        Element element = this.typeUtil.asElement(type);
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(element.getEnclosedElements());
        ReturnType returnType = ReturnType.of(type, this.typeUtil);
        boolean bl = hasValidNonDefault = returnType.hasStringAndThrowableConstructor() || returnType.hasStringConstructor() || returnType.hasThrowableAndStringConstructor() || returnType.hasThrowableConstructor();
        if (!hasValidNonDefault && returnType.hasDefaultConstructor()) {
            result.add(ValidationWarningMessage.of(method, "Exception %s does not have a constructor to set the message. The message will be ignored.", ((Object)type).toString()));
        } else if (!hasValidNonDefault && !returnType.hasDefaultConstructor()) {
            result.add(ValidationErrorMessage.of(method, "Type %s does not have a constructor that can be used to create the exception.", ((Object)type).toString()));
        }
        if (!(returnType.hasStringAndThrowableConstructor() || returnType.hasStringConstructor() || returnType.hasThrowableAndStringConstructor())) {
            result.add(ValidationWarningMessage.of(method, "Exception %s does not have a constructor to set the message. The message will be ignored.", ((Object)type).toString()));
        }
        return result;
    }

    public final Collection<ExecutableElement> findByName(Collection<ExecutableElement> methods, Name methodName) {
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : methods) {
            if (!((Object)methodName).equals(method.getSimpleName())) continue;
            result.add(method);
        }
        return result;
    }

    public final boolean hasCause(Collection<? extends VariableElement> params) {
        for (VariableElement variableElement : params) {
            if (variableElement.getAnnotation(this.annotations.cause()) == null) continue;
            return true;
        }
        return false;
    }

    public final boolean hasOrInheritsMessage(TypeElement root, ExecutableElement method) {
        Collection<ExecutableElement> allMethods = this.findByName(ElementHelper.getInterfaceMethods(root, this.typeUtil, null), method.getSimpleName());
        for (ExecutableElement m : allMethods) {
            if (!ElementHelper.isAnnotatedWith(m, this.annotations.message())) continue;
            return true;
        }
        return false;
    }
}

