/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TranslationHelper {
    private static final String TRANSLATION_FILE_NAME_EXTENSION = ".properties";

    private TranslationHelper() {
    }

    public static String getTranslationClassNameSuffix(String translationFileName) {
        if (translationFileName == null) {
            throw new NullPointerException("The translationFileName parameter cannot be null");
        }
        Pattern pattern = Pattern.compile("[^_]*((_[^_.]*){1,3}).*");
        Matcher matcher = pattern.matcher(translationFileName);
        boolean found = matcher.find();
        if (!found) {
            throw new NullPointerException("The given filename is not a valid property filename");
        }
        return matcher.group(1);
    }

    public static String getEnclosingTranslationFileName(String translationFileName) {
        if (translationFileName == null) {
            throw new NullPointerException("The translationClassName parameter cannot be null");
        }
        int lastUnderscore = translationFileName.lastIndexOf(95);
        if (translationFileName.indexOf(95) == lastUnderscore) {
            return translationFileName;
        }
        return translationFileName.substring(0, lastUnderscore).concat(TRANSLATION_FILE_NAME_EXTENSION);
    }

    public static String getEnclosingTranslationClassName(String translationClassName) {
        if (translationClassName == null) {
            throw new NullPointerException("The translationClassName parameter cannot be null");
        }
        int lastUnderScore = translationClassName.lastIndexOf("_");
        return lastUnderScore != -1 ? translationClassName.substring(0, lastUnderScore) : translationClassName;
    }
}

