/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public final class TransformationHelper {
    private TransformationHelper() {
    }

    public static String toQualifiedClassName(String packageName, String className) {
        String qualifiedClassName = !packageName.isEmpty() && !packageName.endsWith(".") ? String.format("%s.%s", packageName, className) : packageName.concat(className);
        return qualifiedClassName;
    }

    public static String stackTraceToString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        t.printStackTrace(printWriter);
        printWriter.flush();
        stringWriter.flush();
        printWriter.close();
        try {
            stringWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }
}

