/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.util;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.jboss.logging.Annotations;
import org.jboss.logging.Loggers;
import org.jboss.logging.model.ImplementationType;

public final class ElementHelper {
    private ElementHelper() {
    }

    public static boolean isAnnotatedWith(Element element, Class<? extends Annotation> clazz) {
        if (element == null) {
            throw new NullPointerException("The element parameter is null");
        }
        Annotation annotation = element.getAnnotation(clazz);
        return annotation != null;
    }

    public static String getPrimaryClassName(TypeElement element, Annotations annotations) {
        if (element == null) {
            throw new NullPointerException("The element parameter cannot be null");
        }
        if (!element.getKind().isInterface()) {
            throw new IllegalArgumentException("The element parameter is not an interface");
        }
        String prefix = ElementHelper.getPrimaryClassNamePrefix(element);
        if (element.getAnnotation(annotations.messageBundle()) != null) {
            return prefix + ImplementationType.BUNDLE.toString();
        }
        if (element.getAnnotation(annotations.messageLogger()) != null) {
            return prefix + ImplementationType.LOGGER.toString();
        }
        return prefix;
    }

    public static String getPrimaryClassNamePrefix(TypeElement element) {
        if (element == null) {
            throw new NullPointerException("The element parameter cannot be null");
        }
        if (!element.getKind().isInterface()) {
            throw new IllegalArgumentException("The element parameter is not an interface");
        }
        String translationFileName = element.getSimpleName().toString();
        for (Element enclosingElt = element.getEnclosingElement(); enclosingElt != null && enclosingElt instanceof TypeElement; enclosingElt = enclosingElt.getEnclosingElement()) {
            translationFileName = String.format("%s$%s", enclosingElt.getSimpleName().toString(), translationFileName);
        }
        return translationFileName;
    }

    public static Collection<ExecutableElement> getInterfaceMethods(TypeElement element, Types types, Loggers loggers) {
        if (!element.getKind().isInterface()) {
            throw new IllegalArgumentException("The element parameter is not an interface");
        }
        HashSet<ExecutableElement> methods = new HashSet<ExecutableElement>();
        for (TypeMirror typeMirror : element.getInterfaces()) {
            if (loggers == null || ((Object)typeMirror).toString().equals(loggers.basicLoggerClass().getName())) continue;
            methods.addAll(ElementHelper.getInterfaceMethods((TypeElement)types.asElement(typeMirror), types, loggers));
        }
        methods.addAll(ElementFilter.methodsIn(element.getEnclosedElements()));
        return methods;
    }

    public static Map<String, String> getAllMessageMethods(Collection<ExecutableElement> methods, Annotations annotations) {
        HashMap<String, String> messages = new HashMap<String, String>();
        for (ExecutableElement method : methods) {
            if (!ElementHelper.isAnnotatedWith(method, annotations.message())) continue;
            messages.put(method.getSimpleName().toString(), annotations.messageValue(method));
        }
        return messages;
    }

    public static boolean isAssignableFrom(TypeElement typeElement, Class<?> type) {
        if (type.getName().equals(typeElement.getQualifiedName().toString())) {
            return true;
        }
        for (Class<?> intf : type.getInterfaces()) {
            if (!ElementHelper.isAssignableFrom(typeElement, intf)) continue;
            return true;
        }
        return type.getSuperclass() != null && ElementHelper.isAssignableFrom(typeElement, type.getSuperclass());
    }

    public static boolean isAssignableFrom(TypeMirror typeMirror, Class<?> type) {
        if (typeMirror instanceof DeclaredType) {
            DeclaredType dclType = (DeclaredType)typeMirror;
            TypeElement typeElement = (TypeElement)dclType.asElement();
            return ElementHelper.isAssignableFrom(typeElement, type);
        }
        for (Class<?> intf : type.getInterfaces()) {
            if (!ElementHelper.isAssignableFrom(typeMirror, intf)) continue;
            return true;
        }
        return type.getSuperclass() != null && ElementHelper.isAssignableFrom(typeMirror, type.getSuperclass());
    }

    public static boolean isAssignableFrom(Class<?> type, TypeElement typeElement) {
        if (type.getName().equals(typeElement.getQualifiedName().toString())) {
            return true;
        }
        List<? extends TypeMirror> types = typeElement.getInterfaces();
        for (TypeMirror typeMirror : types) {
            if (!ElementHelper.isAssignableFrom(type, typeMirror)) continue;
            return true;
        }
        return ElementHelper.isAssignableFrom(type, typeElement.getSuperclass());
    }

    public static boolean isAssignableFrom(Class<?> type, TypeMirror typeMirror) {
        if (typeMirror instanceof DeclaredType) {
            DeclaredType dclType = (DeclaredType)typeMirror;
            TypeElement typeElement = (TypeElement)dclType.asElement();
            return ElementHelper.isAssignableFrom(type, typeElement);
        }
        return false;
    }
}

