/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.jboss.logging.AbstractTool;
import org.jboss.logging.Annotations;
import org.jboss.logging.Loggers;
import org.jboss.logging.util.ElementHelper;

@SupportedOptions(value={"generatedTranslationFilesPath"})
public final class TranslationFileGenerator
extends AbstractTool {
    public static final String GENERATED_FILES_PATH_OPTION = "generatedTranslationFilesPath";
    public static final String GENERATED_FILE_EXTENSION = ".i18n_locale_COUNTRY_VARIANT.properties";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private final String generatedFilesPath;

    public TranslationFileGenerator(ProcessingEnvironment processingEnv, Annotations annotations, Loggers loggers) {
        super(processingEnv, annotations, loggers);
        Map<String, String> options = processingEnv.getOptions();
        this.generatedFilesPath = options.get(GENERATED_FILES_PATH_OPTION);
    }

    @Override
    public void processTypeElement(TypeElement annotation, TypeElement element, Collection<ExecutableElement> methods) {
        if (this.generatedFilesPath != null && element.getKind().isInterface()) {
            String packageName = this.elementUtils().getPackageOf(element).getQualifiedName().toString();
            String relativePath = packageName.replaceAll("\\.", FILE_SEPARATOR);
            String fileName = ElementHelper.getPrimaryClassNamePrefix(element) + GENERATED_FILE_EXTENSION;
            Map<String, String> translationMessages = ElementHelper.getAllMessageMethods(methods, this.annotations());
            this.generateSkeletalTranslationFile(relativePath, fileName, translationMessages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void generateSkeletalTranslationFile(String relativePath, String fileName, Map<String, String> translations) {
        block12: {
            if (translations == null) {
                throw new NullPointerException("The translations parameter cannot be null");
            }
            File pathFile = new File(this.generatedFilesPath, relativePath);
            pathFile.mkdirs();
            File file = new File(pathFile, fileName);
            BufferedWriter writer = null;
            writer = new BufferedWriter(new FileWriter(file));
            for (String key : translations.keySet()) {
                String property = translations.get(key);
                writer.write(String.format("# %s", property));
                writer.newLine();
                writer.write(String.format("%s=", key));
                writer.newLine();
            }
            try {
                writer.close();
            }
            catch (IOException e) {
                this.logger().error(e, "Cannot close generated skeletal translation file %s", fileName);
            }
            break block12;
            catch (IOException e) {
                try {
                    this.logger().error(e, "Cannot write generated skeletal translation file %s", fileName);
                }
                catch (Throwable throwable) {
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        this.logger().error(e2, "Cannot close generated skeletal translation file %s", fileName);
                    }
                    throw throwable;
                }
                try {
                    writer.close();
                }
                catch (IOException e3) {
                    this.logger().error(e3, "Cannot close generated skeletal translation file %s", fileName);
                }
            }
        }
    }
}

