/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.jboss.logging.AbstractTool;
import org.jboss.logging.Annotations;
import org.jboss.logging.Loggers;
import org.jboss.logging.model.ClassModel;
import org.jboss.logging.model.ImplementationType;
import org.jboss.logging.model.MessageBundleTranslator;
import org.jboss.logging.model.MessageLoggerTranslator;
import org.jboss.logging.util.ElementHelper;
import org.jboss.logging.util.TransformationHelper;
import org.jboss.logging.util.TranslationHelper;

@SupportedOptions(value={"translationFilesPath"})
public final class TranslationClassGenerator
extends AbstractTool {
    public static final String TRANSLATION_FILES_PATH_OPTION = "translationFilesPath";
    private static final String TRANSLATION_FILE_EXTENSION_PATTERN = ".i18n_[a-z]*(_[A-Z]*){0,2}\\.properties";
    private final String translationFilesPath;

    public TranslationClassGenerator(ProcessingEnvironment processingEnv, Annotations annotations, Loggers loggers) {
        super(processingEnv, annotations, loggers);
        Map<String, String> options = processingEnv.getOptions();
        this.translationFilesPath = options.get(TRANSLATION_FILES_PATH_OPTION);
    }

    @Override
    public void processTypeElement(TypeElement annotation, TypeElement element, Collection<ExecutableElement> methods) {
        String packageName = this.elementUtils().getPackageOf(element).getQualifiedName().toString();
        String interfaceName = element.getSimpleName().toString();
        String primaryClassName = TransformationHelper.toQualifiedClassName(packageName, ElementHelper.getPrimaryClassName(element, this.annotations()));
        String primaryClassNamePrefix = ElementHelper.getPrimaryClassNamePrefix(element);
        Map<String, String> elementTranslations = ElementHelper.getAllMessageMethods(methods, this.annotations());
        try {
            String classTranslationFilesPath;
            if (this.translationFilesPath != null) {
                classTranslationFilesPath = this.translationFilesPath + packageName.replace('.', File.separatorChar);
            } else {
                FileObject fObj = this.filer().getResource(StandardLocation.CLASS_OUTPUT, packageName, interfaceName);
                classTranslationFilesPath = fObj.toUri().getPath().replaceAll(Pattern.quote(interfaceName), "");
            }
            File dir = new File(classTranslationFilesPath);
            File[] files = dir.listFiles(new TranslationFileFilter(primaryClassNamePrefix));
            if (files != null) {
                for (File file : files) {
                    Map<String, String> translations = this.validateTranslationMessages(elementTranslations, file);
                    this.generateSourceFileFor(primaryClassName, classTranslationFilesPath, file.getName(), translations);
                }
            }
        }
        catch (IOException e) {
            this.logger().error(e, "Cannot read %s package files", packageName);
        }
    }

    private Map<String, String> validateTranslationMessages(Map<String, String> elementTranslations, File file) {
        HashMap<String, String> validTranslations = new HashMap<String, String>();
        try {
            Properties translations = new Properties();
            translations.load(new FileInputStream(file));
            for (String key : translations.stringPropertyNames()) {
                if (elementTranslations.containsKey(key)) {
                    String message = translations.getProperty(key);
                    if (!message.trim().isEmpty()) {
                        validTranslations.put(key, translations.getProperty(key));
                        continue;
                    }
                    this.logger().warn("The translation message with key %s is ignored because value is empty or contains only whitespace", key);
                    continue;
                }
                this.logger().warn("The translation message with key %s have no corresponding method.", key);
            }
        }
        catch (IOException e) {
            this.logger().error(e, "Cannot read the %s translation file", file.getName());
        }
        return validTranslations;
    }

    private void generateSourceFileFor(String primaryClassName, String translationFilePath, String translationFileName, Map<String, String> translations) {
        this.logger().note("Generating translation class for %s.", translationFileName);
        String generatedClassName = primaryClassName.concat(TranslationHelper.getTranslationClassNameSuffix(translationFileName));
        String superClassName = TranslationHelper.getEnclosingTranslationClassName(generatedClassName);
        String enclosingTranslationFileName = TranslationHelper.getEnclosingTranslationFileName(translationFileName);
        File enclosingTranslationFile = new File(translationFilePath, enclosingTranslationFileName);
        if (!enclosingTranslationFileName.equals(translationFileName) && !enclosingTranslationFile.exists()) {
            this.generateSourceFileFor(primaryClassName, translationFilePath, enclosingTranslationFileName, Collections.<String, String>emptyMap());
        }
        ClassModel classModel = primaryClassName.endsWith(ImplementationType.BUNDLE.toString()) ? new MessageBundleTranslator(generatedClassName, superClassName, translations) : new MessageLoggerTranslator(generatedClassName, superClassName, translations);
        try {
            classModel.create(this.filer().createSourceFile(classModel.getClassName(), new Element[0]));
        }
        catch (IOException ex) {
            this.logger().error(ex, "Cannot generate %s source file", generatedClassName);
        }
        catch (IllegalStateException ex) {
            this.logger().error(ex, "Cannot generate %s source file", generatedClassName);
        }
    }

    private class TranslationFileFilter
    implements FilenameFilter {
        private final String className;

        public TranslationFileFilter(String className) {
            this.className = className;
        }

        @Override
        public boolean accept(File dir, String name) {
            boolean isGenerated = name.endsWith(".i18n_locale_COUNTRY_VARIANT.properties");
            boolean isTranslationFile = name.matches(Pattern.quote(this.className) + TranslationClassGenerator.TRANSLATION_FILE_EXTENSION_PATTERN);
            return !isGenerated && isTranslationFile;
        }
    }
}

