/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.util.ServiceLoader;
import org.jboss.logging.Annotations;
import org.jboss.logging.Loggers;

public class LoggingTools {
    private static Annotations annotations;
    private static Loggers loggers;
    private static ServiceLoader<Annotations> annotationsLoader;
    private static ServiceLoader<Loggers> loggersLoader;

    private LoggingTools() {
    }

    public static Annotations findAnnotations() {
        if (annotations == null) {
            for (Annotations a : annotationsLoader) {
                if (annotationsLoader.iterator().hasNext()) {
                    annotations = annotationsLoader.iterator().next();
                    continue;
                }
                throw new IllegalStateException("Annotations not found.");
            }
        }
        return annotations;
    }

    public static Loggers findLoggers() {
        if (loggers == null) {
            if (loggersLoader.iterator().hasNext()) {
                loggers = loggersLoader.iterator().next();
            } else {
                throw new IllegalStateException("Loggers not found.");
            }
        }
        return loggers;
    }

    static {
        annotationsLoader = ServiceLoader.load(Annotations.class, LoggingTools.class.getClassLoader());
        loggersLoader = ServiceLoader.load(Loggers.class, LoggingTools.class.getClassLoader());
    }
}

