/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat, Inc. and/or its affiliates,
 * and individual contributors as indicated by the @author tags.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2010,
 * @author JBoss, by Red Hat.
 */
package com.arjuna.ats.txoj.logging;

import com.arjuna.ats.arjuna.common.Uid;
import org.jboss.logging.Logger;

import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * i18n log messages for the txoj module.
 * This class is autogenerated. Don't mess with it.
 *
 * @author Jonathan Halliday (jonathan.halliday@redhat.com) 2010-06
 */
public class txojI18NLoggerImpl implements txojI18NLogger {

	private final Logger logger;

	txojI18NLoggerImpl(Logger logger) {
		this.logger = logger;
	}

	public void warn_lmf1(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-15001 LockManagerFriend.getLink", (Object)null);
	}

	public void warn_lmf2(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-15002 LockManagerFriend.setLink", (Object)null);
	}

	public void warn_recovery_RecoveredTransactionalObject_10(Uid arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-15004 Object store exception on committing {0}", arg0);
	}

	public void warn_recovery_RecoveredTransactionalObject_6(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-15009 RecoveredTransactionalObject tried to access object store", (Object)null);
	}

	public void warn_recovery_RecoveredTransactionalObject_8(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-15011 RecoveredTransactionalObject::findHoldingTransaction - exception", (Object)null);
	}

	public void warn_recovery_RecoveredTransactionalObject_9(Uid arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-15012 Object store exception on removing uncommitted state: {0}", arg0);
	}

	public void info_recovery_TORecoveryModule_3() {
		logger.logv(INFO, "ARJUNA-15015 TORecoveryModule - first pass", (Object)null);
	}

	public void warn_recovery_TORecoveryModule_5(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-15017 TORecoveryModule: searching for TOs:", (Object)null);
	}

	public void info_recovery_TORecoveryModule_6() {
		logger.logv(INFO, "ARJUNA-15018 TORecoveryModule - second pass", (Object)null);
	}

	public String get_recovery_TORecoveryModule_osproblem() {
		return "ARJUNA-15021 TORecoveryModule - could not create ObjectStore instance!";
	}

	public String get_CadaverLockRecord_1() {
		return "ARJUNA-15022 CadaverLockRecord::nestedAbort - no Current!";
	}

	public String get_CadaverLockRecord_2() {
		return "ARJUNA-15023 CadaverLockRecord::nestedCommit - no Current!";
	}

	public String get_CadaverLockRecord_3() {
		return "ARJUNA-15024 CadaverLockRecord::topLevelAbort - no Current!";
	}

	public String get_CadaverLockRecord_4() {
		return "ARJUNA-15025 CadaverLockRecord::topLevelCommit - no Current!";
	}

	public void warn_LockManager_1() {
		logger.logv(WARN, "ARJUNA-15026 LockManager: lock propagation failed", (Object)null);
	}

	public void warn_LockManager_10(Uid arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-15027 LockManager::unloadState() failed to remove empty lock state for object {0} of type {1}", arg0, arg1);
	}

	public void warn_LockManager_11(String arg0) {
		logger.logv(WARN, "ARJUNA-15028 LockManager.unloadState - could not save lock state: {0}", arg0);
	}

	public void warn_LockManager_12(Uid arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-15029 LockManager::unloadState() failed to write new state for object {0} of type {1}", arg0, arg1);
	}

	public void warn_LockManager_13(Uid arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-15030 LockManager::unloadState() failed to pack up new state for object {0} of type {1}", arg0, arg1);
	}

	public void warn_LockManager_2() {
		logger.logv(WARN, "ARJUNA-15031 LockManager::setlock() no lock!", (Object)null);
	}

	public void warn_LockManager_3() {
		logger.logv(WARN, "ARJUNA-15032 LockManager::setlock() cannot find action hierarchy", (Object)null);
	}

	public void warn_LockManager_4() {
		logger.logv(WARN, "ARJUNA-15033 LockManager::setlock() cannot load existing lock states", (Object)null);
	}

	public void warn_LockManager_5() {
		logger.logv(WARN, "ARJUNA-15034 LockManager::setlock() cannot activate object", (Object)null);
	}

	public void warn_LockManager_6() {
		logger.logv(WARN, "ARJUNA-15035 LockManager::setlock() cannot save new lock states", (Object)null);
	}

	public void warn_LockManager_7() {
		logger.logv(WARN, "ARJUNA-15036 Lockmanager::releaselock() could not load old lock states", (Object)null);
	}

	public void warn_LockManager_8() {
		logger.logv(WARN, "ARJUNA-15037 Lockmanager::releaselock() could not unload new lock states", (Object)null);
	}

	public void warn_LockRecord_1() {
		logger.logv(WARN, "ARJUNA-15038 LockRecord::set_value() called illegally", (Object)null);
	}

	public void warn_LockRecord_2(Uid arg0) {
		logger.logv(WARN, "ARJUNA-15039 LockRecord - release failed for action {0}", arg0);
	}

	public void warn_LockRecord_3() {
		logger.logv(WARN, "ARJUNA-15040 LockRecord::nestedAbort - no current action", (Object)null);
	}

	public void warn_LockRecord_4() {
		logger.logv(WARN, "ARJUNA-15041 LockRecord::nestedCommit - no current action", (Object)null);
	}

	public void warn_LockRecord_5(Uid arg0) {
		logger.logv(WARN, "ARJUNA-15042 LockRecord - release failed for action {0}", arg0);
	}

	public void warn_LockRecord_6() {
		logger.logv(WARN, "ARJUNA-15043 LockRecord::topLevelCommit - no current action", (Object)null);
	}

	public void warn_LockRecord_7(String arg0, Uid arg1) {
		logger.logv(WARN, "ARJUNA-15044 Invocation of LockRecord::restore_state for {0} inappropriate - ignored for {1}", arg0, arg1);
	}
}
