/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.recovery.arjunacore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.jta.Implementations;
import com.arjuna.ats.internal.jta.recovery.arjunacore.RecoveryXids;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryResourceManagerImple;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.recovery.XARecoveryResource;
import com.arjuna.ats.jta.recovery.XARecoveryResourceManager;
import com.arjuna.ats.jta.recovery.XAResourceOrphanFilter;
import com.arjuna.ats.jta.recovery.XAResourceRecovery;
import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import com.arjuna.ats.jta.utils.XAHelper;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XARecoveryModule
implements RecoveryModule {
    private ObjectStore _objStore = TxControl.getStore();
    private InputObjectState _uids = new InputObjectState();
    private final List<XAResourceRecovery> _xaRecoverers;
    private final List<XAResourceRecoveryHelper> _xaResourceRecoveryHelpers = new LinkedList<XAResourceRecoveryHelper>();
    private final List<XAResourceOrphanFilter> _xaResourceOrphanFilters;
    private Hashtable _failures = null;
    private Hashtable _xidScans = null;
    private XARecoveryResourceManager _recoveryManagerClass = null;
    private String _logName = null;

    public XARecoveryModule() {
        this(XARecoveryResourceManagerImple.class.getName(), "Local XARecoveryModule");
        Implementations.initialise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addXAResourceRecoveryHelper(XAResourceRecoveryHelper xaResourceRecoveryHelper) {
        List<XAResourceRecoveryHelper> list2 = this._xaResourceRecoveryHelpers;
        synchronized (list2) {
            if (!this._xaResourceRecoveryHelpers.contains(xaResourceRecoveryHelper)) {
                this._xaResourceRecoveryHelpers.add(xaResourceRecoveryHelper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeXAResourceRecoveryHelper(XAResourceRecoveryHelper xaResourceRecoveryHelper) {
        List<XAResourceRecoveryHelper> list2 = this._xaResourceRecoveryHelpers;
        synchronized (list2) {
            this._xaResourceRecoveryHelpers.remove(xaResourceRecoveryHelper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addXAResourceOrphanFilter(XAResourceOrphanFilter xaResourceOrphanFilter) {
        List<XAResourceOrphanFilter> list2 = this._xaResourceOrphanFilters;
        synchronized (list2) {
            if (!this._xaResourceOrphanFilters.contains(xaResourceOrphanFilter)) {
                this._xaResourceOrphanFilters.add(xaResourceOrphanFilter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeXAResourceOrphanFilter(XAResourceOrphanFilter xaResourceOrphanFilter) {
        List<XAResourceOrphanFilter> list2 = this._xaResourceOrphanFilters;
        synchronized (list2) {
            this._xaResourceOrphanFilters.remove(xaResourceOrphanFilter);
        }
    }

    @Override
    public void periodicWorkFirstPass() {
        block6: {
            if (jtaLogger.loggerI18N.isInfoEnabled()) {
                jtaLogger.loggerI18N.info("com.arjuna.ats.internal.jta.recovery.info.firstpass", new Object[]{this._logName});
            }
            this._uids = new InputObjectState();
            try {
                if (!this._objStore.allObjUids(this._recoveryManagerClass.type(), this._uids) && jtaLogger.loggerI18N.isWarnEnabled()) {
                    jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.alluids");
                }
            }
            catch (ObjectStoreException e) {
                if (jtaLogger.loggerI18N.isWarnEnabled()) {
                    jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.objstoreerror", e);
                }
            }
            catch (Exception e) {
                if (!jtaLogger.loggerI18N.isWarnEnabled()) break block6;
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.periodicfirstpass", new Object[]{this._logName + ".periodicWorkFirstPass exception "}, e);
            }
        }
    }

    @Override
    public void periodicWorkSecondPass() {
        block5: {
            if (jtaLogger.logger.isInfoEnabled() && jtaLogger.loggerI18N.isInfoEnabled()) {
                jtaLogger.loggerI18N.info("com.arjuna.ats.internal.jta.recovery.info.secondpass", new Object[]{this._logName});
            }
            try {
                this.transactionInitiatedRecovery();
                if (jtaLogger.logger.isDebugEnabled()) {
                    jtaLogger.logger.debug(this._logName + ".transactionInitiatedRecovery completed");
                }
                this.resourceInitiatedRecovery();
                this.resourceInitiatedRecoveryForRecoveryHelpers();
                if (jtaLogger.logger.isDebugEnabled()) {
                    jtaLogger.logger.debug(this._logName + ".resourceInitiatedRecovery completed");
                }
            }
            catch (Exception e) {
                if (!jtaLogger.loggerI18N.isWarnEnabled()) break block5;
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.periodicsecondpass", new Object[]{this._logName + ".periodicWorkSecondPass exception "}, e);
            }
        }
        this.clearAllFailures();
    }

    public String id() {
        return "XARecoveryModule:" + this._recoveryManagerClass;
    }

    public XAResource getNewXAResource(Xid xid) {
        if (this._xidScans == null) {
            this.resourceInitiatedRecovery();
            this.resourceInitiatedRecoveryForRecoveryHelpers();
        }
        if (this._xidScans != null) {
            Enumeration keys = this._xidScans.keys();
            while (keys.hasMoreElements()) {
                XAResource theKey = (XAResource)keys.nextElement();
                RecoveryXids xids = (RecoveryXids)this._xidScans.get(theKey);
                if (!xids.contains(xid)) continue;
                return theKey;
            }
        }
        return null;
    }

    protected XARecoveryModule(String recoveryClass, String logName) {
        this._logName = logName;
        try {
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(recoveryClass);
            this._recoveryManagerClass = (XARecoveryResourceManager)c.newInstance();
        }
        catch (Exception ex) {
            if (jtaLogger.loggerI18N.isWarnEnabled()) {
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.constfail", ex);
            }
            this._recoveryManagerClass = null;
        }
        this._xaRecoverers = jtaPropertyManager.getJTAEnvironmentBean().getXaResourceRecoveries();
        this._xaResourceOrphanFilters = jtaPropertyManager.getJTAEnvironmentBean().getXaResourceOrphanFilters();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean transactionInitiatedRecovery() {
        Uid theUid = null;
        while (Uid.nullUid().notEquals(theUid)) {
            try {
                XARecoveryResource record;
                boolean problem;
                block16: {
                    theUid = UidHelper.unpackFrom(this._uids);
                    if (!theUid.notEquals(Uid.nullUid()) || this._objStore.currentState(theUid, this._recoveryManagerClass.type()) == -1) continue;
                    problem = false;
                    record = null;
                    try {
                        record = this._recoveryManagerClass.getResource(theUid);
                        problem = true;
                        switch (record.recoverable()) {
                            case 12: {
                                int recoveryStatus;
                                if (jtaLogger.logger.isDebugEnabled()) {
                                    jtaLogger.logger.debug("XARecovery attempting recovery of " + theUid);
                                }
                                if ((recoveryStatus = record.recover()) != 1) {
                                    if (recoveryStatus == 3) {
                                        problem = false;
                                        if (!jtaLogger.loggerI18N.isInfoEnabled()) break;
                                        jtaLogger.loggerI18N.info("com.arjuna.ats.internal.jta.recovery.recoverydelayed", new Object[]{theUid, new Integer(recoveryStatus)});
                                        break;
                                    }
                                    if (!jtaLogger.loggerI18N.isWarnEnabled()) break;
                                    jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.recoveryfailed", new Object[]{theUid, new Integer(recoveryStatus)});
                                    break;
                                }
                                problem = false;
                                break;
                            }
                            case 11: {
                                problem = false;
                                break;
                            }
                            default: {
                                if (!jtaLogger.logger.isDebugEnabled()) break;
                                jtaLogger.logger.debug("XARecovery " + theUid + " is non-recoverable");
                                break;
                            }
                        }
                    }
                    catch (NullPointerException ex) {
                        problem = true;
                    }
                    catch (Throwable e) {
                        problem = true;
                        if (!jtaLogger.loggerI18N.isWarnEnabled()) break block16;
                        jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.recoveryerror", e);
                    }
                }
                if (!problem || record == null) continue;
                if (record.getXid() == null) {
                    if (!jtaLogger.loggerI18N.isWarnEnabled()) continue;
                    jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.cannotadd");
                    continue;
                }
                this.addFailure(record.getXid(), record.get_uid());
            }
            catch (IOException e) {
                theUid = Uid.nullUid();
            }
            catch (Throwable e) {
                if (!jtaLogger.loggerI18N.isWarnEnabled()) continue;
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.unexpectedrecoveryerror", e);
                continue;
            }
            break;
        }
        return true;
    }

    private final boolean resourceInitiatedRecovery() {
        if (this._xaRecoverers.size() > 0) {
            for (int i = 0; i < this._xaRecoverers.size(); ++i) {
                XAResource resource = null;
                try {
                    XAResourceRecovery ri = this._xaRecoverers.get(i);
                    while (ri.hasMoreResources()) {
                        try {
                            resource = ri.getXAResource();
                            this.xaRecovery(resource);
                        }
                        catch (Exception exp) {
                            if (!jtaLogger.loggerI18N.isWarnEnabled()) continue;
                            jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.getxaresource", exp);
                        }
                    }
                    continue;
                }
                catch (Exception ex) {
                    if (!jtaLogger.loggerI18N.isWarnEnabled()) continue;
                    jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.getxaresource", ex);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean resourceInitiatedRecoveryForRecoveryHelpers() {
        List<XAResourceRecoveryHelper> list2 = this._xaResourceRecoveryHelpers;
        synchronized (list2) {
            for (XAResourceRecoveryHelper xaResourceRecoveryHelper : this._xaResourceRecoveryHelpers) {
                try {
                    XAResource[] xaResources = xaResourceRecoveryHelper.getXAResources();
                    if (xaResources == null) continue;
                    for (XAResource xaResource : xaResources) {
                        try {
                            this.xaRecovery(xaResource);
                        }
                        catch (Exception ex) {
                            if (!jtaLogger.loggerI18N.isWarnEnabled()) continue;
                            jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.getxaresource", ex);
                        }
                    }
                }
                catch (Exception ex) {
                    if (!jtaLogger.loggerI18N.isWarnEnabled()) continue;
                    jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.getxaresource", ex);
                }
            }
        }
        return true;
    }

    private final boolean xaRecovery(XAResource xares) {
        block29: {
            block27: {
                if (jtaLogger.logger.isDebugEnabled()) {
                    jtaLogger.logger.debug("xarecovery of " + xares);
                }
                try {
                    Xid[] trans = null;
                    try {
                        trans = xares.recover(0x1000000);
                        if (jtaLogger.logger.isDebugEnabled()) {
                            jtaLogger.logger.debug("Found " + (trans != null ? trans.length : 0) + " xids in doubt");
                        }
                    }
                    catch (XAException e) {
                        if (jtaLogger.loggerI18N.isWarnEnabled()) {
                            jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.xarecovery1", new Object[]{this._logName + ".xaRecovery ", e, XAHelper.printXAErrorCode(e)});
                        }
                        try {
                            xares.recover(0x800000);
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                        return false;
                    }
                    RecoveryXids xidsToRecover = null;
                    if (this._xidScans == null) {
                        this._xidScans = new Hashtable();
                    } else {
                        this.refreshXidScansForEquivalentXAResourceImpl(xares, trans);
                        xidsToRecover = (RecoveryXids)this._xidScans.get(xares);
                        if (xidsToRecover == null) {
                            Enumeration elements = this._xidScans.elements();
                            boolean found = false;
                            while (elements.hasMoreElements()) {
                                xidsToRecover = (RecoveryXids)elements.nextElement();
                                if (!xidsToRecover.isSameRM(xares)) continue;
                                found = true;
                                break;
                            }
                            if (!found) {
                                xidsToRecover = null;
                            }
                        }
                    }
                    if (xidsToRecover == null) {
                        xidsToRecover = new RecoveryXids(xares);
                        this._xidScans.put(xares, xidsToRecover);
                    }
                    xidsToRecover.nextScan(trans);
                    Xid[] xids = xidsToRecover.toRecover();
                    if (xids == null) break block27;
                    if (jtaLogger.logger.isDebugEnabled()) {
                        jtaLogger.logger.debug("Have " + xids.length + " Xids to recover on this pass.");
                    }
                    for (int j = 0; j < xids.length; ++j) {
                        boolean doForget = false;
                        Uid recordUid = null;
                        boolean foundTransaction = false;
                        while ((recordUid = this.previousFailure(xids[j])) != null || !foundTransaction) {
                            block28: {
                                if (recordUid == null) {
                                    doForget = this.handleOrphan(xares, xids[j]);
                                } else {
                                    foundTransaction = true;
                                    XARecoveryResource record = this._recoveryManagerClass.getResource(recordUid, xares);
                                    int recoveryStatus = record.recover();
                                    if (recoveryStatus != 1 && jtaLogger.loggerI18N.isWarnEnabled()) {
                                        jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.failedtorecover", new Object[]{this._logName + ".xaRecovery ", new Integer(recoveryStatus)});
                                    }
                                    this.removeFailure(record.getXid(), record.get_uid());
                                }
                                if (doForget) {
                                    try {
                                        xares.forget(xids[j]);
                                    }
                                    catch (Exception e) {
                                        if (!jtaLogger.loggerI18N.isWarnEnabled()) break block28;
                                        jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.forgetfailed", new Object[]{this._logName + ".xaRecovery", e});
                                    }
                                }
                            }
                            if (recordUid != null) continue;
                        }
                    }
                }
                catch (Exception e) {
                    if (!jtaLogger.loggerI18N.isWarnEnabled()) break block27;
                    jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.generalrecoveryerror", new Object[]{this._logName + ".xaRecovery", e}, e);
                }
            }
            try {
                if (xares != null) {
                    xares.recover(0x800000);
                }
            }
            catch (XAException e) {
                if (!jtaLogger.loggerI18N.isWarnEnabled()) break block29;
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.xarecovery1", new Object[]{this._logName + ".xaRecovery", e, XAHelper.printXAErrorCode(e)});
            }
        }
        return true;
    }

    private boolean handleOrphan(XAResource xares, Xid xid) {
        block12: {
            XAResourceOrphanFilter.Vote votingOutcome = XAResourceOrphanFilter.Vote.LEAVE_ALONE;
            for (XAResourceOrphanFilter filter : this._xaResourceOrphanFilters) {
                XAResourceOrphanFilter.Vote vote = filter.checkXid(xid);
                if (jtaLogger.logger.isDebugEnabled()) {
                    jtaLogger.logger.debug("XAResourceOrphanFilter " + filter.getClass().getName() + " voted " + (Object)((Object)vote));
                }
                if (vote == XAResourceOrphanFilter.Vote.LEAVE_ALONE) {
                    return false;
                }
                if (vote != XAResourceOrphanFilter.Vote.ROLLBACK) continue;
                votingOutcome = vote;
            }
            try {
                if (votingOutcome == XAResourceOrphanFilter.Vote.ROLLBACK) {
                    if (jtaLogger.loggerI18N.isInfoEnabled()) {
                        jtaLogger.loggerI18N.info("com.arjuna.ats.internal.jta.recovery.info.rollingback", new Object[]{XAHelper.xidToString(xid)});
                    }
                    xares.rollback(xid);
                }
            }
            catch (XAException e1) {
                e1.printStackTrace();
                switch (e1.errorCode) {
                    case -3: {
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 100: {
                        return true;
                    }
                }
            }
            catch (Exception e2) {
                if (!jtaLogger.loggerI18N.isWarnEnabled()) break block12;
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.xarecovery2", new Object[]{this._logName + ".xaRecovery ", e2});
            }
        }
        return false;
    }

    private void refreshXidScansForEquivalentXAResourceImpl(XAResource xares, Xid[] xids) {
        if (xids == null || xids.length == 0) {
            return;
        }
        Enumeration keys = this._xidScans.keys();
        while (keys.hasMoreElements()) {
            XAResource theKey = (XAResource)keys.nextElement();
            RecoveryXids recoveryXids = (RecoveryXids)this._xidScans.get(theKey);
            if (!recoveryXids.updateIfEquivalentRM(xares, xids)) continue;
            this._xidScans.remove(theKey);
            theKey = xares;
            this._xidScans.put(theKey, recoveryXids);
            break;
        }
    }

    private final Uid previousFailure(Xid xid) {
        if (this._failures == null) {
            return null;
        }
        Enumeration e = this._failures.keys();
        while (e.hasMoreElements()) {
            Xid theXid = (Xid)e.nextElement();
            if (!XAHelper.sameXID(xid, theXid)) continue;
            Vector failureItem = (Vector)this._failures.get(theXid);
            Uid u = (Uid)failureItem.remove(0);
            if (failureItem.size() == 0) {
                this._failures.remove(theXid);
            }
            return u;
        }
        return null;
    }

    private void addFailure(Xid xid, Uid uid) {
        Vector<Uid> failureItem;
        if (this._failures == null) {
            this._failures = new Hashtable();
        }
        if ((failureItem = (Vector<Uid>)this._failures.get(xid)) == null) {
            failureItem = new Vector<Uid>();
            this._failures.put(xid, failureItem);
        }
        failureItem.addElement(uid);
    }

    private void removeFailure(Xid xid, Uid uid) {
        Vector failureItem = (Vector)this._failures.get(xid);
        if (failureItem != null) {
            failureItem.remove(uid);
            if (failureItem.size() == 0) {
                this._failures.remove(xid);
            }
        }
    }

    private void clearAllFailures() {
        if (this._failures != null) {
            this._failures.clear();
        }
    }
}

