/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.deployment;

import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jboss.as.plugin.deployment.AbstractAppDeployment;
import org.jboss.as.plugin.deployment.Deployment;
import org.jboss.as.plugin.deployment.MatchPatternStrategy;

@Mojo(name="undeploy", threadSafe=true)
public class Undeploy
extends AbstractAppDeployment {
    @Parameter(alias="match-pattern")
    protected String matchPattern;
    @Parameter(alias="match-pattern-strategy")
    protected String matchPatternStrategy = MatchPatternStrategy.FAIL.toString();
    @Parameter(defaultValue="true", property="undeploy.ignoreMissingDeployment")
    private boolean ignoreMissingDeployment;

    @Override
    protected String getMatchPattern() {
        return this.matchPattern;
    }

    @Override
    protected MatchPatternStrategy getMatchPatternStrategy() {
        if (MatchPatternStrategy.FAIL.toString().equalsIgnoreCase(this.matchPatternStrategy)) {
            return MatchPatternStrategy.FAIL;
        }
        if (MatchPatternStrategy.FIRST.toString().equalsIgnoreCase(this.matchPatternStrategy)) {
            return MatchPatternStrategy.FIRST;
        }
        if (MatchPatternStrategy.ALL.toString().equalsIgnoreCase(this.matchPatternStrategy)) {
            return MatchPatternStrategy.ALL;
        }
        throw new IllegalStateException(String.format("matchPatternStrategy '%s' is not a valid strategy. Valid strategies are %s, %s and %s", new Object[]{this.matchPatternStrategy, MatchPatternStrategy.ALL, MatchPatternStrategy.FAIL, MatchPatternStrategy.FIRST}));
    }

    @Override
    public String goal() {
        return "undeploy";
    }

    @Override
    public Deployment.Type getType() {
        return this.ignoreMissingDeployment ? Deployment.Type.UNDEPLOY_IGNORE_MISSING : Deployment.Type.UNDEPLOY;
    }
}

