/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.deployment.common;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;

class ClientCallbackHandler
implements CallbackHandler {
    private boolean promptShown = false;
    private String username;
    private char[] password;

    ClientCallbackHandler(String username, String password) {
        this.username = username;
        if (password != null) {
            this.password = password.toCharArray();
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks.length == 1 && callbacks[0] instanceof NameCallback) {
            ((NameCallback)callbacks[0]).setName("anonymous demo user");
            return;
        }
        for (Callback current : callbacks) {
            if (current instanceof RealmCallback) {
                RealmCallback rcb = (RealmCallback)current;
                String defaultText = rcb.getDefaultText();
                rcb.setText(defaultText);
                this.prompt(defaultText);
                continue;
            }
            if (current instanceof RealmChoiceCallback) {
                throw new UnsupportedCallbackException(current, "Realm choice not currently supported.");
            }
            if (current instanceof NameCallback) {
                NameCallback ncb = (NameCallback)current;
                String userName = this.obtainUsername("Username:");
                ncb.setName(userName);
                continue;
            }
            if (current instanceof PasswordCallback) {
                PasswordCallback pcb = (PasswordCallback)current;
                char[] password = this.obtainPassword("Password:");
                pcb.setPassword(password);
                continue;
            }
            throw new UnsupportedCallbackException(current);
        }
    }

    private void prompt(String realm) {
        if (!this.promptShown) {
            this.promptShown = true;
            System.out.println("Authenticating against security realm: " + realm);
        }
    }

    private String obtainUsername(String prompt) {
        if (this.username == null) {
            this.username = System.console().readLine(prompt, new Object[0]);
        }
        return this.username;
    }

    private char[] obtainPassword(String prompt) {
        if (this.password == null) {
            this.password = System.console().readPassword(prompt, new Object[0]);
        }
        return this.password;
    }
}

