/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.deployment;

import java.io.IOException;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlanBuilder;
import org.jboss.as.plugin.deployment.AbstractDeployment;

class Util {
    private Util() {
    }

    static DeploymentPlan deployPlan(AbstractDeployment deployment, DeploymentPlanBuilder builder) throws IOException {
        DeploymentPlan plan = null;
        if (deployment.name() == null) {
            deployment.getLog().debug((CharSequence)deployment.nameNotDefinedMessage());
            plan = builder.add(deployment.file()).deploy(deployment.file().getName()).build();
        } else {
            deployment.getLog().debug((CharSequence)deployment.nameDefinedMessage());
            plan = builder.add(deployment.name(), deployment.file()).deploy(deployment.name()).build();
        }
        return plan;
    }

    static DeploymentPlan redeployPlan(AbstractDeployment deployment, DeploymentPlanBuilder builder) throws IOException {
        DeploymentPlan plan = null;
        if (deployment.name() == null) {
            deployment.getLog().debug((CharSequence)deployment.nameNotDefinedMessage());
            plan = builder.replace(deployment.file()).redeploy(deployment.file().getName()).build();
        } else {
            deployment.getLog().debug((CharSequence)deployment.nameDefinedMessage());
            plan = builder.replace(deployment.name(), deployment.file()).redeploy(deployment.name()).build();
        }
        return plan;
    }

    static DeploymentPlan undeployPlan(AbstractDeployment deployment, DeploymentPlanBuilder builder) throws IOException {
        DeploymentPlan plan = null;
        if (deployment.name() == null) {
            deployment.getLog().debug((CharSequence)deployment.nameNotDefinedMessage());
            plan = builder.undeploy(deployment.file().getName()).remove(deployment.file().getName()).build();
        } else {
            deployment.getLog().debug((CharSequence)deployment.nameNotDefinedMessage());
            plan = builder.undeploy(deployment.name()).remove(deployment.name()).build();
        }
        return plan;
    }
}

