/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class SSLIdentityService
implements Service<SSLIdentityService> {
    public static final String SERVICE_SUFFIX = "ssl";
    private final ModelNode ssl;
    private final String unmaskedPassword;
    private final InjectedValue<String> relativeTo = new InjectedValue();
    private volatile SSLContext sslContext;

    public SSLIdentityService(ModelNode ssl, String unmaskedPassword) {
        this.ssl = ssl;
        this.unmaskedPassword = unmaskedPassword;
    }

    public void start(StartContext context) throws StartException {
        try {
            KeyManager[] keyManagers = null;
            String protocol = "TLS";
            if (this.ssl.has("protocol")) {
                protocol = this.ssl.get("protocol").asString();
            }
            if (this.ssl.has("keystore")) {
                ModelNode keystoreNode = this.ssl.get("keystore");
                String relativeTo = (String)this.relativeTo.getOptionalValue();
                String path = keystoreNode.require("path").asString();
                String file = relativeTo == null ? path : relativeTo + "/" + path;
                char[] password = keystoreNode.require("password").asString().toCharArray();
                KeyStore keystore = KeyStore.getInstance("JKS");
                FileInputStream fis = new FileInputStream(file);
                keystore.load(fis, password);
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                keyManagerFactory.init(keystore, password);
                keyManagers = keyManagerFactory.getKeyManagers();
            }
            SSLContext sslContext = SSLContext.getInstance(protocol);
            sslContext.init(keyManagers, null, null);
            this.sslContext = sslContext;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw DomainManagementMessages.MESSAGES.unableToStart(nsae);
        }
        catch (KeyManagementException kme) {
            throw DomainManagementMessages.MESSAGES.unableToStart(kme);
        }
        catch (KeyStoreException kse) {
            throw DomainManagementMessages.MESSAGES.unableToStart(kse);
        }
        catch (FileNotFoundException fnfe) {
            throw DomainManagementMessages.MESSAGES.unableToStart(fnfe);
        }
        catch (CertificateException e) {
            throw DomainManagementMessages.MESSAGES.unableToStart(e);
        }
        catch (IOException e) {
            throw DomainManagementMessages.MESSAGES.unableToStart(e);
        }
        catch (UnrecoverableKeyException e) {
            throw DomainManagementMessages.MESSAGES.unableToStart(e);
        }
    }

    public void stop(StopContext context) {
    }

    public SSLIdentityService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<String> getRelativeToInjector() {
        return this.relativeTo;
    }

    SSLContext getSSLContext() {
        return this.sslContext;
    }
}

