/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ResourceBundle;
import org.apache.cxf.resource.ResourceResolver;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;

public class JBossWSResourceResolver
implements ResourceResolver {
    private static final ResourceBundle bundle = BundleUtils.getBundle(JBossWSResourceResolver.class);
    private static Logger log = Logger.getLogger(JBossWSResourceResolver.class);
    private org.jboss.wsf.spi.deployment.ResourceResolver resolver;

    public JBossWSResourceResolver(org.jboss.wsf.spi.deployment.ResourceResolver resolver) {
        this.resolver = resolver;
    }

    public InputStream getAsStream(String resourcePath) {
        URL url = this.resolve(resourcePath, URL.class);
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException ioe) {
                log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OPEN_STREAM_FOR_RESOURCE", (Object[])new Object[]{resourcePath}));
            }
        }
        return null;
    }

    public <T> T resolve(String resourcePath, Class<T> resourceType) {
        URL url;
        block3: {
            url = null;
            try {
                url = this.resolver.resolve(resourcePath);
            }
            catch (IOException ioe) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_RESOLVE_RESOURCE", (Object[])new Object[]{resourcePath}));
            }
        }
        if (url != null && resourceType.isInstance(url)) {
            return resourceType.cast(url);
        }
        return null;
    }
}

