/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Locale;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.AddressSettingAdd;
import org.jboss.as.messaging.BridgeAdd;
import org.jboss.as.messaging.BroadcastGroupAdd;
import org.jboss.as.messaging.ClusterConnectionAdd;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.ConnectorServiceAdd;
import org.jboss.as.messaging.ConnectorServiceParamAdd;
import org.jboss.as.messaging.DiscoveryGroupAdd;
import org.jboss.as.messaging.DivertAdd;
import org.jboss.as.messaging.GroupingHandlerAdd;
import org.jboss.as.messaging.MessagingPathHandlers;
import org.jboss.as.messaging.QueueAdd;
import org.jboss.as.messaging.SecurityRoleAdd;
import org.jboss.as.messaging.SecuritySettingAdd;
import org.jboss.as.messaging.TransportConfigOperationHandlers;
import org.jboss.as.messaging.jms.ConnectionFactoryAdd;
import org.jboss.as.messaging.jms.JMSQueueAdd;
import org.jboss.as.messaging.jms.JMSTopicAdd;
import org.jboss.as.messaging.jms.PooledConnectionFactoryAdd;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

class MessagingSubsystemDescribeHandler
implements OperationStepHandler,
DescriptionProvider {
    static final String[] TRANSPORT = new String[]{"acceptor", "remote-acceptor", "in-vm-acceptor", "connector", "remote-connector", "in-vm-connector"};
    static final MessagingSubsystemDescribeHandler INSTANCE = new MessagingSubsystemDescribeHandler();

    MessagingSubsystemDescribeHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ModelNode subModel = Resource.Tools.readModel((Resource)resource);
        ModelNode subsystemAdd = new ModelNode();
        PathAddress rootAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement()});
        subsystemAdd.get("operation").set("add");
        subsystemAdd.get("address").set(rootAddress.toModelNode());
        ModelNode result = context.getResult();
        result.add(subsystemAdd);
        if (subModel.hasDefined("hornetq-server")) {
            for (Property prop : subModel.get("hornetq-server").asPropertyList()) {
                ModelNode serverAdd = new ModelNode();
                serverAdd.get("operation").set("add");
                PathAddress serverAddress = rootAddress.append(new PathElement[]{PathElement.pathElement((String)"hornetq-server", (String)prop.getName())});
                serverAdd.get("address").set(serverAddress.toModelNode());
                this.addHornetQServer(prop.getValue(), serverAdd, serverAddress, result);
            }
        }
        context.completeStep();
    }

    /*
     * WARNING - void declaration
     */
    private void addHornetQServer(ModelNode subModel, ModelNode serverAdd, PathAddress rootAddress, ModelNode result) {
        for (AttributeDefinition attributeDefinition : CommonAttributes.SIMPLE_ROOT_RESOURCE_ATTRIBUTES) {
            String attrName = attributeDefinition.getName();
            if (!subModel.hasDefined(attrName)) continue;
            serverAdd.get(attrName).set(subModel.get(attrName));
        }
        result.add(serverAdd);
        for (String string : TRANSPORT) {
            if (!subModel.hasDefined(string)) continue;
            for (Property property : subModel.get(string).asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add(string, property.getName());
                result.add(TransportConfigOperationHandlers.createAddOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("path")) {
            void var8_70;
            ModelNode modelNode = subModel.get("path");
            String[] arr$ = CommonAttributes.PATHS;
            int len$ = arr$.length;
            boolean bl = false;
            while (var8_70 < len$) {
                String pathName = arr$[var8_70];
                if (modelNode.hasDefined(pathName)) {
                    ModelNode address = rootAddress.toModelNode();
                    address.add("path", pathName);
                    result.add(MessagingPathHandlers.createAddOperation(address, modelNode.get(pathName)));
                }
                ++var8_70;
            }
        }
        if (subModel.hasDefined("address-setting")) {
            for (Property property : subModel.get("address-setting").asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add("address-setting", property.getName());
                result.add(AddressSettingAdd.createAddOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("broadcast-group")) {
            for (Property property : subModel.get("broadcast-group").asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add("broadcast-group", property.getName());
                result.add(BroadcastGroupAdd.getAddOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("discovery-group")) {
            for (Property property : subModel.get("discovery-group").asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add("discovery-group", property.getName());
                result.add(DiscoveryGroupAdd.getAddOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("divert")) {
            for (Property property : subModel.get("divert").asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add("divert", property.getName());
                result.add(DivertAdd.getAddOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("queue")) {
            for (Property property : subModel.get("queue").asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add("queue", property.getName());
                result.add(QueueAdd.getAddOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("bridge")) {
            for (Property property : subModel.get("bridge").asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add("bridge", property.getName());
                result.add(BridgeAdd.getAddOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("cluster-connection")) {
            for (Property property : subModel.get("cluster-connection").asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add("cluster-connection", property.getName());
                result.add(ClusterConnectionAdd.getAddOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("grouping-handler")) {
            Property property = subModel.get("grouping-handler").asProperty();
            ModelNode address = rootAddress.toModelNode();
            address.add("grouping-handler", property.getName());
            result.add(GroupingHandlerAdd.getAddOperation(address, property.getValue()));
        }
        if (subModel.hasDefined("connector-service")) {
            for (Property property : subModel.get("connector-service").asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add("connector-service", property.getName());
                ModelNode modelNode = property.getValue();
                result.add(ConnectorServiceAdd.getAddOperation(address, modelNode));
                if (!modelNode.hasDefined("param")) continue;
                for (Property param : modelNode.get("param").asPropertyList()) {
                    ModelNode paramAddress = address.clone().add("param", param.getName());
                    result.add(ConnectorServiceParamAdd.getAddOperation(paramAddress, param.getValue()));
                }
            }
        }
        if (subModel.hasDefined("connection-factory")) {
            for (Property property : subModel.get("connection-factory").asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add("connection-factory", property.getName());
                result.add(ConnectionFactoryAdd.getAddOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("pooled-connection-factory")) {
            for (Property property : subModel.get("pooled-connection-factory").asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add("pooled-connection-factory", property.getName());
                result.add(PooledConnectionFactoryAdd.getAddOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("jms-queue")) {
            for (Property property : subModel.get("jms-queue").asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add("jms-queue", property.getName());
                result.add(JMSQueueAdd.getOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("jms-topic")) {
            for (Property property : subModel.get("jms-topic").asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add("jms-topic", property.getName());
                result.add(JMSTopicAdd.getOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("security-setting")) {
            ModelNode modelNode = subModel.get("security-setting");
            for (Property setting : modelNode.asPropertyList()) {
                ModelNode modelNode2 = rootAddress.toModelNode();
                modelNode2.add("security-setting", setting.getName());
                result.add(SecuritySettingAdd.createAddOperation(modelNode2, setting.getValue()));
                ModelNode securitySetting = setting.getValue();
                if (!securitySetting.hasDefined("role")) continue;
                for (Property role : securitySetting.get("role").asPropertyList()) {
                    ModelNode address = modelNode2.clone();
                    address.add("role", role.getName());
                    result.add(SecurityRoleAdd.createAddOperation(address, role.getValue()));
                }
            }
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return new ModelNode();
    }
}

