/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.subsystem;

import java.util.Locale;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.jboss.as.cmp.keygenerator.KeyGeneratorFactory;
import org.jboss.as.cmp.keygenerator.hilo.HiLoKeyGeneratorFactory;
import org.jboss.as.cmp.subsystem.AbstractKeyGeneratorAdd;
import org.jboss.as.cmp.subsystem.CmpConstants;
import org.jboss.as.cmp.subsystem.CmpSubsystemDescriptions;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.txn.service.TransactionManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public class HiLoKeyGeneratorAdd
extends AbstractKeyGeneratorAdd {
    static HiLoKeyGeneratorAdd INSTANCE = new HiLoKeyGeneratorAdd();

    private HiLoKeyGeneratorAdd() {
    }

    @Override
    protected Service<KeyGeneratorFactory> getKeyGeneratorFactory(ModelNode operation) {
        HiLoKeyGeneratorFactory factory = new HiLoKeyGeneratorFactory();
        if (operation.hasDefined(CmpConstants.BLOCK_SIZE)) {
            factory.setBlockSize(operation.get(CmpConstants.BLOCK_SIZE).asLong());
        }
        if (operation.hasDefined(CmpConstants.CREATE_TABLE)) {
            factory.setCreateTable(operation.get(CmpConstants.CREATE_TABLE).asBoolean());
        }
        if (operation.hasDefined(CmpConstants.CREATE_TABLE_DDL)) {
            factory.setCreateTableDdl(operation.get(CmpConstants.CREATE_TABLE_DDL).asString());
        }
        if (operation.hasDefined(CmpConstants.DROP_TABLE)) {
            factory.setDropTable(operation.get(CmpConstants.DROP_TABLE).asBoolean());
        }
        if (operation.hasDefined(CmpConstants.ID_COLUMN)) {
            factory.setIdColumnName(operation.get(CmpConstants.ID_COLUMN).asString());
        }
        if (operation.hasDefined(CmpConstants.SELECT_HI_DDL)) {
            factory.setSelectHiSql(operation.get(CmpConstants.SELECT_HI_DDL).asString());
        }
        if (operation.hasDefined(CmpConstants.SEQUENCE_COLUMN)) {
            factory.setSequenceColumn(operation.get(CmpConstants.SEQUENCE_COLUMN).asString());
        }
        if (operation.hasDefined(CmpConstants.SEQUENCE_NAME)) {
            factory.setSequenceName(operation.get(CmpConstants.SEQUENCE_NAME).asString());
        }
        if (operation.hasDefined(CmpConstants.TABLE_NAME)) {
            factory.setTableName(operation.get(CmpConstants.TABLE_NAME).asString());
        }
        return factory;
    }

    @Override
    protected ServiceName getServiceName(String name) {
        return HiLoKeyGeneratorFactory.SERVICE_NAME.append(new String[]{name});
    }

    @Override
    protected void addDependencies(ModelNode operation, Service<KeyGeneratorFactory> keyGeneratorFactory, ServiceBuilder<KeyGeneratorFactory> factoryServiceBuilder) {
        HiLoKeyGeneratorFactory hiloFactory = (HiLoKeyGeneratorFactory)HiLoKeyGeneratorFactory.class.cast(keyGeneratorFactory);
        factoryServiceBuilder.addDependency(AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{operation.get(CmpConstants.DATA_SOURCE).asString()}), DataSource.class, hiloFactory.getDataSourceInjector());
        factoryServiceBuilder.addDependency(TransactionManagerService.SERVICE_NAME, TransactionManager.class, hiloFactory.getTransactionManagerInjector());
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        this.setOnModel(operation, model, CmpConstants.BLOCK_SIZE);
        this.setOnModel(operation, model, CmpConstants.CREATE_TABLE);
        this.setOnModel(operation, model, CmpConstants.CREATE_TABLE_DDL);
        this.setOnModel(operation, model, CmpConstants.DATA_SOURCE);
        this.setOnModel(operation, model, CmpConstants.DROP_TABLE);
        this.setOnModel(operation, model, CmpConstants.ID_COLUMN);
        this.setOnModel(operation, model, CmpConstants.SELECT_HI_DDL);
        this.setOnModel(operation, model, CmpConstants.SEQUENCE_COLUMN);
        this.setOnModel(operation, model, CmpConstants.SEQUENCE_NAME);
        this.setOnModel(operation, model, CmpConstants.TABLE_NAME);
    }

    private void setOnModel(ModelNode operation, ModelNode model, String attName) {
        if (operation.hasDefined(attName)) {
            model.get(attName).set(operation.get(attName));
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return CmpSubsystemDescriptions.getHiLoAddDescription(locale);
    }
}

