/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.jdbc.JDBCActivateEntityCommand;
import org.jboss.as.cmp.jdbc.JDBCCreateCommand;
import org.jboss.as.cmp.jdbc.JDBCDeclaredSQLQuery;
import org.jboss.as.cmp.jdbc.JDBCDeleteRelationsCommand;
import org.jboss.as.cmp.jdbc.JDBCDestroyCommand;
import org.jboss.as.cmp.jdbc.JDBCDynamicQLQuery;
import org.jboss.as.cmp.jdbc.JDBCEJBQLQuery;
import org.jboss.as.cmp.jdbc.JDBCFindAllQuery;
import org.jboss.as.cmp.jdbc.JDBCFindByPrimaryKeyQuery;
import org.jboss.as.cmp.jdbc.JDBCFindByQuery;
import org.jboss.as.cmp.jdbc.JDBCFindEntitiesCommand;
import org.jboss.as.cmp.jdbc.JDBCFindEntityCommand;
import org.jboss.as.cmp.jdbc.JDBCInitCommand;
import org.jboss.as.cmp.jdbc.JDBCInitEntityCommand;
import org.jboss.as.cmp.jdbc.JDBCInsertRelationsCommand;
import org.jboss.as.cmp.jdbc.JDBCIsModifiedCommand;
import org.jboss.as.cmp.jdbc.JDBCJBossQLQuery;
import org.jboss.as.cmp.jdbc.JDBCLoadEntityCommand;
import org.jboss.as.cmp.jdbc.JDBCLoadRelationCommand;
import org.jboss.as.cmp.jdbc.JDBCPassivateEntityCommand;
import org.jboss.as.cmp.jdbc.JDBCPostCreateEntityCommand;
import org.jboss.as.cmp.jdbc.JDBCQueryCommand;
import org.jboss.as.cmp.jdbc.JDBCRemoveEntityCommand;
import org.jboss.as.cmp.jdbc.JDBCStartCommand;
import org.jboss.as.cmp.jdbc.JDBCStopCommand;
import org.jboss.as.cmp.jdbc.JDBCStoreEntityCommand;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.metadata.JDBCEntityCommandMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.logging.Logger;

public class JDBCCommandFactory {
    private final Logger log;
    private final JDBCStoreManager manager;

    public JDBCCommandFactory(JDBCStoreManager manager) throws Exception {
        this.manager = manager;
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + manager.getEntityBridge().getEntityName()));
    }

    public JDBCQueryCommand createFindByPrimaryKeyQuery(JDBCQueryMetaData q) {
        return new JDBCFindByPrimaryKeyQuery(this.manager, q);
    }

    public JDBCQueryCommand createFindAllQuery(JDBCQueryMetaData q) {
        return new JDBCFindAllQuery(this.manager, q);
    }

    public JDBCQueryCommand createDeclaredSQLQuery(JDBCQueryMetaData q) {
        return new JDBCDeclaredSQLQuery(this.manager, q);
    }

    public JDBCQueryCommand createEJBQLQuery(JDBCQueryMetaData q) {
        return new JDBCEJBQLQuery(this.manager, q);
    }

    public JDBCQueryCommand createDynamicQLQuery(JDBCQueryMetaData q) {
        return new JDBCDynamicQLQuery(this.manager, q);
    }

    public JDBCQueryCommand createJBossQLQuery(JDBCQueryMetaData q) {
        return new JDBCJBossQLQuery(this.manager, q);
    }

    public JDBCQueryCommand createFindByQuery(JDBCQueryMetaData q) {
        return new JDBCFindByQuery(this.manager, q);
    }

    public JDBCLoadRelationCommand createLoadRelationCommand() {
        return new JDBCLoadRelationCommand(this.manager);
    }

    public JDBCDeleteRelationsCommand createDeleteRelationsCommand() {
        return new JDBCDeleteRelationsCommand(this.manager);
    }

    public JDBCInsertRelationsCommand createInsertRelationsCommand() {
        return new JDBCInsertRelationsCommand(this.manager);
    }

    public JDBCInitCommand createInitCommand() {
        return new JDBCInitCommand(this.manager);
    }

    public JDBCStartCommand createStartCommand() {
        return new JDBCStartCommand(this.manager);
    }

    public JDBCStopCommand createStopCommand() {
        return new JDBCStopCommand(this.manager);
    }

    public JDBCDestroyCommand createDestroyCommand() {
        return new JDBCDestroyCommand(this.manager);
    }

    public JDBCInitEntityCommand createInitEntityCommand() {
        return new JDBCInitEntityCommand(this.manager);
    }

    public JDBCFindEntityCommand createFindEntityCommand() {
        return new JDBCFindEntityCommand(this.manager);
    }

    public JDBCFindEntitiesCommand createFindEntitiesCommand() {
        return new JDBCFindEntitiesCommand(this.manager);
    }

    public JDBCCreateCommand createCreateEntityCommand() {
        JDBCCreateCommand cec;
        try {
            JDBCEntityCommandMetaData commandMetaData = this.manager.getMetaData().getEntityCommand();
            if (commandMetaData.getCommandClass() == null) {
                commandMetaData = this.manager.getMetaData().getJDBCApplication().getEntityCommandByName(commandMetaData.getCommandName());
            }
            cec = (JDBCCreateCommand)commandMetaData.getCommandClass().newInstance();
            cec.init(this.manager);
        }
        catch (Exception e) {
            throw CmpMessages.MESSAGES.couldNotCreateEntityCommand(e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("entity-command: " + this.manager.getMetaData().getEntityCommand()));
        }
        return cec;
    }

    public JDBCPostCreateEntityCommand createPostCreateEntityCommand() {
        return new JDBCPostCreateEntityCommand(this.manager);
    }

    public JDBCRemoveEntityCommand createRemoveEntityCommand() {
        return new JDBCRemoveEntityCommand(this.manager);
    }

    public JDBCLoadEntityCommand createLoadEntityCommand() {
        return new JDBCLoadEntityCommand(this.manager);
    }

    public JDBCIsModifiedCommand createIsModifiedCommand() {
        return new JDBCIsModifiedCommand(this.manager);
    }

    public JDBCStoreEntityCommand createStoreEntityCommand() {
        return new JDBCStoreEntityCommand(this.manager);
    }

    public JDBCActivateEntityCommand createActivateEntityCommand() {
        return new JDBCActivateEntityCommand(this.manager);
    }

    public JDBCPassivateEntityCommand createPassivateEntityCommand() {
        return new JDBCPassivateEntityCommand(this.manager);
    }
}

