/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.tomcat.idp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.api.saml.v2.sig.SAML2Signature;
import org.picketlink.identity.federation.bindings.tomcat.TomcatRoleGenerator;
import org.picketlink.identity.federation.bindings.tomcat.idp.SecurityActions;
import org.picketlink.identity.federation.core.config.IDPType;
import org.picketlink.identity.federation.core.config.KeyProviderType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.handler.config.Handlers;
import org.picketlink.identity.federation.core.impl.DelegatedAttributeManager;
import org.picketlink.identity.federation.core.interfaces.AttributeManager;
import org.picketlink.identity.federation.core.interfaces.ProtocolContext;
import org.picketlink.identity.federation.core.interfaces.RoleGenerator;
import org.picketlink.identity.federation.core.interfaces.TrustKeyConfigurationException;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.interfaces.TrustKeyProcessingException;
import org.picketlink.identity.federation.core.saml.v1.SAML11ProtocolContext;
import org.picketlink.identity.federation.core.saml.v1.writers.SAML11ResponseWriter;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.exceptions.IssuerNotTrustedException;
import org.picketlink.identity.federation.core.saml.v2.factories.SAML2HandlerChainFactory;
import org.picketlink.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChain;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.saml.v2.util.HandlerUtil;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.core.sts.PicketLinkCoreSTS;
import org.picketlink.identity.federation.core.util.CoreConfigUtil;
import org.picketlink.identity.federation.core.util.StaxUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.core.util.SystemPropertiesUtil;
import org.picketlink.identity.federation.core.util.XMLSignatureUtil;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AssertionType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AttributeStatementType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AttributeType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11NameIdentifierType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11StatementAbstractType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11SubjectType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11ResponseType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11StatusType;
import org.picketlink.identity.federation.saml.v2.SAML2Object;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.picketlink.identity.federation.web.config.AbstractSAMLConfigurationProvider;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.core.IdentityParticipantStack;
import org.picketlink.identity.federation.web.core.IdentityServer;
import org.picketlink.identity.federation.web.util.ConfigurationUtil;
import org.picketlink.identity.federation.web.util.IDPWebRequestUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingSignatureUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;
import org.picketlink.identity.federation.web.util.SAMLConfigurationProvider;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDPWebBrowserSSOValve
extends ValveBase
implements Lifecycle {
    private static Logger log = Logger.getLogger(IDPWebBrowserSSOValve.class);
    private final boolean trace = log.isTraceEnabled();
    protected IDPType idpConfiguration = null;
    private RoleGenerator roleGenerator = new TomcatRoleGenerator();
    private long assertionValidity = 5000L;
    private String identityURL = null;
    private TrustKeyManager keyManager;
    private Boolean ignoreIncomingSignatures = false;
    private Boolean signOutgoingMessages = true;
    private Boolean validatingAliasToTokenIssuer = false;
    private transient DelegatedAttributeManager attribManager = new DelegatedAttributeManager();
    private final List<String> attributeKeys = new ArrayList<String>();
    private transient SAML2HandlerChain chain = null;
    private Context context = null;
    private transient String samlHandlerChainClass = null;
    protected String canonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    protected SAMLConfigurationProvider configProvider = null;
    protected String identityParticipantStack = null;
    private final Lock chainLock = new ReentrantLock();
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    private boolean started = false;

    public void setAttributeList(String attribList) {
        if (StringUtil.isNotNull((String)attribList)) {
            this.attributeKeys.clear();
            this.attributeKeys.addAll(StringUtil.tokenize((String)attribList));
        }
    }

    public void setConfigProvider(String cp) {
        if (cp == null) {
            throw new IllegalStateException("PL00078: Null Parameter:" + cp);
        }
        Class<?> clazz = SecurityActions.loadClass(((Object)((Object)this)).getClass(), cp);
        if (clazz == null) {
            throw new RuntimeException("PL00085: Class Not Loaded:" + cp);
        }
        try {
            this.configProvider = (SAMLConfigurationProvider)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("PL00086: Cannot create instance of:" + cp + ":" + e.getMessage());
        }
    }

    public Boolean getIgnoreIncomingSignatures() {
        return this.ignoreIncomingSignatures;
    }

    public void setIgnoreIncomingSignatures(Boolean ignoreIncomingSignature) {
        this.ignoreIncomingSignatures = ignoreIncomingSignature;
    }

    public void setValidatingAliasToTokenIssuer(Boolean validatingAliasToTokenIssuer) {
        this.validatingAliasToTokenIssuer = validatingAliasToTokenIssuer;
    }

    public Boolean getValidatingAliasToTokenIssuer() {
        return this.validatingAliasToTokenIssuer;
    }

    public void setIgnoreAttributesGeneration(Boolean ignoreAttributes) {
        if (ignoreAttributes == Boolean.TRUE) {
            this.attribManager = null;
        }
    }

    public Boolean getSignOutgoingMessages() {
        return this.signOutgoingMessages;
    }

    public void setSignOutgoingMessages(Boolean signOutgoingMessages) {
        this.signOutgoingMessages = signOutgoingMessages;
    }

    public void setRoleGenerator(String rgName) {
        try {
            Class<?> clazz = SecurityActions.loadClass(((Object)((Object)this)).getClass(), rgName);
            if (clazz == null) {
                throw new RuntimeException("PL00085: Class Not Loaded:" + rgName);
            }
            this.roleGenerator = (RoleGenerator)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setSamlHandlerChainClass(String samlHandlerChainClass) {
        this.samlHandlerChainClass = samlHandlerChainClass;
    }

    public void setIdentityParticipantStack(String fqn) {
        this.identityParticipantStack = fqn;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        Principal userPrincipal;
        String referer = request.getHeader("Referer");
        String relayState = request.getParameter("RelayState");
        if (StringUtil.isNotNull((String)relayState)) {
            relayState = RedirectBindingUtil.urlDecode((String)relayState);
        }
        String samlRequestMessage = request.getParameter("SAMLRequest");
        String samlResponseMessage = request.getParameter("SAMLResponse");
        String signature = request.getParameter("Signature");
        String sigAlg = request.getParameter("SigAlg");
        boolean containsSAMLRequestMessage = StringUtil.isNotNull((String)samlRequestMessage);
        boolean containsSAMLResponseMessage = StringUtil.isNotNull((String)samlResponseMessage);
        Session session = request.getSessionInternal();
        if (containsSAMLRequestMessage || containsSAMLResponseMessage) {
            if (this.trace) {
                log.trace((Object)"Storing the SAMLRequest/SAMLResponse and RelayState in session");
            }
            if (StringUtil.isNotNull((String)samlRequestMessage)) {
                session.setNote("SAMLRequest", (Object)samlRequestMessage);
            }
            if (StringUtil.isNotNull((String)samlResponseMessage)) {
                session.setNote("SAMLResponse", (Object)samlResponseMessage);
            }
            if (StringUtil.isNotNull((String)relayState)) {
                session.setNote("RelayState", (Object)relayState.trim());
            }
            if (StringUtil.isNotNull((String)signature)) {
                session.setNote("Signature", (Object)signature.trim());
            }
            if (StringUtil.isNotNull((String)sigAlg)) {
                session.setNote("sigAlg", (Object)sigAlg.trim());
            }
        }
        if ((userPrincipal = request.getPrincipal()) == null) {
            try {
                this.getNext().invoke(request, response);
            }
            finally {
                userPrincipal = request.getPrincipal();
                referer = request.getHeader("Referer");
                if (this.trace) {
                    log.trace((Object)("Referer in finally block=" + referer + ":user principal=" + userPrincipal));
                }
            }
        }
        IDPWebRequestUtil webRequestUtil = new IDPWebRequestUtil((HttpServletRequest)request, this.idpConfiguration, this.keyManager);
        Document samlErrorResponse = null;
        if (response.getStatus() == 403) {
            try {
                samlErrorResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                holder.setResponseDoc(samlErrorResponse).setDestination(referer).setRelayState(relayState).setAreWeSendingRequest(false).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response);
                holder.setPostBindingRequested(webRequestUtil.hasSAMLRequestInPostProfile());
                if (this.signOutgoingMessages.booleanValue()) {
                    holder.setSupportSignature(true).setPrivateKey(this.keyManager.getSigningKey());
                    webRequestUtil.send(holder);
                }
                webRequestUtil.send(holder);
            }
            catch (GeneralSecurityException e) {
                throw new ServletException((Throwable)e);
            }
            return;
        }
        if (userPrincipal != null) {
            samlRequestMessage = (String)session.getNote("SAMLRequest");
            samlResponseMessage = (String)session.getNote("SAMLResponse");
            relayState = (String)session.getNote("RelayState");
            signature = (String)session.getNote("Signature");
            sigAlg = (String)session.getNote("sigAlg");
            if (this.trace) {
                StringBuilder builder = new StringBuilder();
                builder.append("Retrieved saml messages and relay state from session");
                builder.append("saml Request message=").append(samlRequestMessage);
                builder.append("::").append("SAMLResponseMessage=");
                builder.append(samlResponseMessage).append(":").append("relay state=").append(relayState);
                builder.append("Signature=").append(signature).append("::sigAlg=").append(sigAlg);
                log.trace((Object)builder.toString());
            }
            if (samlRequestMessage != null) {
                this.processSAMLRequestMessage(webRequestUtil, request, response);
            } else if (StringUtil.isNotNull((String)samlResponseMessage)) {
                this.processSAMLResponseMessage(webRequestUtil, request, response);
            } else {
                String target = request.getParameter("TARGET");
                if (StringUtil.isNotNull((String)target)) {
                    this.handleSAML11(webRequestUtil, request, response);
                } else {
                    if (this.trace) {
                        log.trace((Object)"SAML 1.1::Proceeding to IDP index page");
                    }
                    RequestDispatcher dispatch = this.context.getServletContext().getRequestDispatcher("/hosted/");
                    try {
                        dispatch.forward((ServletRequest)request, (ServletResponse)response);
                    }
                    catch (Exception e) {
                        dispatch.forward((ServletRequest)request.getRequest(), (ServletResponse)response);
                    }
                }
            }
        }
    }

    protected void handleSAML11(IDPWebRequestUtil webRequestUtil, Request request, Response response) throws ServletException, IOException {
        try {
            Principal userPrincipal = request.getPrincipal();
            String target = request.getParameter("TARGET");
            Session session = request.getSessionInternal();
            SAML11AssertionType saml11Assertion = (SAML11AssertionType)session.getNote("SAML11");
            if (saml11Assertion == null) {
                SAML11ProtocolContext saml11Protocol = new SAML11ProtocolContext();
                saml11Protocol.setIssuerID(this.identityURL);
                SAML11SubjectType subject = new SAML11SubjectType();
                SAML11SubjectType.SAML11SubjectTypeChoice subjectChoice = new SAML11SubjectType.SAML11SubjectTypeChoice(new SAML11NameIdentifierType(userPrincipal.getName()));
                subject.setChoice(subjectChoice);
                saml11Protocol.setSubjectType(subject);
                PicketLinkCoreSTS.instance().issueToken((ProtocolContext)saml11Protocol);
                saml11Assertion = saml11Protocol.getIssuedAssertion();
                session.setNote("SAML11", (Object)saml11Assertion);
                if (AssertionUtil.hasExpired((SAML11AssertionType)saml11Assertion)) {
                    saml11Protocol.setIssuedAssertion(saml11Assertion);
                    PicketLinkCoreSTS.instance().renewToken((ProtocolContext)saml11Protocol);
                    saml11Assertion = saml11Protocol.getIssuedAssertion();
                    session.setNote("SAML11", (Object)saml11Assertion);
                }
            }
            GenericPrincipal genericPrincipal = (GenericPrincipal)userPrincipal;
            String[] roles = genericPrincipal.getRoles();
            SAML11AttributeStatementType attributeStatement = this.createAttributeStatement(Arrays.asList(roles));
            saml11Assertion.add((SAML11StatementAbstractType)attributeStatement);
            String id = IDGenerator.create((String)"ID_");
            SAML11ResponseType saml11Response = new SAML11ResponseType(id, XMLTimeUtil.getIssueInstant());
            saml11Response.add(saml11Assertion);
            saml11Response.setStatus(SAML11StatusType.successType());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            SAML11ResponseWriter writer = new SAML11ResponseWriter(StaxUtil.getXMLStreamWriter((OutputStream)baos));
            writer.write(saml11Response);
            Document samlResponse = DocumentUtil.getDocument((InputStream)new ByteArrayInputStream(baos.toByteArray()));
            IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
            holder.setResponseDoc(samlResponse).setDestination(target).setRelayState("").setAreWeSendingRequest(false).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response);
            webRequestUtil.send(holder);
        }
        catch (GeneralSecurityException e) {
            log.error((Object)"Exception handling saml 11 use case:", (Throwable)e);
            throw new ServletException();
        }
    }

    protected void processSAMLRequestMessage(IDPWebRequestUtil webRequestUtil, Request request, Response response) throws IOException {
        block45: {
            Principal userPrincipal = request.getPrincipal();
            Session session = request.getSessionInternal();
            SAMLDocumentHolder samlDocumentHolder = null;
            SAML2Object samlObject = null;
            Document samlResponse = null;
            String destination = null;
            Boolean requestedPostProfile = null;
            String samlRequestMessage = (String)session.getNote("SAMLRequest");
            String relayState = (String)session.getNote("RelayState");
            String signature = (String)session.getNote("Signature");
            String sigAlg = (String)session.getNote("sigAlg");
            boolean willSendRequest = false;
            String referer = request.getHeader("Referer");
            this.cleanUpSessionNote(request);
            boolean isSecure = request.isSecure();
            String loginType = this.determineLoginType(isSecure);
            try {
                try {
                    samlDocumentHolder = webRequestUtil.getSAMLDocumentHolder(samlRequestMessage);
                    samlObject = samlDocumentHolder.getSamlObject();
                    if (!(samlObject instanceof RequestAbstractType)) {
                        throw new RuntimeException("PL00095: Wrong type:" + samlObject.getClass().getName());
                    }
                    RequestAbstractType requestAbstractType = (RequestAbstractType)samlObject;
                    String issuer = requestAbstractType.getIssuer().getValue();
                    boolean isPost = webRequestUtil.hasSAMLRequestInPostProfile();
                    String tokenSignatureValidatingAlias = this.getTokenSignatureValidatingAlias(request, issuer);
                    boolean isValid = this.validate(tokenSignatureValidatingAlias, request.getQueryString(), new SessionHolder(samlRequestMessage, signature, sigAlg), isPost);
                    if (!isValid) {
                        throw new GeneralSecurityException("PL00019: Validation check failed");
                    }
                    IssuerInfoHolder idpIssuer = new IssuerInfoHolder(this.identityURL);
                    HTTPContext protocolContext = new HTTPContext((HttpServletRequest)request, (HttpServletResponse)response, this.context.getServletContext());
                    DefaultSAML2HandlerRequest saml2HandlerRequest = new DefaultSAML2HandlerRequest((ProtocolContext)protocolContext, idpIssuer.getIssuer(), samlDocumentHolder, SAML2Handler.HANDLER_TYPE.IDP);
                    saml2HandlerRequest.setRelayState(relayState);
                    if (StringUtil.isNotNull((String)loginType)) {
                        saml2HandlerRequest.addOption("LOGIN_TYPE", (Object)loginType);
                    }
                    String assertionID = (String)session.getSession().getAttribute("ASSERTION_ID");
                    HashMap<String, Object> requestOptions = new HashMap<String, Object>();
                    if (this.ignoreIncomingSignatures.booleanValue()) {
                        requestOptions.put("IGNORE_SIGNATURES", Boolean.TRUE);
                    }
                    requestOptions.put("ROLE_GENERATOR", this.roleGenerator);
                    requestOptions.put("ASSERTIONS_VALIDITY", this.assertionValidity);
                    requestOptions.put("CONFIGURATION", this.idpConfiguration);
                    if (assertionID != null) {
                        requestOptions.put("ASSERTION_ID", assertionID);
                    }
                    if (this.keyManager != null) {
                        if (this.trace) {
                            log.trace((Object)("Remote Host=" + request.getRemoteAddr()));
                            log.trace((Object)("Validating Alias=" + tokenSignatureValidatingAlias));
                        }
                        PublicKey validatingKey = CoreConfigUtil.getValidatingKey((TrustKeyManager)this.keyManager, (String)tokenSignatureValidatingAlias);
                        requestOptions.put("SENDER_PUBLIC_KEY", validatingKey);
                        requestOptions.put("DECRYPTING_KEY", this.keyManager.getSigningKey());
                    }
                    Map attribs = this.attribManager.getAttributes(userPrincipal, this.attributeKeys);
                    requestOptions.put("ATTRIBUTES", attribs);
                    saml2HandlerRequest.setOptions(requestOptions);
                    List roles = this.roleGenerator.generateRoles(userPrincipal);
                    session.getSession().setAttribute("picketlink.roles", (Object)roles);
                    DefaultSAML2HandlerResponse saml2HandlerResponse = new DefaultSAML2HandlerResponse();
                    Set handlers = this.chain.handlers();
                    if (this.trace) {
                        log.trace((Object)("Handlers are=" + handlers));
                    }
                    webRequestUtil.isTrusted(issuer);
                    if (handlers != null) {
                        try {
                            this.chainLock.lock();
                            for (SAML2Handler handler : handlers) {
                                handler.handleRequestType((SAML2HandlerRequest)saml2HandlerRequest, (SAML2HandlerResponse)saml2HandlerResponse);
                                willSendRequest = saml2HandlerResponse.getSendRequest();
                            }
                        }
                        finally {
                            this.chainLock.unlock();
                        }
                    }
                    samlResponse = saml2HandlerResponse.getResultingDocument();
                    relayState = saml2HandlerResponse.getRelayState();
                    destination = saml2HandlerResponse.getDestination();
                    requestedPostProfile = saml2HandlerResponse.isPostBindingForResponse();
                }
                catch (Exception e) {
                    String status = JBossSAMLURIConstants.STATUS_AUTHNFAILED.get();
                    if (e instanceof IssuerNotTrustedException) {
                        status = JBossSAMLURIConstants.STATUS_REQUEST_DENIED.get();
                    }
                    log.error((Object)"Exception in processing request:", (Throwable)e);
                    samlResponse = webRequestUtil.getErrorResponse(referer, status, this.identityURL, this.signOutgoingMessages.booleanValue());
                    try {
                        boolean postProfile = webRequestUtil.hasSAMLRequestInPostProfile();
                        if (postProfile) {
                            this.recycle(response);
                        }
                        IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                        holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response);
                        if (requestedPostProfile != null) {
                            holder.setPostBindingRequested(requestedPostProfile.booleanValue());
                        } else {
                            holder.setPostBindingRequested(postProfile);
                        }
                        if (this.signOutgoingMessages.booleanValue()) {
                            holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                        }
                        webRequestUtil.send(holder);
                    }
                    catch (ParsingException e2) {
                        if (this.trace) {
                            log.trace((Object)"Parsing exception:", (Throwable)e2);
                        }
                        break block45;
                    }
                    catch (GeneralSecurityException e3) {
                        if (this.trace) {
                            log.trace((Object)"Security Exception:", (Throwable)e3);
                        }
                        break block45;
                    }
                }
            }
            catch (Throwable throwable) {
                block46: {
                    try {
                        boolean postProfile = webRequestUtil.hasSAMLRequestInPostProfile();
                        if (postProfile) {
                            this.recycle(response);
                        }
                        IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                        holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response);
                        if (requestedPostProfile != null) {
                            holder.setPostBindingRequested(requestedPostProfile.booleanValue());
                        } else {
                            holder.setPostBindingRequested(postProfile);
                        }
                        if (this.signOutgoingMessages.booleanValue()) {
                            holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                        }
                        webRequestUtil.send(holder);
                    }
                    catch (ParsingException e) {
                        if (this.trace) {
                            log.trace((Object)"Parsing exception:", (Throwable)e);
                        }
                    }
                    catch (GeneralSecurityException e) {
                        if (!this.trace) break block46;
                        log.trace((Object)"Security Exception:", (Throwable)e);
                    }
                }
                throw throwable;
            }
            try {
                boolean postProfile = webRequestUtil.hasSAMLRequestInPostProfile();
                if (postProfile) {
                    this.recycle(response);
                }
                IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response);
                if (requestedPostProfile != null) {
                    holder.setPostBindingRequested(requestedPostProfile.booleanValue());
                } else {
                    holder.setPostBindingRequested(postProfile);
                }
                if (this.signOutgoingMessages.booleanValue()) {
                    holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                }
                webRequestUtil.send(holder);
            }
            catch (ParsingException e) {
                if (this.trace) {
                    log.trace((Object)"Parsing exception:", (Throwable)e);
                }
            }
            catch (GeneralSecurityException e) {
                if (!this.trace) break block45;
                log.trace((Object)"Security Exception:", (Throwable)e);
            }
        }
    }

    private String getTokenSignatureValidatingAlias(Request request, String issuer) {
        String issuerHost;
        block3: {
            issuerHost = request.getRemoteAddr();
            if (this.validatingAliasToTokenIssuer.booleanValue()) {
                try {
                    issuerHost = new URL(issuer).getHost();
                }
                catch (MalformedURLException e) {
                    if (!this.trace) break block3;
                    log.trace((Object)("Token issuer is not a valid URL: " + issuer + ". Using the requester address instead."), (Throwable)e);
                }
            }
        }
        return issuerHost;
    }

    protected void processSAMLResponseMessage(IDPWebRequestUtil webRequestUtil, Request request, Response response) throws ServletException, IOException {
        block40: {
            Session session = request.getSessionInternal();
            SAMLDocumentHolder samlDocumentHolder = null;
            SAML2Object samlObject = null;
            Document samlResponse = null;
            String destination = null;
            boolean requestedPostProfile = false;
            String samlResponseMessage = (String)session.getNote("SAMLResponse");
            String relayState = (String)session.getNote("RelayState");
            String signature = (String)session.getNote("Signature");
            String sigAlg = (String)session.getNote("sigAlg");
            boolean willSendRequest = false;
            String referer = request.getHeader("Referer");
            this.cleanUpSessionNote(request);
            try {
                try {
                    samlDocumentHolder = webRequestUtil.getSAMLDocumentHolder(samlResponseMessage);
                    samlObject = samlDocumentHolder.getSamlObject();
                    if (!(samlObject instanceof StatusResponseType)) {
                        throw new RuntimeException("PL00095: Wrong type:" + samlObject.getClass().getName());
                    }
                    boolean isPost = webRequestUtil.hasSAMLRequestInPostProfile();
                    boolean isValid = false;
                    StatusResponseType statusResponseType = (StatusResponseType)samlObject;
                    String issuer = statusResponseType.getIssuer().getValue();
                    String tokenValidatingAlias = this.getTokenSignatureValidatingAlias(request, issuer);
                    if (isPost) {
                        SAML2Signature samlSignature = new SAML2Signature();
                        if (!this.ignoreIncomingSignatures.booleanValue() && this.signOutgoingMessages.booleanValue()) {
                            PublicKey publicKey = this.keyManager.getValidatingKey(tokenValidatingAlias);
                            isValid = samlSignature.validate(samlDocumentHolder.getSamlDocument(), publicKey);
                        } else {
                            isValid = true;
                        }
                    } else {
                        isValid = this.validate(tokenValidatingAlias, request.getQueryString(), new SessionHolder(samlResponseMessage, signature, sigAlg), isPost);
                    }
                    if (!isValid) {
                        throw new GeneralSecurityException("PL00019: Validation check failed");
                    }
                    IssuerInfoHolder idpIssuer = new IssuerInfoHolder(this.identityURL);
                    HTTPContext protocolContext = new HTTPContext((HttpServletRequest)request, (HttpServletResponse)response, this.context.getServletContext());
                    DefaultSAML2HandlerRequest saml2HandlerRequest = new DefaultSAML2HandlerRequest((ProtocolContext)protocolContext, idpIssuer.getIssuer(), samlDocumentHolder, SAML2Handler.HANDLER_TYPE.IDP);
                    saml2HandlerRequest.setRelayState(relayState);
                    DefaultSAML2HandlerResponse saml2HandlerResponse = new DefaultSAML2HandlerResponse();
                    Set handlers = this.chain.handlers();
                    webRequestUtil.isTrusted(issuer);
                    if (handlers != null) {
                        try {
                            this.chainLock.lock();
                            for (SAML2Handler handler : handlers) {
                                handler.reset();
                                handler.handleStatusResponseType((SAML2HandlerRequest)saml2HandlerRequest, (SAML2HandlerResponse)saml2HandlerResponse);
                                willSendRequest = saml2HandlerResponse.getSendRequest();
                            }
                        }
                        finally {
                            this.chainLock.unlock();
                        }
                    }
                    samlResponse = saml2HandlerResponse.getResultingDocument();
                    relayState = saml2HandlerResponse.getRelayState();
                    destination = saml2HandlerResponse.getDestination();
                    requestedPostProfile = saml2HandlerResponse.isPostBindingForResponse();
                }
                catch (Exception e) {
                    String status = JBossSAMLURIConstants.STATUS_AUTHNFAILED.get();
                    if (e instanceof IssuerNotTrustedException) {
                        status = JBossSAMLURIConstants.STATUS_REQUEST_DENIED.get();
                    }
                    log.error((Object)"Exception in processing request:", (Throwable)e);
                    samlResponse = webRequestUtil.getErrorResponse(referer, status, this.identityURL, this.signOutgoingMessages.booleanValue());
                    try {
                        boolean postProfile = webRequestUtil.hasSAMLRequestInPostProfile();
                        if (postProfile) {
                            this.recycle(response);
                        }
                        IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                        if (destination == null) {
                            throw new ServletException("PL00092: Null Value:Destination");
                        }
                        holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response).setPostBindingRequested(requestedPostProfile);
                        if (this.signOutgoingMessages.booleanValue()) {
                            holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                        }
                        webRequestUtil.send(holder);
                    }
                    catch (ParsingException e2) {
                        if (this.trace) {
                            log.trace((Object)"Parsing exception:", (Throwable)e2);
                        }
                        break block40;
                    }
                    catch (GeneralSecurityException e3) {
                        if (this.trace) {
                            log.trace((Object)"Security Exception:", (Throwable)e3);
                        }
                        break block40;
                    }
                }
            }
            catch (Throwable throwable) {
                block41: {
                    try {
                        boolean postProfile = webRequestUtil.hasSAMLRequestInPostProfile();
                        if (postProfile) {
                            this.recycle(response);
                        }
                        IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                        if (destination == null) {
                            throw new ServletException("PL00092: Null Value:Destination");
                        }
                        holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response).setPostBindingRequested(requestedPostProfile);
                        if (this.signOutgoingMessages.booleanValue()) {
                            holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                        }
                        webRequestUtil.send(holder);
                    }
                    catch (ParsingException e) {
                        if (this.trace) {
                            log.trace((Object)"Parsing exception:", (Throwable)e);
                        }
                    }
                    catch (GeneralSecurityException e) {
                        if (!this.trace) break block41;
                        log.trace((Object)"Security Exception:", (Throwable)e);
                    }
                }
                throw throwable;
            }
            try {
                boolean postProfile = webRequestUtil.hasSAMLRequestInPostProfile();
                if (postProfile) {
                    this.recycle(response);
                }
                IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                if (destination == null) {
                    throw new ServletException("PL00092: Null Value:Destination");
                }
                holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response).setPostBindingRequested(requestedPostProfile);
                if (this.signOutgoingMessages.booleanValue()) {
                    holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                }
                webRequestUtil.send(holder);
            }
            catch (ParsingException e) {
                if (this.trace) {
                    log.trace((Object)"Parsing exception:", (Throwable)e);
                }
            }
            catch (GeneralSecurityException e) {
                if (!this.trace) break block40;
                log.trace((Object)"Security Exception:", (Throwable)e);
            }
        }
    }

    protected void cleanUpSessionNote(Request request) {
        Session session = request.getSessionInternal();
        String samlRequestMessage = (String)session.getNote("SAMLRequest");
        String samlResponseMessage = (String)session.getNote("SAMLResponse");
        String relayState = (String)session.getNote("RelayState");
        String signature = (String)session.getNote("Signature");
        String sigAlg = (String)session.getNote("sigAlg");
        if (this.trace) {
            StringBuilder builder = new StringBuilder();
            builder.append("Retrieved saml messages and relay state from session");
            builder.append("saml Request message=").append(samlRequestMessage);
            builder.append("::").append("SAMLResponseMessage=");
            builder.append(samlResponseMessage).append(":").append("relay state=").append(relayState);
            builder.append("Signature=").append(signature).append("::sigAlg=").append(sigAlg);
            log.trace((Object)builder.toString());
        }
        if (StringUtil.isNotNull((String)samlRequestMessage)) {
            session.removeNote("SAMLRequest");
        }
        if (StringUtil.isNotNull((String)samlResponseMessage)) {
            session.removeNote("SAMLResponse");
        }
        if (StringUtil.isNotNull((String)relayState)) {
            session.removeNote("RelayState");
        }
        if (StringUtil.isNotNull((String)signature)) {
            session.removeNote("Signature");
        }
        if (StringUtil.isNotNull((String)sigAlg)) {
            session.removeNote("sigAlg");
        }
    }

    protected void sendErrorResponseToSP(String referrer, Response response, String relayState, IDPWebRequestUtil webRequestUtil) throws ServletException, IOException, ConfigurationException {
        if (this.trace) {
            log.trace((Object)("About to send error response to SP:" + referrer));
        }
        Document samlResponse = webRequestUtil.getErrorResponse(referrer, JBossSAMLURIConstants.STATUS_RESPONDER.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
        try {
            boolean postProfile = webRequestUtil.hasSAMLRequestInPostProfile();
            if (postProfile) {
                this.recycle(response);
            }
            IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
            holder.setResponseDoc(samlResponse).setDestination(referrer).setRelayState(relayState).setAreWeSendingRequest(false).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response);
            holder.setPostBindingRequested(postProfile);
            if (this.signOutgoingMessages.booleanValue()) {
                holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
            }
            webRequestUtil.send(holder);
        }
        catch (ParsingException e1) {
            throw new ServletException((Throwable)e1);
        }
        catch (GeneralSecurityException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected boolean validate(String remoteAddress, String queryString, SessionHolder holder, boolean isPost) throws IOException, GeneralSecurityException {
        if (!StringUtil.isNotNull((String)holder.samlRequest)) {
            return false;
        }
        if (!this.ignoreIncomingSignatures.booleanValue() && !isPost) {
            PublicKey validatingKey;
            String sig = holder.signature;
            if (!StringUtil.isNotNull((String)sig)) {
                log.error((Object)("Signature received from SP is null:" + remoteAddress));
                return false;
            }
            byte[] sigValue = RedirectBindingSignatureUtil.getSignatureValueFromSignedURL((String)queryString);
            if (sigValue == null) {
                return false;
            }
            try {
                validatingKey = this.keyManager.getValidatingKey(remoteAddress);
            }
            catch (TrustKeyConfigurationException e) {
                throw new GeneralSecurityException(e.getCause());
            }
            catch (TrustKeyProcessingException e) {
                throw new GeneralSecurityException(e.getCause());
            }
            return RedirectBindingSignatureUtil.validateSignature((String)queryString, (PublicKey)validatingKey, (byte[])sigValue);
        }
        return true;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        File stsTokenConfigFile;
        Handlers handlers = null;
        if (this.started) {
            throw new LifecycleException("PL00021: IDPWebBrowserSSOValve already Started");
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        SystemPropertiesUtil.ensure();
        if (StringUtil.isNullOrEmpty((String)this.samlHandlerChainClass)) {
            this.chain = SAML2HandlerChainFactory.createChain();
        } else {
            try {
                this.chain = SAML2HandlerChainFactory.createChain((String)this.samlHandlerChainClass);
            }
            catch (ProcessingException e1) {
                throw new LifecycleException((Throwable)e1);
            }
        }
        String configFile = "/WEB-INF/picketlink-idfed.xml";
        this.context = (Context)this.getContainer();
        InputStream is = this.context.getServletContext().getResourceAsStream(configFile);
        if (this.configProvider != null) {
            try {
                this.idpConfiguration = this.configProvider.getIDPConfiguration();
                if (is != null && this.configProvider instanceof AbstractSAMLConfigurationProvider) {
                    ((AbstractSAMLConfigurationProvider)this.configProvider).setConfigFile(is);
                }
            }
            catch (ProcessingException e) {
                throw new RuntimeException("PL00102: Processing Exception:" + e.getLocalizedMessage());
            }
            catch (ParsingException e) {
                throw new RuntimeException("PL00074: Parsing Error:" + e.getLocalizedMessage());
            }
        }
        if (this.idpConfiguration == null) {
            if (is == null) {
                throw new RuntimeException("PL00017: Configuration File missing:" + configFile);
            }
            try {
                this.idpConfiguration = ConfigurationUtil.getIDPConfiguration((InputStream)is);
            }
            catch (ParsingException e) {
                if (this.trace) {
                    log.trace((Object)e);
                }
                throw new RuntimeException("PL00102: Processing Exception:", e);
            }
        }
        try {
            this.identityURL = this.idpConfiguration.getIdentityURL();
            if (this.trace) {
                log.trace((Object)("Identity Provider URL=" + this.identityURL));
            }
            this.assertionValidity = this.idpConfiguration.getAssertionValidity();
            this.canonicalizationMethod = this.idpConfiguration.getCanonicalizationMethod();
            log.info((Object)("IDPWebBrowserSSOValve:: Setting the CanonicalizationMethod on XMLSignatureUtil::" + this.canonicalizationMethod));
            XMLSignatureUtil.setCanonicalizationMethodType((String)this.canonicalizationMethod);
            String attributeManager = this.idpConfiguration.getAttributeManager();
            if (attributeManager != null && !"".equals(attributeManager)) {
                Class<?> clazz = SecurityActions.loadClass(((Object)((Object)this)).getClass(), attributeManager);
                if (clazz == null) {
                    throw new RuntimeException("PL00085: Class Not Loaded:" + attributeManager);
                }
                AttributeManager delegate = (AttributeManager)clazz.newInstance();
                this.attribManager.setDelegate(delegate);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("PL00102: Processing Exception:", e);
        }
        PicketLinkCoreSTS sts = PicketLinkCoreSTS.instance();
        String configPath = this.context.getServletContext().getRealPath("/WEB-INF/picketlink-sts.xml");
        File file = stsTokenConfigFile = configPath != null ? new File(configPath) : null;
        if (stsTokenConfigFile == null || !stsTokenConfigFile.exists()) {
            log.info((Object)"Did not find picketlink-sts.xml. We will install default configuration");
            sts.installDefaultConfiguration(new String[0]);
        } else {
            sts.installDefaultConfiguration(new String[]{stsTokenConfigFile.toURI().toString()});
        }
        if (this.signOutgoingMessages.booleanValue()) {
            KeyProviderType keyProvider = this.idpConfiguration.getKeyProvider();
            if (keyProvider == null) {
                throw new LifecycleException("PL00092: Null Value:Key Provider is null for context=" + this.context.getName());
            }
            try {
                this.keyManager = CoreConfigUtil.getTrustKeyManager((KeyProviderType)keyProvider);
                List authProperties = CoreConfigUtil.getKeyProviderProperties((KeyProviderType)keyProvider);
                this.keyManager.setAuthProperties(authProperties);
                this.keyManager.setValidatingAlias(keyProvider.getValidatingAlias());
            }
            catch (Exception e) {
                log.error((Object)"Exception reading configuration:", (Throwable)e);
                throw new LifecycleException(e.getLocalizedMessage());
            }
            if (this.trace) {
                log.trace((Object)("Key Provider=" + keyProvider.getClassName()));
            }
        }
        try {
            String handlerConfigFileName = "/WEB-INF/picketlink-handlers.xml";
            handlers = ConfigurationUtil.getHandlers((InputStream)this.context.getServletContext().getResourceAsStream(handlerConfigFileName));
            this.chain.addAll((Collection)HandlerUtil.getHandlers((Handlers)handlers));
            HashMap<String, Object> chainConfigOptions = new HashMap<String, Object>();
            chainConfigOptions.put("ROLE_GENERATOR", this.roleGenerator);
            chainConfigOptions.put("CONFIGURATION", this.idpConfiguration);
            chainConfigOptions.put("CANONICALIZATION_METHOD", this.canonicalizationMethod);
            if (this.keyManager != null) {
                chainConfigOptions.put("KEYPAIR", this.keyManager.getSigningKeyPair());
            }
            DefaultSAML2HandlerChainConfig handlerChainConfig = new DefaultSAML2HandlerChainConfig(chainConfigOptions);
            Set samlHandlers = this.chain.handlers();
            for (SAML2Handler handler : samlHandlers) {
                handler.initChainConfig((SAML2HandlerChainConfig)handlerChainConfig);
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception dealing with handler configuration:", (Throwable)e);
            throw new LifecycleException(e.getLocalizedMessage());
        }
        String[] ak = new String[]{"mail", "cn", "commonname", "givenname", "surname", "employeeType", "employeeNumber", "facsimileTelephoneNumber"};
        this.attributeKeys.addAll(Arrays.asList(ak));
        IdentityServer identityServer = (IdentityServer)this.context.getServletContext().getAttribute("IDENTITY_SERVER");
        if (identityServer == null) {
            identityServer = new IdentityServer();
            this.context.getServletContext().setAttribute("IDENTITY_SERVER", (Object)identityServer);
            if (StringUtil.isNotNull((String)this.identityParticipantStack)) {
                try {
                    Class<?> clazz = SecurityActions.loadClass(((Object)((Object)this)).getClass(), this.identityParticipantStack);
                    if (clazz == null) {
                        throw new ClassNotFoundException("PL00085: Class Not Loaded:" + this.identityParticipantStack);
                    }
                    identityServer.setStack((IdentityParticipantStack)clazz.newInstance());
                }
                catch (Exception e) {
                    log.error((Object)"Unable to set the Identity Participant Stack Class. Will just use the default", (Throwable)e);
                }
            }
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException("PL00024: IDPWebBrowserSSOValve NotStarted");
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
    }

    private void recycle(Response response) {
        response.recycle();
    }

    protected String determineLoginType(boolean isSecure) {
        String auth;
        String result = JBossSAMLURIConstants.AC_PASSWORD.get();
        LoginConfig loginConfig = this.context.getLoginConfig();
        if (loginConfig != null && StringUtil.isNotNull((String)(auth = loginConfig.getAuthMethod()))) {
            if ("CLIENT-CERT".equals(auth)) {
                result = JBossSAMLURIConstants.AC_TLS_CLIENT.get();
            } else if (isSecure) {
                result = JBossSAMLURIConstants.AC_PASSWORD_PROTECTED_TRANSPORT.get();
            }
        }
        return result;
    }

    private SAML11AttributeStatementType createAttributeStatement(List<String> roles) {
        SAML11AttributeStatementType attrStatement = new SAML11AttributeStatementType();
        for (String role : roles) {
            SAML11AttributeType attr = new SAML11AttributeType("Role", URI.create("urn:picketlink:role"));
            attr.add((Object)role);
            attrStatement.add(attr);
        }
        return attrStatement;
    }

    protected static class SessionHolder {
        String samlRequest;
        String signature;
        String sigAlg;

        public SessionHolder(String req, String sig, String alg) {
            this.samlRequest = req;
            this.signature = sig;
            this.sigAlg = alg;
        }
    }
}

